/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import org.geotools.brewer.styling.builder.AbstractSLDBuilder;
import org.geotools.brewer.styling.builder.Builder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.brewer.styling.builder.StyledLayerDescriptorBuilder;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.styling.Style;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;

abstract class AbstractStyleBuilder<T>
extends AbstractSLDBuilder<T> {
    public AbstractStyleBuilder(AbstractSLDBuilder<?> parent) {
        super(parent);
    }

    protected Expression literal(Object literal) {
        return FF.literal(literal);
    }

    protected Expression property(String name) {
        return FF.property(name);
    }

    protected Expression cqlExpression(String cql) {
        try {
            return ECQL.toExpression((String)cql);
        }
        catch (CQLException e) {
            try {
                return CQL.toExpression((String)cql);
            }
            catch (CQLException cQLException) {
                throw new RuntimeException("Failed to build an expression out of CQL", e);
            }
        }
    }

    protected Filter cqlFilter(String cql) {
        try {
            return ECQL.toFilter((String)cql);
        }
        catch (CQLException e) {
            try {
                return CQL.toFilter((String)cql);
            }
            catch (CQLException cQLException) {
                throw new RuntimeException("Failed to build a filter out of CQL", e);
            }
        }
    }

    @Override
    protected void buildSLDInternal(StyledLayerDescriptorBuilder sb) {
        throw new UnsupportedOperationException("Implementation missing");
    }

    public Style buildStyle() {
        if (this.parent != null && this.parent instanceof AbstractStyleBuilder) {
            return ((AbstractStyleBuilder)this.parent).buildStyle();
        }
        StyleBuilder sb = new StyleBuilder();
        this.buildStyleInternal(sb);
        return sb.buildStyle();
    }

    @Override
    public Object buildRoot() {
        if (this.parent != null) {
            return this.parent.build();
        }
        return this.build();
    }

    protected abstract void buildStyleInternal(StyleBuilder var1);

    @Override
    protected void init(Builder<T> other) {
        this.reset(other.build());
    }

    @Override
    public AbstractStyleBuilder<T> unset() {
        this.reset();
        this.unset = true;
        return this;
    }

    @Override
    boolean isUnset() {
        return this.unset;
    }
}

