/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.ArrayList;
import java.util.List;

public class ValidationException
extends IllegalArgumentException {
    private final List<String> validationErrors = new ArrayList<String>();

    public ValidationException() {
        super("validation failed");
    }

    public ValidationException(Throwable cause) {
        super(cause);
    }

    public final ValidationException addValidationError(String error) {
        this.validationErrors.add(error);
        return this;
    }

    public final ValidationException addValidationErrors(Iterable<String> errors) {
        for (String error : errors) {
            this.validationErrors.add(error);
        }
        return this;
    }

    public final List<String> validationErrors() {
        return this.validationErrors;
    }

    @Override
    public final String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Validation Failed: ");
        int index = 0;
        for (String error : this.validationErrors) {
            sb.append(++index).append(": ").append(error).append(";");
        }
        return sb.toString();
    }
}

