/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.shard.ShardId;

public class FieldCapabilitiesIndexRequest
extends ActionRequest
implements IndicesRequest {
    public static final IndicesOptions INDICES_OPTIONS = IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    private final String[] fields;
    private final OriginalIndices originalIndices;
    private final QueryBuilder indexFilter;
    private final long nowInMillis;
    private final Map<String, Object> runtimeFields;
    private final ShardId shardId;

    FieldCapabilitiesIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.shardId = in.readOptionalWriteable(ShardId::new);
        if (in.getVersion().before(Version.V_7_16_0)) {
            in.readOptionalString();
        }
        this.fields = in.readStringArray();
        this.originalIndices = in.getVersion().onOrAfter(Version.V_6_2_0) ? OriginalIndices.readOriginalIndices(in) : OriginalIndices.NONE;
        this.indexFilter = in.getVersion().onOrAfter(Version.V_7_9_0) ? in.readOptionalNamedWriteable(QueryBuilder.class) : null;
        this.nowInMillis = in.getVersion().onOrAfter(Version.V_7_9_0) ? in.readLong() : 0L;
        this.runtimeFields = in.getVersion().onOrAfter(Version.V_7_12_0) ? in.readMap() : Collections.emptyMap();
    }

    FieldCapabilitiesIndexRequest(String[] fields, ShardId shardId, OriginalIndices originalIndices, QueryBuilder indexFilter, long nowInMillis, Map<String, Object> runtimeFields) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("specified fields can't be null or empty");
        }
        this.shardId = shardId;
        this.fields = fields;
        this.originalIndices = originalIndices;
        this.indexFilter = indexFilter;
        this.nowInMillis = nowInMillis;
        this.runtimeFields = runtimeFields;
    }

    public String[] fields() {
        return this.fields;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    public String index() {
        return this.shardId.getIndexName();
    }

    public QueryBuilder indexFilter() {
        return this.indexFilter;
    }

    public Map<String, Object> runtimeFields() {
        return this.runtimeFields;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.shardId);
        if (out.getVersion().before(Version.V_7_16_0)) {
            out.writeOptionalString(this.shardId.getIndexName());
        }
        out.writeStringArray(this.fields);
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        }
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            out.writeOptionalNamedWriteable(this.indexFilter);
            out.writeLong(this.nowInMillis);
        }
        if (out.getVersion().onOrAfter(Version.V_7_12_0)) {
            out.writeMap(this.runtimeFields);
        } else if (!this.runtimeFields.isEmpty()) {
            throw new IllegalArgumentException("Versions before 7.12.0 don't support [runtime_mappings], but trying to send _field_caps request to a node with version [" + out.getVersion() + "]");
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }
}

