/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.inspireatom;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.guiapi.search.XsltResponseWriter;
import org.fao.geonet.inspireatom.InspireAtomService;
import org.fao.geonet.inspireatom.util.InspireAtomUtil;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.InspireAtomFeedRepository;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/{portal}/api/atom"})
@Tag(name="atom", description="ATOM")
@RestController
public class AtomDescribe {
    @Autowired
    InspireAtomService service;
    @Autowired
    SettingManager sm;
    @Autowired
    DataManager dm;
    @Autowired
    InspireAtomFeedRepository inspireAtomFeedRepository;
    private static final String DATASET_IDENTIFIER_CODE_PARAM = "spatial_dataset_identifier_code";
    private static final String DATASET_IDENTIFIER_NS_PARAM = "spatial_dataset_identifier_namespace";
    private static final String SERVICE_IDENTIFIER = "fileIdentifier";

    @Operation(summary="Describe resource", description="")
    @GetMapping(value={"/describe/resource"}, produces={"application/atom+xml"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Feeds."), @ApiResponse(responseCode="204", description="Not authenticated.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Element describeResource(@Parameter(description="fileIdentifier", required=false) @RequestParam(defaultValue="") String fileIdentifier, @Parameter(description="spatial_dataset_identifier_code", required=false) @RequestParam(defaultValue="") String spatial_dataset_identifier_code, @Parameter(description="spatial_dataset_identifier_namespace", required=false) @RequestParam(defaultValue="") String spatial_dataset_identifier_namespace, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext((HttpServletRequest)request);
        boolean inspireEnable = this.sm.getValueAsBool("system/inspire/enable");
        if (!inspireEnable) {
            Log.info((String)"geonetwork.atom", (Object)"Inspire is disabled");
            throw new Exception("Inspire is disabled");
        }
        if (StringUtils.isEmpty((String)fileIdentifier)) {
            if (StringUtils.isEmpty((String)spatial_dataset_identifier_code)) {
                throw new MissingServletRequestParameterException(DATASET_IDENTIFIER_CODE_PARAM, "String");
            }
            if (StringUtils.isEmpty((String)spatial_dataset_identifier_namespace)) {
                throw new MissingServletRequestParameterException(DATASET_IDENTIFIER_NS_PARAM, "String");
            }
        }
        Element response = StringUtils.isEmpty((String)fileIdentifier) ? this.processDatasetFeed(spatial_dataset_identifier_code, spatial_dataset_identifier_namespace, context) : this.processServiceFeed(fileIdentifier, context);
        return new XsltResponseWriter(null, "atom-describe").withXml(response).withXsl("xslt/services/inspire-atom/describe.xsl").asElement();
    }

    private Element processDatasetFeed(String datasetIdCode, String datasetIdNs, ServiceContext context) throws Exception {
        DataManager dm = (DataManager)context.getBean(DataManager.class);
        InspireAtomService service = (InspireAtomService)context.getBean(InspireAtomService.class);
        Log.debug((String)"geonetwork.atom", (Object)("Processing dataset feed  (spatial_dataset_identifier_code: " + datasetIdCode + ", " + DATASET_IDENTIFIER_NS_PARAM + ": " + datasetIdNs + " )"));
        String datasetUuid = service.retrieveDatasetUuidFromIdentifierNs(datasetIdCode, datasetIdNs);
        if (StringUtils.isEmpty((String)datasetUuid)) {
            throw new MetadataNotFoundEx(datasetUuid);
        }
        String id = dm.getMetadataId(datasetUuid);
        if (StringUtils.isEmpty((String)id)) {
            throw new MetadataNotFoundEx(datasetUuid);
        }
        Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
        return service.retrieveFeed(context, Integer.parseInt(id));
    }

    private Element processServiceFeed(String fileIdentifier, ServiceContext context) throws Exception {
        Log.debug((String)"geonetwork.atom", (Object)("Processing service feed  (fileIdentifier: " + fileIdentifier + " )"));
        InspireAtomService service = (InspireAtomService)context.getBean(InspireAtomService.class);
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        String id = dm.getMetadataId(fileIdentifier);
        if (StringUtils.isEmpty((String)id)) {
            throw new MetadataNotFoundEx(fileIdentifier);
        }
        Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
        Element md = dm.getMetadata(id);
        String schema = dm.getMetadataSchema(id);
        if (!InspireAtomUtil.isServiceMetadata(dm, schema, md)) {
            throw new Exception("No service metadata found with uuid:" + fileIdentifier);
        }
        return service.retrieveFeed(context, Integer.parseInt(id));
    }
}

