/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.inspireatom.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.UnAuthorizedException;
import org.fao.geonet.inspireatom.model.DatasetFeedInfo;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class InspireAtomUtil {
    private static final String EXTRACT_DATASETS_FROM_SERVICE_XSLT = "extract-datasetinfo-from-service-feed.xsl";
    private static final String EXTRACT_DATASETS = "extract-datasets.xsl";
    private static final String EXTRACT_ATOM_FEED = "extract-atom-feed.xsl";
    private static final String TRANSFORM_MD_TO_ATOM_FEED = "inspire-atom-feed.xsl";
    private static final String TRANSFORM_ATOM_TO_OPENSEARCHDESCRIPTION = "opensearchdescription.xsl";
    public static final String LOCAL_OPENSEARCH_DESCRIPTION_FILE_NAME = "OpenSearchDescription.xml";
    public static final String LOCAL_OPENSEARCH_URL_SUFFIX = "opensearch";
    public static final String LOCAL_DESCRIBE_SERVICE_URL_SUFFIX = "atom/describe/service";
    public static final String LOCAL_DESCRIBE_DATASET_URL_SUFFIX = "atom/describe/dataset";
    public static final String LOCAL_DOWNLOAD_DATASET_URL_SUFFIX = "atom/download/dataset";

    private InspireAtomUtil() {
    }

    public static String retrieveRemoteAtomFeedDocument(ServiceContext context, String url) throws Exception {
        XmlRequest remoteRequest = ((GeonetHttpRequestFactory)context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(new URL(url));
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        Lib.net.setupProxy(sm, remoteRequest);
        Element atomFeed = remoteRequest.execute();
        return Xml.getString((Element)atomFeed);
    }

    public static String retrieveRemoteAtomFeedDocument(GeonetContext context, String url) throws Exception {
        XmlRequest remoteRequest = ((GeonetHttpRequestFactory)context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(new URL(url));
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        Lib.net.setupProxy(sm, remoteRequest);
        Element atomFeed = remoteRequest.execute();
        return Xml.getString((Element)atomFeed);
    }

    public static void filterDatasetFeedByCrs(Element feed, String crs) throws Exception {
        ArrayList<Element> elementsToRemove = new ArrayList<Element>();
        for (Element el : feed.getChildren()) {
            String term;
            Element catEl;
            String name = el.getName();
            if (!name.equalsIgnoreCase("entry") || (catEl = el.getChild("category", Namespace.getNamespace((String)"http://www.w3.org/2005/Atom"))) == null || StringUtils.contains((String)(term = catEl.getAttributeValue("term")), (String)crs)) continue;
            elementsToRemove.add(el);
        }
        for (Element element : elementsToRemove) {
            element.getParent().removeContent((Content)element);
        }
    }

    public static boolean isServiceMetadata(DataManager dm, String schema, Element md) throws Exception {
        Path styleSheet = dm.getSchemaDir(schema).resolve("extract-type.xsl");
        HashMap paramsM = new HashMap();
        String mdType = Xml.transform((Element)md, (Path)styleSheet, paramsM).getText().trim();
        return "service".equalsIgnoreCase(mdType);
    }

    public static List<String> extractRelatedDatasetsIdentifiers(String schema, Element md, DataManager dataManager) throws Exception {
        Path styleSheet = dataManager.getSchemaDir(schema).resolve(EXTRACT_DATASETS);
        List datasetsEl = Xml.transform((Element)md, (Path)styleSheet).getChildren();
        ArrayList<String> datasets = new ArrayList<String>();
        md.detach();
        for (Element datasetEl : datasetsEl) {
            String datasetId = datasetEl.getText();
            if (StringUtils.isEmpty((String)datasetId)) continue;
            datasets.add(datasetEl.getText());
        }
        return datasets;
    }

    public static List<DatasetFeedInfo> extractRelatedDatasetsInfoFromServiceFeed(String atomFeedDocument, DataManager dataManager) throws Exception {
        Element serviceFeed = Xml.loadString((String)atomFeedDocument, (boolean)false);
        Path defaultStyleSheet = dataManager.getSchemaDir("iso19139").resolve(EXTRACT_DATASETS_FROM_SERVICE_XSLT);
        HashMap params = new HashMap();
        Element atomIndexFields = Xml.transform((Element)serviceFeed, (Path)defaultStyleSheet, params);
        ArrayList<DatasetFeedInfo> datasetsInformation = new ArrayList<DatasetFeedInfo>();
        for (Object field : atomIndexFields.getChildren()) {
            Element f = (Element)field;
            if (!StringUtils.isNotEmpty((String)f.getChildText("identifier"))) continue;
            DatasetFeedInfo datasetFeedInfo = new DatasetFeedInfo(f.getChildText("identifier"), f.getChildText("namespace"), f.getChildText("feedUrl"));
            datasetsInformation.add(datasetFeedInfo);
        }
        return datasetsInformation;
    }

    public static Map<String, String> retrieveServiceMetadataWithAtomFeeds(DataManager dataManager, List<AbstractMetadata> iso19139Metadata, String atomProtocol) throws Exception {
        return InspireAtomUtil.processAtomFeedsInternal(dataManager, iso19139Metadata, "service", atomProtocol);
    }

    public static Map<String, String> retrieveServiceMetadataWithAtomFeed(DataManager dataManager, AbstractMetadata iso19139Metadata, String atomProtocol) throws Exception {
        ArrayList<AbstractMetadata> iso19139MetadataList = new ArrayList<AbstractMetadata>();
        iso19139MetadataList.add(iso19139Metadata);
        return InspireAtomUtil.retrieveServiceMetadataWithAtomFeeds(dataManager, iso19139MetadataList, atomProtocol);
    }

    public static Map<String, String> retrieveDatasetMetadataWithAtomFeeds(DataManager dataManager, List<AbstractMetadata> iso19139Metadata, String atomProtocol) throws Exception {
        return InspireAtomUtil.processAtomFeedsInternal(dataManager, iso19139Metadata, "dataset", atomProtocol);
    }

    private static Map<String, String> processAtomFeedsInternal(DataManager dataManager, List<AbstractMetadata> iso19139Metadata, String type, String atomProtocol) throws Exception {
        HashMap<String, String> metadataAtomFeeds = new HashMap<String, String>();
        for (AbstractMetadata md : iso19139Metadata) {
            int id = md.getId();
            String schema = md.getDataInfo().getSchemaId();
            Element mdEl = null;
            mdEl = md.getData() == null ? dataManager.getMetadata(id + "") : Xml.loadString((String)md.getData(), (boolean)false);
            String atomFeed = InspireAtomUtil.extractAtomFeedUrl(schema, mdEl, dataManager, atomProtocol);
            if (!StringUtils.isNotEmpty((String)atomFeed)) continue;
            metadataAtomFeeds.put(id + "", atomFeed);
        }
        return metadataAtomFeeds;
    }

    public static String extractAtomFeedUrl(String schema, Element md, DataManager dataManager, String atomProtocol) throws Exception {
        Path styleSheet = dataManager.getSchemaDir(schema).resolve(EXTRACT_ATOM_FEED);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("atomProtocol", atomProtocol);
        String atomFeed = Xml.transform((Element)md, (Path)styleSheet, params).getText().trim();
        md.detach();
        return atomFeed;
    }

    public static List<AbstractMetadata> searchMetadataByTypeAndProtocol(ServiceContext context, EsSearchManager searchMan, String type, String protocol) {
        String jsonQuery = "{    \"bool\": {      \"must\": [        {          \"term\": {            \"resourceType\": {              \"value\": \"%s\"            }          }        },         {          \"nested\": {            \"path\": \"link\",            \"query\": {              \"term\": {                \"link.protocol\": {                  \"value\": \"%s\"                }              }            }          }        }      ]    }}";
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<AbstractMetadata> allMdInfo = new ArrayList<AbstractMetadata>();
        try {
            JsonNode esJsonQuery = objectMapper.readTree(String.format(jsonQuery, type, protocol));
            SearchResponse result = searchMan.query(esJsonQuery, EsSearchManager.FIELDLIST_CORE, 0, 10000);
            IMetadataUtils dataManager = (IMetadataUtils)context.getBean(IMetadataUtils.class);
            for (SearchHit hit : result.getHits()) {
                String id = hit.getSourceAsMap().get("id").toString();
                allMdInfo.add(dataManager.findOne(id));
            }
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.atom", (String)ex.getMessage(), (Throwable)ex);
            return new ArrayList<AbstractMetadata>();
        }
        return allMdInfo;
    }

    public static String retrieveDatasetUuidFromIdentifier(EsSearchManager searchMan, String datasetIdCode) {
        String jsonQuery = "{    \"bool\": {      \"must\": [        {          \"term\": {            \"resourceIdentifier.code\": {              \"value\": \"%s\"            }          }        },        {          \"term\": {            \"isPublishedToAll\": {              \"value\": \"true\"            }          }        }      ]    }}";
        ObjectMapper objectMapper = new ObjectMapper();
        String id = "";
        try {
            JsonNode esJsonQuery = objectMapper.readTree(String.format(jsonQuery, datasetIdCode));
            SearchResponse result = searchMan.query(esJsonQuery, EsSearchManager.FIELDLIST_CORE, 0, 1);
            TotalHits totalHits = result.getHits().getTotalHits();
            if (totalHits != null && totalHits.value > 0L) {
                id = result.getHits().getAt(0).getId();
            }
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.atom", (String)ex.getMessage(), (Throwable)ex);
        }
        return id;
    }

    public static Element prepareServiceFeedEltBeforeTransform(String schema, Element md, DataManager dataManager) throws Exception {
        List<String> datasetsUuids = InspireAtomUtil.extractRelatedDatasetsIdentifiers(schema, md, dataManager);
        Element root = new Element("root");
        Element serviceElt = new Element("service");
        Element datasetElt = new Element("datasets");
        root.addContent((Content)serviceElt);
        md.addContent((Content)datasetElt);
        for (String uuid : datasetsUuids) {
            String id = dataManager.getMetadataId(uuid);
            if (StringUtils.isEmpty((String)id)) {
                throw new ResourceNotFoundException(String.format("Dataset '%s' attached to the requested service was not found. Check the link between the 2 records (see operatesOn element).", uuid));
            }
            Element ds = dataManager.getMetadata(id);
            datasetElt.addContent((Content)ds);
        }
        serviceElt.addContent((Content)md);
        return root;
    }

    public static Element prepareDatasetFeedEltBeforeTransform(Element md, String serviceMdUuid) throws Exception {
        Document doc = new Document(new Element("root"));
        doc.getRootElement().addContent((Content)new Element("dataset").addContent((Content)md));
        doc.getRootElement().addContent((Content)new Element("serviceIdentifier").setText(serviceMdUuid));
        return doc.getRootElement();
    }

    public static String convertIso19119ToAtomFeed(String schema, Element md, DataManager dataManager, boolean isLocal) throws Exception {
        Path styleSheet = dataManager.getSchemaDir(schema).resolve("convert/ATOM/").resolve(TRANSFORM_MD_TO_ATOM_FEED);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isLocal", isLocal);
        Element atomFeed = Xml.transform((Element)md, (Path)styleSheet, params);
        md.detach();
        return Xml.getString((Element)atomFeed);
    }

    public static Element convertDatasetMdToAtom(String schema, Element md, DataManager dataManager, Map<String, Object> params) throws Exception {
        Path styleSheet = InspireAtomUtil.getAtomFeedXSLStylesheet(schema, dataManager);
        return Xml.transform((Element)md, (Path)styleSheet, params);
    }

    private static Path getAtomFeedXSLStylesheet(String schema, DataManager dataManager) {
        return dataManager.getSchemaDir(schema).resolve("convert/ATOM/").resolve(TRANSFORM_MD_TO_ATOM_FEED);
    }

    public static Element getMetadataFeedByResourceIdentifier(ServiceContext context, String spIdentifier, String spNamespace, Map<String, Object> params, String requestedLanguage) throws Exception {
        EsSearchManager searchMan = (EsSearchManager)context.getBean(EsSearchManager.class);
        AbstractMetadata datasetMd = null;
        String jsonQuery = "{     \"term\": {       \"resourceIdentifier.code\": {         \"value\": \"%s\"       }     }}";
        ObjectMapper objectMapper = new ObjectMapper();
        IMetadataUtils repo = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        try {
            JsonNode esJsonQuery = objectMapper.readTree(String.format(jsonQuery, spIdentifier));
            SearchResponse result = searchMan.query(esJsonQuery, EsSearchManager.FIELDLIST_CORE, 0, 1);
            for (Object hit : result.getHits()) {
                datasetMd = repo.findOneByUuid(hit.getId());
            }
        }
        catch (Exception esJsonQuery) {
            // empty catch block
        }
        if (datasetMd == null) {
            throw new ResourceNotFoundException(String.format("No dataset found with resource identifier '%s'. Check that a record exist with hierarchy level is set to 'dataset' with a resource identifier set to '%s'.", spIdentifier, spIdentifier));
        }
        try {
            Lib.resource.checkPrivilege(context, String.valueOf(datasetMd.getId()), ReservedOperation.view);
        }
        catch (Exception e) {
            throw new UnAuthorizedException("Access denied to metadata " + datasetMd.getUuid(), (Object)e);
        }
        jsonQuery = "{    \"bool\": {      \"must\": [        {          \"terms\": {            \"recordOperateOn\": [              \"%s\", \"%s\"            ]          }        },         {          \"term\": {            \"serviceType\": {              \"value\": \"%s\"            }          }        }      ]    }}";
        AbstractMetadata serviceMetadata = null;
        try {
            JsonNode esJsonQuery = objectMapper.readTree(String.format(jsonQuery, datasetMd.getUuid(), spIdentifier, "download"));
            SearchResponse result = searchMan.query(esJsonQuery, EsSearchManager.FIELDLIST_CORE, 0, 1);
            for (SearchHit hit : result.getHits()) {
                serviceMetadata = repo.findOneByUuid(hit.getId());
            }
        }
        catch (Exception esJsonQuery) {
            // empty catch block
        }
        if (serviceMetadata == null) {
            throw new ResourceNotFoundException(String.format("No service operating the dataset '%s'. Check that a service is attached to that dataset and that its service type is set to 'download'.", datasetMd.getUuid()));
        }
        DataManager dm = (DataManager)context.getBean(DataManager.class);
        Element md = datasetMd.getXmlData(false);
        String schema = datasetMd.getDataInfo().getSchemaId();
        if (StringUtils.isBlank((String)requestedLanguage)) {
            String defaultLanguage = dm.extractDefaultLanguage(schema, md);
            requestedLanguage = XslUtil.twoCharLangCode((String)defaultLanguage);
        }
        Element inputDoc = InspireAtomUtil.prepareDatasetFeedEltBeforeTransform(md, serviceMetadata.getUuid());
        params.put("requestedLanguage", requestedLanguage);
        return InspireAtomUtil.convertDatasetMdToAtom(schema, inputDoc, dm, params);
    }

    public static Element prepareOpenSearchDescriptionEltBeforeTransform(ServiceContext context, Map<String, Object> params, String fileIdentifier, Element serviceAtomFeed, String defaultLanguage) throws Exception {
        List<String> keywords = InspireAtomUtil.retrieveKeywordsFromFileIdentifier(context, fileIdentifier);
        Namespace ns = serviceAtomFeed.getNamespace();
        Document doc = new Document(new Element("root"));
        Element response = new Element("response");
        doc.getRootElement().addContent((Content)response);
        response.addContent((Content)new Element("fileId").setText(fileIdentifier));
        response.addContent((Content)new Element("title").setText(serviceAtomFeed.getChildText("title", ns)));
        response.addContent((Content)new Element("subtitle").setText(serviceAtomFeed.getChildText("subtitle", ns)));
        ArrayList<Object> languages = new ArrayList<Object>();
        languages.add(XslUtil.twoCharLangCode((String)defaultLanguage));
        for (Element entry : serviceAtomFeed.getChildren("link", ns)) {
            Object language;
            if (!"application/atom+xml".equals(entry.getAttributeValue("type")) || (language = entry.getAttributeValue("hreflang")) == null || languages.contains(language)) continue;
            languages.add(language);
        }
        Element languagesEl = new Element("languages");
        for (String string : languages) {
            languagesEl.addContent((Content)new Element("language").setText(string));
        }
        response.addContent((Content)languagesEl);
        Element serviceAuthor = serviceAtomFeed.getChild("author", ns);
        if (serviceAuthor != null) {
            response.addContent((Content)new Element("authorName").setText(serviceAuthor.getChildText("name", ns)));
            response.addContent((Content)new Element("authorEmail").setText(serviceAuthor.getChildText("email", ns)));
        }
        response.addContent((Content)new Element("url").setText(serviceAtomFeed.getChildText("id", ns)));
        Element element = new Element("datasets");
        response.addContent((Content)element);
        Namespace inspiredlsns = serviceAtomFeed.getNamespace("inspire_dls");
        Iterator datasets = serviceAtomFeed.getChildren("entry", ns).iterator();
        ArrayList<String> fileTypes = new ArrayList<String>();
        while (datasets.hasNext()) {
            Integer count;
            String term;
            Element category;
            String authorName;
            Element dataset = (Element)datasets.next();
            String datasetIdCode = dataset.getChildText("spatial_dataset_identifier_code", inspiredlsns);
            String datasetIdNs = dataset.getChildText("spatial_dataset_identifier_namespace", inspiredlsns);
            Element datasetAtomFeed = null;
            try {
                datasetAtomFeed = InspireAtomUtil.getMetadataFeedByResourceIdentifier(context, datasetIdCode, datasetIdNs, params, XslUtil.twoCharLangCode((String)defaultLanguage));
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.atom", (Object)("No dataset metadata found with uuid:" + fileIdentifier));
                continue;
            }
            Element datasetEl = InspireAtomUtil.buildDatasetInfo(datasetIdCode, datasetIdNs);
            element.addContent((Content)datasetEl);
            Element author = datasetAtomFeed.getChild("author", ns);
            if (author != null && StringUtils.isNotBlank((String)(authorName = author.getChildText("name", ns)))) {
                datasetEl.addContent((Content)new Element("authorName").setText(authorName));
            }
            HashMap<String, Integer> downloadsCountByCrs = new HashMap<String, Integer>();
            for (Element entry : datasetAtomFeed.getChildren("entry", ns)) {
                String fileType;
                Element link;
                category = entry.getChild("category", ns);
                if (category != null) {
                    term = category.getAttributeValue("term");
                    count = (Integer)downloadsCountByCrs.get(term);
                    if (count == null) {
                        count = 0;
                    }
                    downloadsCountByCrs.put(term, count + 1);
                }
                if ((link = entry.getChild("link", ns)) == null || fileTypes.contains(fileType = link.getAttributeValue("type"))) continue;
                fileTypes.add(fileType);
            }
            for (Element entry : datasetAtomFeed.getChildren("entry", ns)) {
                category = entry.getChild("category", ns);
                if (category == null || (count = (Integer)downloadsCountByCrs.get(term = category.getAttributeValue("term"))) == null) continue;
                Element downloadEl = new Element("file");
                Element link = entry.getChild("link", ns);
                if (link != null) {
                    int iPos;
                    String title = link.getAttributeValue("title");
                    if (title != null && (iPos = title.indexOf(" in  -")) > -1) {
                        title = title.substring(0, iPos);
                    }
                    downloadEl.addContent((Content)new Element("title").setText(title));
                }
                Element lang = new Element("lang");
                if (link != null && StringUtils.isNotBlank((String)link.getAttributeValue("hreflang"))) {
                    lang.setText(link.getAttributeValue("hreflang"));
                } else {
                    lang.setText(XslUtil.twoCharLangCode((String)context.getLanguage()));
                }
                downloadEl.addContent((Content)lang);
                downloadEl.addContent((Content)new Element("url").setText(entry.getChildText("id", ns)));
                if (count > 1) {
                    downloadEl.addContent((Content)new Element("type").setText("application/atom+xml"));
                } else if (link != null) {
                    downloadEl.addContent((Content)new Element("type").setText(link.getAttributeValue("type")));
                }
                downloadEl.addContent((Content)new Element("crs").setText(term));
                downloadEl.addContent((Content)new Element("crsCount").setText("" + count));
                datasetEl.addContent((Content)downloadEl);
                downloadsCountByCrs.remove(term);
            }
        }
        response.addContent((Content)new Element("keywords").setText(StringUtils.join(keywords, (char)' ')));
        Element fileTypesEl = new Element("fileTypes");
        for (String fileType : fileTypes) {
            fileTypesEl.addContent((Content)new Element("fileType").setText(fileType));
        }
        response.addContent((Content)fileTypesEl);
        return doc.getRootElement();
    }

    public static Element convertServiceMdToOpenSearchDescription(ServiceContext context, Element md, Map<String, Object> params) throws Exception {
        Path styleSheet = InspireAtomUtil.getOpenSearchDesciptionXSLStylesheet(context);
        return Xml.transform((Element)md, (Path)styleSheet, params);
    }

    private static Path getOpenSearchDesciptionXSLStylesheet(ServiceContext context) {
        return context.getAppPath().resolve("xslt").resolve("services/inspire-atom/").resolve(TRANSFORM_ATOM_TO_OPENSEARCHDESCRIPTION);
    }

    private static Element buildDatasetInfo(String identifier, String namespace) {
        Element datasetEl = new Element("dataset");
        Element codeEl = new Element("code");
        codeEl.setText(identifier);
        Element namespaceEl = new Element("namespace");
        namespaceEl.setText(namespace);
        datasetEl.addContent((Content)codeEl);
        datasetEl.addContent((Content)namespaceEl);
        return datasetEl;
    }

    public static List<String> retrieveKeywordsFromFileIdentifier(ServiceContext context, String uuid) {
        EsSearchManager searchManager = (EsSearchManager)context.getBean(EsSearchManager.class);
        ArrayList<String> keywordsList = new ArrayList<String>();
        try {
            Map document = searchManager.getDocument(uuid);
            Object tags = document.get("tag");
            if (tags instanceof List) {
                ArrayList list = (ArrayList)tags;
                list.forEach(tag -> keywordsList.add((String)tag.get("default")));
            }
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.atom", (String)ex.getMessage(), (Throwable)ex);
        }
        return keywordsList;
    }
}

