/*
 * Decompiled with CFR 0.152.
 */
package v3110;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.fao.geonet.DatabaseMigrationTask;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.utils.Log;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class UpdateMetadataStatus
extends DatabaseMigrationTask {
    private MetadataStatusRepository metadataStatusRepository;
    private IMetadataUtils metadataUtils;

    public void setContext(ApplicationContext applicationContext) {
        super.setContext(applicationContext);
        this.metadataUtils = (IMetadataUtils)applicationContext.getBean(IMetadataUtils.class);
        this.metadataStatusRepository = (MetadataStatusRepository)applicationContext.getBean(MetadataStatusRepository.class);
    }

    public void update(Connection connection) throws SQLException {
        MetadataStatus metadataStatusObject = new MetadataStatus();
        DatabaseMetaDataDialectResolutionInfoAdapter dialectResolutionInfo = new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData());
        Dialect dialect = new StandardDialectResolver().resolveDialect((DialectResolutionInfo)dialectResolutionInfo);
        Log.debug((String)"geonetwork.database", (Object)"UpdateMetadataStatus");
        this.addMissingColumn(connection, dialect);
        this.updatePKValue(connection, dialect);
        this.updateOtherNewFields();
        connection.commit();
        this.finalizeChanges(connection, dialect);
    }

    private void addMissingColumn(Connection connection, Dialect dialect) throws SQLException {
        Throwable throwable;
        Statement statement;
        try {
            statement = connection.createStatement();
            throwable = null;
            try {
                statement.execute("ALTER TABLE MetadataStatus " + dialect.getAddColumnString() + "  " + MetadataStatus_.id.getName() + " INTEGER NULL");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.database", (Object)("  Exception while adding new " + MetadataStatus_.id.getName() + " column to " + "MetadataStatus" + ". Error is: " + e.getMessage()));
            Log.debug((String)"geonetwork.database", (Object)e);
        }
        try {
            statement = connection.createStatement();
            throwable = null;
            try {
                statement.execute("ALTER TABLE MetadataStatus " + dialect.getAddColumnString() + "  " + MetadataStatus_.uuid.getName() + " VARCHAR(255) NULL");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.database", (Object)("  Exception while adding new " + MetadataStatus_.uuid.getName() + " column to " + "MetadataStatus" + ". Error is: " + e.getMessage()));
            Log.debug((String)"geonetwork.database", (Object)e);
        }
        connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePKValue(Connection connection, Dialect dialect) throws SQLException {
        String HIBERNATE_SEQUENCE = this.getDatabaseObjectName(connection, "HIBERNATE_SEQUENCE");
        Integer rowcount = null;
        try (Statement statement = null;){
            statement = connection.createStatement();
            try {
                rowcount = statement.executeUpdate("update MetadataStatus set " + MetadataStatus_.id.getName() + " = " + dialect.getSelectSequenceNextValString("metadataStatus_id_seq") + " where " + MetadataStatus_.id.getName() + " IS NULL");
            }
            catch (SQLException e1) {
                try {
                    connection.rollback();
                    if (statement != null) {
                        statement.close();
                    }
                    statement = connection.createStatement();
                    rowcount = statement.executeUpdate("update MetadataStatus set " + MetadataStatus_.id.getName() + " = " + dialect.getSelectSequenceNextValString(HIBERNATE_SEQUENCE) + " where " + MetadataStatus_.id.getName() + " IS NULL");
                }
                catch (SQLException e2) {
                    throw new SQLException("Error updating table \"MetadataStatus." + MetadataStatus_.id.getName() + "\" values to sequence value using sequence \"" + "metadataStatus_id_seq" + "\" and \"" + HIBERNATE_SEQUENCE + "\"\n" + e1.getMessage() + "\n", e2);
                }
            }
        }
        connection.commit();
        Log.info((String)"geonetwork.database", (Object)("Migration: Updated " + rowcount + " primary key values for '" + "MetadataStatus" + "'"));
    }

    private void updateOtherNewFields() throws SQLException {
        Page page;
        PageRequest pageRequest = PageRequest.of((int)0, (int)1000, (Sort)Sort.by((String[])new String[]{"id"}));
        int totalRowCount = 0;
        int updateRowCount = 0;
        int uuidRowCount = 0;
        int titleRowCount = 0;
        HashMap titlesMap = new HashMap();
        HashMap<Integer, String> uuidMap = new HashMap<Integer, String>();
        do {
            if ((page = this.metadataStatusRepository.findAll((Pageable)pageRequest)) == null || !page.hasContent()) continue;
            for (MetadataStatus metadataStatus : page.getContent()) {
                ++totalRowCount;
                if (metadataStatus.getUuid() != null && metadataStatus.getUuid().length() != 0 && metadataStatus.getTitles() != null && metadataStatus.getTitles().size() != 0) continue;
                boolean changeflag = false;
                if (metadataStatus.getUuid() == null || metadataStatus.getUuid().length() == 0) {
                    String uuid = (String)uuidMap.get(metadataStatus.getMetadataId());
                    if (uuid == null) {
                        try {
                            uuid = this.metadataUtils.getMetadataUuid(Integer.toString(metadataStatus.getMetadataId()));
                            if (uuid != null) {
                                uuidMap.put(metadataStatus.getMetadataId(), uuid);
                            }
                        }
                        catch (Exception e) {
                            Log.error((String)"geonetwork.datamanager", (String)String.format("Error locating uuid for metadata id: %d", metadataStatus.getMetadataId()), (Throwable)e);
                        }
                        if (uuid == null || uuid.length() == 0) {
                            Log.error((String)"geonetwork.datamanager", (Object)String.format("Could not located uuid for metadata id: %d", metadataStatus.getMetadataId()));
                        }
                    }
                    if (uuid != null && uuid.length() > 0) {
                        metadataStatus.setUuid(uuid);
                        ++uuidRowCount;
                        changeflag = true;
                    }
                }
                if (metadataStatus.getTitles() == null || metadataStatus.getTitles().size() == 0) {
                    LinkedHashMap titles = (LinkedHashMap)titlesMap.get(metadataStatus.getMetadataId());
                    if (titles == null) {
                        LinkedHashMap<String, String> indexTitles = new LinkedHashMap<String, String>();
                        try {
                            String title = this.metadataUtils.getMetadataTitle(Integer.toString(metadataStatus.getMetadataId()));
                            if (title != null) {
                                indexTitles.put("eng", title);
                            }
                        }
                        catch (Exception e) {
                            Log.error((String)"geonetwork.datamanager", (String)String.format("Error locating titles for metadata id: %d", metadataStatus.getMetadataId()), (Throwable)e);
                        }
                    }
                    if (titles != null && titles.size() > 0) {
                        metadataStatus.setTitles(titles);
                        ++titleRowCount;
                        changeflag = true;
                    }
                }
                changeflag = true;
                if (!true) continue;
                ++updateRowCount;
                this.metadataStatusRepository.save((Object)metadataStatus);
                changeflag = false;
            }
        } while ((pageRequest = page.nextPageable()) != null && page.hasContent());
        Log.info((String)"geonetwork.database", (Object)("Migration: Updated " + updateRowCount + " records from a total of " + totalRowCount + " for talbe '" + "MetadataStatus" + "'. (uuid:" + uuidRowCount + ", Titles:" + titleRowCount + ")"));
    }

    private void finalizeChanges(Connection connection, Dialect dialect) throws SQLException {
        Throwable throwable;
        Statement statement;
        Throwable throwable2;
        Statement statement2;
        try {
            statement2 = connection.createStatement();
            throwable2 = null;
            try {
                statement2.execute("ALTER TABLE MetadataStatus " + this.getAlterTableNotNullString(connection, MetadataStatus_.id.getName(), "INTEGER"));
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (statement2 != null) {
                    if (throwable2 != null) {
                        try {
                            statement2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                    } else {
                        statement2.close();
                    }
                }
            }
        }
        catch (Exception e) {
            connection.rollback();
            Log.error((String)"geonetwork.database", (Object)("  Exception while modifying " + MetadataStatus_.id.getName() + " column of " + "MetadataStatus" + " to NOT NULL. Error is: " + e.getMessage()));
            Log.debug((String)"geonetwork.database", (Object)e);
        }
        connection.commit();
        try {
            statement2 = connection.createStatement();
            throwable2 = null;
            try {
                statement2.execute("ALTER TABLE MetadataStatus " + this.getAlterTableNotNullString(connection, MetadataStatus_.uuid.getName(), "VARCHAR(255)"));
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                if (statement2 != null) {
                    if (throwable2 != null) {
                        try {
                            statement2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        statement2.close();
                    }
                }
            }
        }
        catch (Exception e) {
            connection.rollback();
            Log.error((String)"geonetwork.database", (Object)("  Exception while modifying " + MetadataStatus_.uuid.getName() + " column of " + "MetadataStatus" + " to NOT NULL. Error is: " + e.getMessage()));
            Log.debug((String)"geonetwork.database", (Object)e);
        }
        connection.commit();
        String metadataStatusTableName = this.getDatabaseObjectName(connection, "MetadataStatus");
        String pkName = null;
        try {
            statement = connection.createStatement();
            throwable = null;
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                ResultSet pkResultSet = databaseMetaData.getPrimaryKeys(connection.getCatalog(), connection.getSchema(), metadataStatusTableName);
                if (pkResultSet.next()) {
                    pkName = pkResultSet.getString("PK_NAME");
                }
                if (pkName == null) {
                    throw new RuntimeException("Error getting primary key constraint name for table MetadataStatus");
                }
                statement.execute("ALTER TABLE MetadataStatus drop constraint " + pkName);
            }
            catch (Throwable databaseMetaData) {
                throwable = databaseMetaData;
                throw databaseMetaData;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable databaseMetaData) {
                            throwable.addSuppressed(databaseMetaData);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (Exception e) {
            connection.rollback();
            Log.error((String)"geonetwork.database", (Object)("  Exception while dropping old primary key constraint on table MetadataStatus. Restart application and check logs for database errors.  If errors exists then may need to manually drop the primary key for this table.Error is: " + e.getMessage()));
            Log.debug((String)"geonetwork.database", (String)"Full stack", (Throwable)e);
        }
        connection.commit();
        try {
            statement = connection.createStatement();
            throwable = null;
            try {
                statement.execute("ALTER TABLE MetadataStatus drop primary key");
            }
            catch (Throwable databaseMetaData) {
                throwable = databaseMetaData;
                throw databaseMetaData;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable databaseMetaData) {
                            throwable.addSuppressed(databaseMetaData);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (Exception e) {
            connection.rollback();
            Log.error((String)"geonetwork.database", (Object)("  Exception while dropping old primary key on table MetadataStatus. Restart application and check logs for database errors.  If errors exists then may need to manually drop the primary key for this table. Error is: " + e.getMessage()));
            Log.debug((String)"geonetwork.database", (String)"Full stack", (Throwable)e);
        }
        connection.commit();
        try {
            statement = connection.createStatement();
            throwable = null;
            try {
                statement.execute("ALTER TABLE MetadataStatus " + dialect.getAddPrimaryKeyConstraintString("MetadataStatusPk") + " (" + MetadataStatus_.id.getName() + ")");
            }
            catch (Throwable databaseMetaData) {
                throwable = databaseMetaData;
                throw databaseMetaData;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable databaseMetaData) {
                            throwable.addSuppressed(databaseMetaData);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (Exception e) {
            connection.rollback();
            Log.error((String)"geonetwork.database", (Object)("  Exception while adding primary key on " + MetadataStatus_.id.getName() + " column for " + "MetadataStatus" + ". Error is: " + e.getMessage()));
            Log.debug((String)"geonetwork.database", (String)"Full stack", (Throwable)e);
        }
        connection.commit();
        try {
            statement = connection.createStatement();
            throwable = null;
            try {
                String[] fkColumns = new String[]{"relatedMetadataStatusId"};
                String[] pkColumns = new String[]{MetadataStatus_.id.getName()};
                statement.execute("ALTER TABLE MetadataStatus " + dialect.getAddForeignKeyConstraintString("MetadataStatusRelMdStatusIdFk", fkColumns, "MetadataStatus", pkColumns, true));
                connection.commit();
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (Exception e) {
            connection.rollback();
            Log.error((String)"geonetwork.database", (Object)("  Exception while adding foreign key on relatedMetadataStatusId column of MetadataStatus. Error is: " + e.getMessage()));
            Log.debug((String)"geonetwork.database", (Object)e);
        }
    }

    private String getDatabaseObjectName(Connection connection, String objectName) throws SQLException {
        if (connection.getMetaData().getDriverName().matches("(?i).*postgres.*")) {
            return objectName.toLowerCase();
        }
        return objectName.toUpperCase();
    }

    private String getAlterTableNotNullString(Connection connection, String columnName, String datatype) throws SQLException {
        if (connection.getMetaData().getDriverName().matches("(?i).*postgres.*")) {
            return "alter column " + columnName.toLowerCase() + " SET NOT NULL";
        }
        return "modify " + columnName.toUpperCase() + " " + datatype + " NOT NULL";
    }
}

