/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.schema.iso19115_3_2018;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.kernel.schema.AssociatedResource;
import org.fao.geonet.kernel.schema.AssociatedResourcesSchemaPlugin;
import org.fao.geonet.kernel.schema.ExportablePlugin;
import org.fao.geonet.kernel.schema.ISOPlugin;
import org.fao.geonet.kernel.schema.LinkAwareSchemaPlugin;
import org.fao.geonet.kernel.schema.LinkPatternStreamer.ILinkBuilder;
import org.fao.geonet.kernel.schema.LinkPatternStreamer.RawLinkPatternStreamer;
import org.fao.geonet.kernel.schema.MultilingualSchemaPlugin;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.schema.iso19115_3_2018.ISO19115_3_2018Namespaces;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.xpath.XPath;

public class ISO19115_3_2018SchemaPlugin
extends SchemaPlugin
implements AssociatedResourcesSchemaPlugin,
MultilingualSchemaPlugin,
ExportablePlugin,
ISOPlugin,
LinkAwareSchemaPlugin {
    public static final String IDENTIFIER = "iso19115-3";
    private static final Pattern RECORD_ID_PATTERN = Pattern.compile(".*[i|I][d|D]=([_\\w\\-\\.\\{{\\}}]*).*");
    public static ImmutableSet<Namespace> allNamespaces = ImmutableSet.builder().add((Object)ISO19115_3_2018Namespaces.GCO).add((Object)ISO19115_3_2018Namespaces.MDB).add((Object)ISO19115_3_2018Namespaces.GEX).add((Object)ISO19115_3_2018Namespaces.MRC).add((Object)ISO19115_3_2018Namespaces.MRL).add((Object)ISO19115_3_2018Namespaces.LAN).add((Object)ISO19115_3_2018Namespaces.MRI).add((Object)ISO19115_3_2018Namespaces.CIT).add((Object)ISO19115_3_2018Namespaces.SRV).add((Object)ISO19115_3_2018Namespaces.XLINK).build();
    private static Map<String, Namespace> allTypenames = ImmutableMap.builder().put((Object)"csw:Record", (Object)Namespace.getNamespace((String)"csw", (String)"http://www.opengis.net/cat/csw/2.0.2")).put((Object)"mdb:MD_Metadata", (Object)Namespace.getNamespace((String)"mdb", (String)"http://standards.iso.org/iso/19115/-3/mdb/2.0")).put((Object)"gmd:MD_Metadata", (Object)Namespace.getNamespace((String)"gmd", (String)"http://www.isotc211.org/2005/gmd")).build();
    private static Map<String, String> allExportFormats = ImmutableMap.builder().put((Object)"convert/ISO19139/toISO19139.xsl", (Object)"metadata-iso19139.xml").build();
    private String parentAssociatedResourceType = null;

    public ISO19115_3_2018SchemaPlugin() {
        super(IDENTIFIER, allNamespaces);
    }

    public Set<AssociatedResource> getAssociatedResourcesUUIDs(Element metadata) {
        String xpathForAggregationInfo = "*//mri:associatedResource/*[mri:metadataReference/@uuidref and %s]";
        HashSet<AssociatedResource> listOfResources = new HashSet<AssociatedResource>();
        List sibs = null;
        try {
            sibs = Xml.selectNodes((Element)metadata, (String)String.format(xpathForAggregationInfo, StringUtils.isNotEmpty((String)this.parentAssociatedResourceType) ? String.format("mri:associationType/*/@codeListValue != '%s'", this.parentAssociatedResourceType) : "mri:associationType/mri:DS_AssociationTypeCode/@codeListValue != ''"), (List)allNamespaces.asList());
            for (Object o : sibs) {
                if (!(o instanceof Element)) continue;
                Element sib = (Element)o;
                AssociatedResource resource = this.metadataRefAsAssociatedResource(sib);
                listOfResources.add(resource);
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        return listOfResources;
    }

    public Set<String> getAssociatedParentUUIDs(Element metadata) {
        return this.getAssociatedParents(metadata).stream().map(AssociatedResource::getUuid).collect(Collectors.toSet());
    }

    public Set<AssociatedResource> getAssociatedParents(Element metadata) {
        Set<AssociatedResource> associatedResources = this.collectAssociatedResources(metadata, "mdb:parentMetadata");
        if (StringUtils.isNotEmpty((String)this.parentAssociatedResourceType)) {
            try {
                String XPATH_FOR_PARENT_IN_AGGRGATIONINFO = "*//mri:associatedResource/*[mri:associationType/*/@codeListValue = '%s']";
                List associatedParents = Xml.selectNodes((Element)metadata, (String)String.format(XPATH_FOR_PARENT_IN_AGGRGATIONINFO, this.parentAssociatedResourceType), (List)allNamespaces.asList());
                for (Object o : associatedParents) {
                    Element sib = (Element)o;
                    AssociatedResource resource = this.metadataRefAsAssociatedResource(sib);
                    associatedResources.add(resource);
                }
            }
            catch (JDOMException jDOMException) {
                // empty catch block
            }
        }
        return associatedResources;
    }

    public Set<String> getAssociatedDatasetUUIDs(Element metadata) {
        return this.getAssociatedDatasets(metadata).stream().map(AssociatedResource::getUuid).collect(Collectors.toSet());
    }

    public Set<AssociatedResource> getAssociatedDatasets(Element metadata) {
        return this.collectAssociatedResources(metadata, "*//srv:operatesOn", true);
    }

    public Set<String> getAssociatedFeatureCatalogueUUIDs(Element metadata) {
        return this.getAssociatedFeatureCatalogues(metadata).stream().map(AssociatedResource::getUuid).collect(Collectors.toSet());
    }

    public Set<AssociatedResource> getAssociatedFeatureCatalogues(Element metadata) {
        return this.collectAssociatedResources(metadata, "*//mrc:featureCatalogueCitation[@uuidref != '']");
    }

    public Set<String> getAssociatedSourceUUIDs(Element metadata) {
        return this.getAssociatedSources(metadata).stream().map(AssociatedResource::getUuid).collect(Collectors.toSet());
    }

    public Set<AssociatedResource> getAssociatedSources(Element metadata) {
        return this.collectAssociatedResources(metadata, "*//mrl:source[@uuidref != '']");
    }

    private Set<AssociatedResource> collectAssociatedResources(Element metadata, String xpath) {
        return this.collectAssociatedResources(metadata, xpath, false);
    }

    private Set<AssociatedResource> collectAssociatedResources(Element metadata, String xpath, boolean checkUuidInHref) {
        HashSet<AssociatedResource> associatedResources = new HashSet<AssociatedResource>();
        try {
            List parentMetadata = Xml.selectNodes((Element)metadata, (String)xpath, (List)allNamespaces.asList());
            for (Object o : parentMetadata) {
                Element sib = (Element)o;
                AssociatedResource resource = this.elementAsAssociatedResource(sib, checkUuidInHref);
                associatedResources.add(resource);
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        return associatedResources;
    }

    private AssociatedResource elementAsAssociatedResource(Element ref, boolean checkUuidInHref) {
        Matcher matcher;
        String title = ref.getAttributeValue("title", ISO19115_3_2018Namespaces.XLINK, "");
        String url = ref.getAttributeValue("href", ISO19115_3_2018Namespaces.XLINK, "");
        String sibUuid = ref.getAttributeValue("uuidref");
        if (StringUtils.isEmpty((String)sibUuid)) {
            sibUuid = ref.getTextNormalize();
        }
        if (checkUuidInHref && (matcher = RECORD_ID_PATTERN.matcher(url)).matches()) {
            sibUuid = matcher.group(1);
        }
        return new AssociatedResource(sibUuid, "", "", url, title);
    }

    private AssociatedResource metadataRefAsAssociatedResource(Element sibling) {
        Element ref = sibling.getChild("metadataReference", ISO19115_3_2018Namespaces.MRI);
        String sibUuid = ref.getAttributeValue("uuidref");
        String associationType = sibling.getChild("associationType", ISO19115_3_2018Namespaces.MRI).getChild("DS_AssociationTypeCode", ISO19115_3_2018Namespaces.MRI).getAttributeValue("codeListValue");
        String initType = "";
        Element initiativeTypeEl = sibling.getChild("initiativeType", ISO19115_3_2018Namespaces.MRI);
        if (initiativeTypeEl != null) {
            initType = initiativeTypeEl.getChild("DS_InitiativeTypeCode", ISO19115_3_2018Namespaces.MRI).getAttributeValue("codeListValue");
        }
        String title = ref.getAttributeValue("title", ISO19115_3_2018Namespaces.XLINK);
        String url = ref.getAttributeValue("href", ISO19115_3_2018Namespaces.XLINK);
        return new AssociatedResource(sibUuid, initType, associationType, url, title);
    }

    public List<Element> getTranslationForElement(Element element, String languageIdentifier) {
        String path = ".//lan:LocalisedCharacterString[@locale='#" + languageIdentifier + "']";
        try {
            XPath xpath = XPath.newInstance((String)path);
            List matches = xpath.selectNodes((Object)element);
            return matches;
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.schema-plugin", (Object)(this.getIdentifier() + ": getTranslationForElement failed on element " + Xml.getString((Element)element) + " using XPath '" + path + " Exception: " + e.getMessage()));
            return Collections.emptyList();
        }
    }

    public void addTranslationToElement(Element element, String languageIdentifier, String value) {
        element.setAttribute("type", "lan:PT_FreeText_PropertyType", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Element langElem = new Element("LocalisedCharacterString", ISO19115_3_2018Namespaces.LAN);
        langElem.setAttribute("locale", "#" + languageIdentifier);
        langElem.setText(value);
        Element textGroupElement = new Element("textGroup", ISO19115_3_2018Namespaces.LAN);
        textGroupElement.addContent((Content)langElem);
        Element freeTextElement = element.getChild("PT_FreeText", ISO19115_3_2018Namespaces.LAN);
        if (freeTextElement == null) {
            freeTextElement = new Element("PT_FreeText", ISO19115_3_2018Namespaces.LAN);
            element.addContent((Content)freeTextElement);
        }
        freeTextElement.addContent((Content)textGroupElement);
    }

    public Element removeTranslationFromElement(Element element, List<String> langs) throws JDOMException {
        String mainLanguage = langs != null && !langs.isEmpty() ? langs.get(0) : "#EN";
        List nodesWithStrings = Xml.selectNodes((Element)element, (String)"*//lan:PT_FreeText", Arrays.asList(ISO19115_3_2018Namespaces.LAN));
        for (Element e : nodesWithStrings) {
            List mainLangElement;
            Element mainCharacterString = ((Element)e.getParent()).getChild("CharacterString", ISO19115_3_2018Namespaces.GCO);
            if (mainCharacterString == null) {
                mainCharacterString = new Element("CharacterString", ISO19115_3_2018Namespaces.GCO);
                ((Element)e.getParent()).addContent(0, (Content)mainCharacterString);
            }
            if ((mainLangElement = Xml.selectNodes((Element)e, (String)("*//lan:LocalisedCharacterString[@locale='" + mainLanguage + "']"), Arrays.asList(ISO19115_3_2018Namespaces.LAN))).size() == 1) {
                String mainLangString = ((Element)mainLangElement.get(0)).getText();
                if (StringUtils.isNotEmpty((String)mainLangString)) {
                    mainCharacterString.setText(mainLangString);
                    continue;
                }
                if (mainCharacterString.getAttribute("nilReason", ISO19115_3_2018Namespaces.GCO) != null) continue;
                ((Element)mainCharacterString.getParent()).setAttribute("nilReason", "missing", ISO19115_3_2018Namespaces.GCO);
                continue;
            }
            if (!StringUtils.isEmpty((String)mainCharacterString.getText())) continue;
            ((Element)mainCharacterString.getParent()).setAttribute("nilReason", "missing", ISO19115_3_2018Namespaces.GCO);
        }
        List translationNodes = Xml.selectNodes((Element)element, (String)"*//node()[@locale]");
        for (Element el : translationNodes) {
            if (langs.size() > 1 && langs.contains(el.getAttribute("locale").getValue())) continue;
            Element parent = (Element)el.getParent();
            parent.detach();
        }
        for (Element el : nodesWithStrings) {
            if (!el.getChildren().isEmpty()) continue;
            el.detach();
        }
        return element;
    }

    public String getBasicTypeCharacterStringName() {
        return "gco:CharacterString";
    }

    public Element createBasicTypeCharacterString() {
        return new Element("CharacterString", ISO19115_3_2018Namespaces.GCO);
    }

    public Element addOperatesOn(Element serviceRecord, Map<String, String> layers, String serviceType, String baseUrl) {
        Element root = serviceRecord.getChild("identificationInfo", ISO19115_3_2018Namespaces.MDB).getChild("SV_ServiceIdentification", ISO19115_3_2018Namespaces.SRV);
        if (root != null) {
            Element couplingType = root.getChild("couplingType", ISO19115_3_2018Namespaces.SRV);
            int coupledResourceIdx = root.indexOf((Content)couplingType);
            layers.keySet().forEach(uuid -> {
                String layerName = (String)layers.get(uuid);
                Element coupledResource = new Element("coupledResource", ISO19115_3_2018Namespaces.SRV);
                coupledResource.setAttribute("nilReason", "synchronizedFromOGC", ISO19115_3_2018Namespaces.GCO);
                Element scr = new Element("SV_CoupledResource", ISO19115_3_2018Namespaces.SRV);
                Element operation = new Element("operation", ISO19115_3_2018Namespaces.SRV);
                Element operationMetadata = new Element("SV_OperationMetadata", ISO19115_3_2018Namespaces.SRV);
                Element operationName = new Element("operationName", ISO19115_3_2018Namespaces.SRV);
                Element operationValue = new Element("CharacterString", ISO19115_3_2018Namespaces.GCO);
                if (serviceType.startsWith("WMS")) {
                    operationValue.setText("GetMap");
                } else if (serviceType.startsWith("WFS")) {
                    operationValue.setText("GetFeature");
                } else if (serviceType.startsWith("WCS")) {
                    operationValue.setText("GetCoverage");
                } else if (serviceType.startsWith("WPS")) {
                    operationValue.setText("DescribeProcess");
                } else if (serviceType.startsWith("SOS")) {
                    operationValue.setText("GetObservation");
                }
                operationName.addContent((Content)operationValue);
                operationMetadata.addContent((Content)operationName);
                operation.addContent((Content)operationMetadata);
                Element id = new Element("resourceReference", ISO19115_3_2018Namespaces.SRV);
                id.setAttribute("uuidref", uuid);
                Element scopedName = new Element("scopedName", ISO19115_3_2018Namespaces.SRV);
                Element scopedNameValue = new Element("ScopedName", ISO19115_3_2018Namespaces.GCO);
                scopedNameValue.setText(layerName);
                scopedName.addContent((Content)scopedNameValue);
                scr.addContent((Content)scopedName);
                scr.addContent((Content)id);
                coupledResource.addContent((Content)scr);
                if (coupledResourceIdx != -1) {
                    root.addContent(coupledResourceIdx, (Content)coupledResource);
                }
                Element op = new Element("operatesOn", ISO19115_3_2018Namespaces.SRV);
                op.setAttribute("nilReason", "synchronizedFromOGC", ISO19115_3_2018Namespaces.GCO);
                op.setAttribute("uuidref", uuid);
                String hRefLink = baseUrl + "api/records/" + uuid + "/formatters/xml";
                op.setAttribute("href", hRefLink, ISO19115_3_2018Namespaces.XLINK);
                root.addContent((Content)op);
            });
        }
        return serviceRecord;
    }

    public List<ISOPlugin.Extent> getExtents(Element metadataRecord) {
        ArrayList<ISOPlugin.Extent> extents = new ArrayList<ISOPlugin.Extent>();
        ElementFilter bboxFinder = new ElementFilter("EX_GeographicBoundingBox", ISO19115_3_2018Namespaces.GEX);
        Iterator bboxes = metadataRecord.getDescendants((Filter)bboxFinder);
        while (bboxes.hasNext()) {
            Element box = (Element)bboxes.next();
            try {
                extents.add(new ISOPlugin.Extent(Double.valueOf(box.getChild("westBoundLongitude", ISO19115_3_2018Namespaces.GEX).getChild("Decimal", ISO19115_3_2018Namespaces.GCO).getText()), Double.valueOf(box.getChild("eastBoundLongitude", ISO19115_3_2018Namespaces.GEX).getChild("Decimal", ISO19115_3_2018Namespaces.GCO).getText()), Double.valueOf(box.getChild("southBoundLatitude", ISO19115_3_2018Namespaces.GEX).getChild("Decimal", ISO19115_3_2018Namespaces.GCO).getText()), Double.valueOf(box.getChild("northBoundLatitude", ISO19115_3_2018Namespaces.GEX).getChild("Decimal", ISO19115_3_2018Namespaces.GCO).getText())));
            }
            catch (NullPointerException nullPointerException) {}
        }
        return extents;
    }

    public Map<String, Namespace> getCswTypeNames() {
        return allTypenames;
    }

    public Map<String, String> getExportFormats() {
        return allExportFormats;
    }

    public Element processElement(Element el, String attributeRef, String parsedAttributeName, String attributeValue) {
        boolean elementToProcess;
        if (Log.isDebugEnabled((String)"geonetwork.schema-plugin")) {
            Log.debug((String)"geonetwork.schema-plugin", (Object)String.format("Processing element %s, attribute %s with attributeValue %s.", el, attributeRef, attributeValue));
        }
        if ((elementToProcess = this.isElementToProcess(el)) && parsedAttributeName.equals("xlink:href")) {
            Element targetElement;
            boolean isEmptyLink = StringUtils.isEmpty((String)attributeValue);
            boolean isMultilingualElement = el.getName().equals("LocalisedCharacterString");
            if (isMultilingualElement && (targetElement = el.getParentElement().getParentElement().getParentElement().getChild("CharacterString", ISO19115_3_2018Namespaces.GCO)) != null) {
                el = targetElement;
            }
            if (isEmptyLink) {
                el.setNamespace(ISO19115_3_2018Namespaces.GCO).setName("CharacterString");
                el.removeAttribute("href", ISO19115_3_2018Namespaces.XLINK);
                return el;
            }
            el.setNamespace(ISO19115_3_2018Namespaces.GCX).setName("Anchor");
            el.setAttribute("href", "", ISO19115_3_2018Namespaces.XLINK);
            return el;
        }
        if (elementToProcess && StringUtils.isNotEmpty((String)parsedAttributeName) && parsedAttributeName.startsWith(":")) {
            el.setAttribute(parsedAttributeName.substring(1), attributeValue);
            return el;
        }
        return super.processElement(el, attributeRef, parsedAttributeName, attributeValue);
    }

    protected boolean isElementToProcess(Element el) {
        if (el == null) {
            return false;
        }
        return this.elementsToProcess.contains(el.getQualifiedName());
    }

    public <L, M> RawLinkPatternStreamer<L, M> createLinkStreamer(ILinkBuilder<L, M> linkbuilder, String excludePattern) {
        RawLinkPatternStreamer patternStreamer = new RawLinkPatternStreamer(linkbuilder, excludePattern);
        patternStreamer.setNamespaces((List)allNamespaces.asList());
        patternStreamer.setRawTextXPath(".//*[name() = 'gco:CharacterString' or name() = 'lan:LocalisedCharacterString']");
        return patternStreamer;
    }

    public String getParentAssociatedResourceType() {
        return this.parentAssociatedResourceType;
    }

    public void setParentAssociatedResourceType(String parentAssociatedResourceType) {
        this.parentAssociatedResourceType = parentAssociatedResourceType;
    }
}

