/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.Page;
import com.github.sommeri.less4j.core.ast.PageMarginBox;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.compiler.selectors.UselessLessElementsRemover;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.NestedInRulesetStack;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class UnNestingAndBubbling {
    private final ASTManipulator manipulator = new ASTManipulator();
    private final UselessLessElementsRemover uselessLessElementsRemover = new UselessLessElementsRemover();

    public void unnestRulesetAndMedia(Body generalBody) {
        ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>(generalBody.getChilds());
        block6: for (ASTCssNode kid : childs) {
            BodyOwner bodyOwner;
            switch (kid.getType()) {
                case RULE_SET: {
                    List<ASTCssNode> nestedRulesets = this.collectNestedRuleSets((RuleSet)kid);
                    this.manipulator.addIntoBody(nestedRulesets, kid);
                    this.uselessLessElementsRemover.removeFrom((RuleSet)kid);
                    continue block6;
                }
                case MEDIA: {
                    Media media = (Media)kid;
                    this.unnestRulesetAndMedia(media.getBody());
                    continue block6;
                }
                case PAGE: {
                    Page page = (Page)kid;
                    this.unnestRulesetAndMedia(page.getBody());
                    continue block6;
                }
                case PAGE_MARGIN_BOX: {
                    PageMarginBox marginBox = (PageMarginBox)kid;
                    this.unnestRulesetAndMedia(marginBox.getBody());
                    continue block6;
                }
            }
            if (!(kid instanceof BodyOwner) || (bodyOwner = (BodyOwner)((Object)kid)).getBody() == null) continue;
            this.unnestRulesetAndMedia((Body)bodyOwner.getBody());
        }
    }

    private List<ASTCssNode> collectNestedRuleSets(RuleSet topLevelNode) {
        NestedInRulesetStack nestedNodesStack = new NestedInRulesetStack(topLevelNode);
        this.collectChildRuleSets(topLevelNode, nestedNodesStack);
        return nestedNodesStack.getRulesets();
    }

    private void collectChildRuleSets(ASTCssNode ownerNode, NestedInRulesetStack nestedNodes) {
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(ownerNode.getChilds());
        block4: for (ASTCssNode aSTCssNode : childs) {
            switch (aSTCssNode.getType()) {
                case RULE_SET: {
                    RuleSet nestedSet = (RuleSet)aSTCssNode;
                    this.manipulator.removeFromBody(nestedSet);
                    nestedNodes.collect(nestedSet);
                    nestedNodes.pushSelectors(nestedSet);
                    this.collectChildRuleSets(aSTCssNode, nestedNodes);
                    nestedNodes.popSelectors();
                    continue block4;
                }
                case MEDIA: {
                    List<Selector> outerSelectors = ArraysUtils.deeplyClonedList(nestedNodes.currentSelectors());
                    Media media = (Media)aSTCssNode;
                    this.manipulator.removeFromBody(media);
                    nestedNodes.collect(media);
                    this.putMediaBodyIntoRuleset(media, outerSelectors);
                    this.unnestRulesetAndMedia(media.getBody());
                    continue block4;
                }
            }
            if (!(aSTCssNode instanceof BodyOwner)) {
                this.collectChildRuleSets(aSTCssNode, nestedNodes);
                continue;
            }
            BodyOwner bodyOwner = (BodyOwner)((Object)aSTCssNode);
            if (bodyOwner.getBody() == null) continue;
            this.unnestRulesetAndMedia((Body)bodyOwner.getBody());
        }
    }

    private void putMediaBodyIntoRuleset(Media media, List<Selector> selectors) {
        RuleSet newRuleset = new RuleSet(media.getUnderlyingStructure(), media.getBody(), selectors);
        GeneralBody newMediaBody = new GeneralBody(media.getUnderlyingStructure());
        newMediaBody.addMember(newRuleset);
        media.setBody(newMediaBody);
        newMediaBody.configureParentToAllChilds();
        media.configureParentToAllChilds();
        newRuleset.configureParentToAllChilds();
    }
}

