/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.internal.io.fs.index.FSFnv1aInterleavedChecksumCalculator;

public class FSFnv1aOutputStream
extends OutputStream {
    private final OutputStream delegate;
    private final FSFnv1aInterleavedChecksumCalculator checksumCalculator;

    public FSFnv1aOutputStream(OutputStream delegate) {
        this.delegate = delegate;
        this.checksumCalculator = new FSFnv1aInterleavedChecksumCalculator();
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bytes = new byte[]{(byte)b};
        this.write(bytes);
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.update(data, 0, data.length);
        this.delegate.write(data);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        this.update(data, offset, length);
        this.delegate.write(data, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public void resetChecksum() {
        this.checksumCalculator.resetChecksum();
    }

    public int finalizeChecksum() {
        return this.checksumCalculator.finalizeChecksum();
    }

    private void update(byte[] bytes, int offset, int length) {
        this.checksumCalculator.update(bytes, offset, length);
    }
}

