/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.util.z3950;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fao.geonet.services.util.z3950.GNExplainInfoDTO;
import org.fao.geonet.utils.Log;
import org.jzkit.configuration.api.Configuration;
import org.jzkit.configuration.api.ConfigurationException;
import org.jzkit.search.ExplainInformationDTO;
import org.jzkit.search.impl.SearchSessionFactoryImpl;
import org.jzkit.search.util.Profile.AttrMappingDBO;
import org.jzkit.search.util.Profile.CrosswalkDBO;
import org.jzkit.search.util.QueryModel.Internal.AttrValue;
import org.springframework.context.ApplicationContext;

public class GNSearchSessionFactory
extends SearchSessionFactoryImpl {
    protected ApplicationContext appl_ctx;

    public void setApplicationContext(ApplicationContext ctx) {
        super.setApplicationContext(ctx);
        this.appl_ctx = ctx;
    }

    public ExplainInformationDTO explain() {
        ExplainInformationDTO result = new ExplainInformationDTO();
        Configuration directory = (Configuration)this.appl_ctx.getBean("JZKitConfig");
        try {
            Pattern p = Pattern.compile(".*\\.1\\.([0-9]+)$");
            Iterator it = directory.enumerateCrosswalks();
            ArrayList<GNExplainInfoDTO> list = new ArrayList<GNExplainInfoDTO>();
            while (it.hasNext()) {
                CrosswalkDBO cw = (CrosswalkDBO)it.next();
                for (String key : cw.getMappings().keySet()) {
                    String attrString;
                    Matcher m;
                    AttrMappingDBO attrmaping = (AttrMappingDBO)cw.getMappings().get(key);
                    if (attrmaping.getTargetAttrs().isEmpty() || !(m = p.matcher(attrString = ((AttrValue)attrmaping.getTargetAttrs().iterator().next()).getWithDefaultNamespace("geo"))).find()) continue;
                    String id = m.group(1);
                    GNExplainInfoDTO exl = new GNExplainInfoDTO(id);
                    exl.addMapping(attrmaping.getSourceAttrValue(), cw.getSourceNamespace());
                    list.add(exl);
                }
            }
            result.setDatabaseInfo(list);
        }
        catch (ConfigurationException ce) {
            Log.error((String)"geonetwork.sru", (String)("GNSearchSessionFactory - explain, error: " + ce.getMessage()), (Throwable)ce);
        }
        return result;
    }
}

