/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.url;

import com.google.common.base.Function;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.Nullable;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.fao.geonet.domain.LinkStatus;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import sun.net.ftp.FtpLoginException;

public class UrlChecker {
    @Autowired
    SettingManager settingManager;
    static String userAgentPropertyNameDefault = "GeoNetwork URL Link Checker";
    public String urlCheckerUserAgent = null;
    private final Function<HttpClientBuilder, Void> HTTP_CLIENT_CONFIGURATOR = new Function<HttpClientBuilder, Void>(){

        @Nullable
        public Void apply(@Nullable HttpClientBuilder originalConfig) {
            RequestConfig.Builder config = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000);
            RequestConfig requestConfig = config.build();
            originalConfig.setDefaultRequestConfig(requestConfig);
            originalConfig.setUserAgent(UrlChecker.this.getUserAgent());
            return null;
        }
    };
    @Autowired
    protected GeonetHttpRequestFactory requestFactory;

    public String getUserAgent() {
        if (this.urlCheckerUserAgent == null || this.urlCheckerUserAgent.contains("$")) {
            return userAgentPropertyNameDefault;
        }
        return this.urlCheckerUserAgent;
    }

    public void setUserAgent(String ua) {
        this.urlCheckerUserAgent = ua;
    }

    public LinkStatus getUrlStatus(String url) {
        try {
            if (url.startsWith("ftp")) {
                return this.getFTPStatus(url);
            }
            LinkStatus status = this.getUrlStatus(url, 5);
            Log.info((String)"geonetwork", (Object)("getUrlStatus for: " + url));
            Log.info((String)"geonetwork", (Object)("result: " + status));
            return status;
        }
        catch (Exception e) {
            return this.buildExceptionStatus(e);
        }
    }

    private LinkStatus getFTPStatus(String url) throws IOException {
        LinkStatus linkStatus = new LinkStatus();
        linkStatus.setFailing(Boolean.valueOf(false));
        try {
            URLConnection con = new URL(url).openConnection();
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            con.getInputStream().close();
            linkStatus.setStatusValue("OK");
            linkStatus.setStatusInfo("new URL(url).openStream() success.");
        }
        catch (FtpLoginException e) {
            linkStatus.setStatusValue("Need username/password");
            linkStatus.setStatusInfo("new URL(url).openStream() need username/password.");
        }
        return linkStatus;
    }

    private LinkStatus getUrlStatus(String url, int tryNumber) throws IOException {
        if (tryNumber < 1) {
            return this.buildTooManyRedirectStatus();
        }
        try (ClientHttpResponse response = this.getResponseFromServer(url);){
            HttpStatus statusCode = this.buildStatusCode(response);
            if (statusCode.is3xxRedirection() && response.getHeaders().containsKey((Object)"Location")) {
                LinkStatus linkStatus = this.getUrlStatus(response.getHeaders().getFirst("Location"), tryNumber - 1);
                return linkStatus;
            }
            LinkStatus linkStatus = this.buildStatus(response, !statusCode.is2xxSuccessful());
            return linkStatus;
        }
    }

    private ClientHttpResponse getResponseFromServer(final String url) throws IOException {
        HttpHead head = new HttpHead(url);
        Function<HttpClientBuilder, Void> HTTP_CLIENT_CONFIGURATOR2 = new Function<HttpClientBuilder, Void>(){

            @Nullable
            public Void apply(@Nullable HttpClientBuilder originalConfig) {
                UrlChecker.this.HTTP_CLIENT_CONFIGURATOR.apply((Object)originalConfig);
                String hostname = "";
                try {
                    URL _url = new URL(url);
                    hostname = _url.getHost();
                }
                catch (MalformedURLException e) {
                    Log.info((String)"geonetwork", (Object)("UrlChecker: cannot determine hostname from url: " + url));
                }
                Lib.net.setupProxy(UrlChecker.this.settingManager, originalConfig, hostname);
                return null;
            }
        };
        ClientHttpResponse response = this.requestFactory.execute((HttpUriRequest)head, (Function)HTTP_CLIENT_CONFIGURATOR2);
        if (!this.shouldTryGetInsteadOfHead(response.getRawStatusCode())) {
            return response;
        }
        HttpGet get = new HttpGet(url);
        return this.requestFactory.execute((HttpUriRequest)get, (Function)HTTP_CLIENT_CONFIGURATOR2);
    }

    private boolean shouldTryGetInsteadOfHead(int statusCode) {
        return statusCode == 404 || statusCode == 400 || statusCode == 405 || statusCode == 500;
    }

    private LinkStatus buildTooManyRedirectStatus() {
        LinkStatus linkStatus = new LinkStatus();
        linkStatus.setStatusValue("310");
        linkStatus.setStatusInfo("ERR_TOO_MANY_REDIRECTS");
        linkStatus.setFailing(Boolean.valueOf(true));
        return linkStatus;
    }

    private LinkStatus buildExceptionStatus(Exception e) {
        LinkStatus linkStatus = new LinkStatus();
        linkStatus.setStatusValue("4XX");
        linkStatus.setStatusInfo(e.getMessage());
        linkStatus.setFailing(Boolean.valueOf(true));
        return linkStatus;
    }

    private LinkStatus buildStatus(ClientHttpResponse response, boolean failed) throws IOException {
        LinkStatus linkStatus = new LinkStatus();
        linkStatus.setStatusValue(response.getRawStatusCode() + "");
        linkStatus.setStatusInfo(response.getStatusText());
        linkStatus.setFailing(Boolean.valueOf(failed));
        return linkStatus;
    }

    private HttpStatus buildStatusCode(ClientHttpResponse response) throws IOException {
        try {
            return response.getStatusCode();
        }
        catch (Exception e) {
            return HttpStatus.valueOf((int)(response.getRawStatusCode() / 100 * 100));
        }
    }
}

