/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import org.fao.geonet.kernel.security.SecurityProviderUtil;
import org.fao.geonet.kernel.security.openidconnect.OidcUser2GeonetworkUser;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;

public class OAuth2SecurityProviderUtil
implements SecurityProviderUtil {
    @Autowired
    OidcUser2GeonetworkUser oidcUser2GeonetworkUser;
    @Autowired
    private OAuth2AuthorizedClientManager authorizedClientManager;

    @Override
    public String getSSOAuthenticationHeaderValue() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken oauth2Token = (OAuth2AuthenticationToken)authentication;
            OAuth2AuthorizedClient authorizedClient = this.authorizedClientManager.authorize(OAuth2AuthorizeRequest.withClientRegistrationId((String)oauth2Token.getAuthorizedClientRegistrationId()).principal((Authentication)oauth2Token).build());
            if (authorizedClient != null && authorizedClient.getAccessToken() != null) {
                return "Bearer " + authorizedClient.getAccessToken().getTokenValue();
            }
            Log.warning((String)"geonetwork", (Object)"Unable to retrieve access token for OAuth2AuthenticationToken. Authorized client is null or access token is null.");
        }
        return null;
    }

    @Override
    public UserDetails getUserDetails(Authentication auth) {
        try {
            return this.getUserDetails(auth, false);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.security", (String)"OIDC: couldnt get user details from OIDC user", (Throwable)e);
            return null;
        }
    }

    public UserDetails getUserDetails(Authentication auth, boolean withDbUpdate) throws Exception {
        if (auth != null && auth.getPrincipal() instanceof OidcUser) {
            OidcUser user = (OidcUser)auth.getPrincipal();
            OidcIdToken idToken = user.getIdToken();
            return this.oidcUser2GeonetworkUser.getUserDetails(idToken, user.getAttributes(), withDbUpdate);
        }
        if (auth != null && auth.getPrincipal() instanceof OAuth2User) {
            OAuth2User user = (OAuth2User)auth.getPrincipal();
            return this.oidcUser2GeonetworkUser.getUserDetails(user.getAttributes(), withDbUpdate);
        }
        return null;
    }
}

