/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import java.util.Collection;
import org.fao.geonet.kernel.security.GeonetworkAuthenticationProvider;
import org.fao.geonet.kernel.security.openidconnect.OIDCConfiguration;
import org.fao.geonet.kernel.security.openidconnect.OIDCRoleProcessor;
import org.fao.geonet.kernel.security.openidconnect.SimpleOidcUser;
import org.fao.geonet.kernel.security.openidconnect.SimpleOidcUserFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.util.StringUtils;

public class GeonetworkOidcUserService
extends OidcUserService {
    @Autowired
    OIDCConfiguration oidcConfiguration;
    @Autowired
    OIDCRoleProcessor oidcRoleProcessor;
    @Autowired
    RoleHierarchy roleHierarchy;
    @Autowired
    GeonetworkAuthenticationProvider geonetworkAuthenticationProvider;
    @Autowired
    protected SimpleOidcUserFactory simpleOidcUserFactory;

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        Collection authorities;
        OidcUser user = super.loadUser(userRequest);
        if (!this.oidcConfiguration.isUpdateProfile()) {
            try {
                SimpleOidcUser simpleUser = this.simpleOidcUserFactory.create(user.getAttributes());
                UserDetails userDetails = this.geonetworkAuthenticationProvider.loadUserByUsername(simpleUser.getUsername());
                authorities = userDetails.getAuthorities();
            }
            catch (Exception ex) {
                authorities = this.createAuthorities((OAuth2User)user);
            }
        } else {
            authorities = this.createAuthorities((OAuth2User)user);
        }
        OidcUserInfo userInfo = user.getUserInfo();
        String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
        user = StringUtils.hasText((String)userNameAttributeName) ? new DefaultOidcUser(authorities, userRequest.getIdToken(), userInfo, userNameAttributeName) : new DefaultOidcUser(authorities, userRequest.getIdToken(), userInfo);
        return user;
    }

    Collection<? extends GrantedAuthority> createAuthorities(OAuth2User user) {
        return this.oidcRoleProcessor.createAuthorities(this.roleHierarchy, user);
    }
}

