/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class GeonetworkOidcLogoutHandler
implements LogoutSuccessHandler {
    @Autowired
    ServletContext servletContext;
    OidcClientInitiatedLogoutSuccessHandler oidcClientInitiatedLogoutSuccessHandler;

    public GeonetworkOidcLogoutHandler(OidcClientInitiatedLogoutSuccessHandler oidcClientInitiatedLogoutSuccessHandler) throws URISyntaxException {
        this.oidcClientInitiatedLogoutSuccessHandler = oidcClientInitiatedLogoutSuccessHandler;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.oidcClientInitiatedLogoutSuccessHandler.setPostLogoutRedirectUri(this.createPostLogoutRedirectUri(request));
        this.oidcClientInitiatedLogoutSuccessHandler.onLogoutSuccess(request, response, authentication);
    }

    private URI createPostLogoutRedirectUri(HttpServletRequest request) {
        String uri = "";
        try {
            String protocol = request.getScheme();
            String host = request.getServerName();
            int port = request.getServerPort();
            String path = this.servletContext.getContextPath();
            boolean isDefaultPort = "https".equalsIgnoreCase(protocol) && port == 443 || "http".equalsIgnoreCase(protocol) && port == 80;
            uri = protocol + "://" + host + (isDefaultPort ? "" : ":" + port) + path;
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            Log.debug((String)"geonetwork.security", (String)("OIDC Post Logout Redirect Uri is invalid.  Likely you can ignore this -" + uri), (Throwable)e);
            return null;
        }
    }
}

