/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.IllformedLocaleException;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.kernel.security.openidconnect.OAuth2SecurityProviderUtil;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2LoginAuthenticationFilter;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class GeonetworkOAuth2LoginAuthenticationFilter
extends OAuth2LoginAuthenticationFilter {
    @Autowired
    OAuth2SecurityProviderUtil oAuth2SecurityProviderUtil;

    public GeonetworkOAuth2LoginAuthenticationFilter(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService authorizedClientService) {
        super(clientRegistrationRepository, authorizedClientService);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        super.unsuccessfulAuthentication(request, response, failed);
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        String username = "UNIDENTIFIED";
        if (authResult == null) {
            throw new IOException("authresult is null!");
        }
        if (!(authResult instanceof OAuth2AuthenticationToken)) {
            return;
        }
        OAuth2AuthenticationToken oAuth2AuthenticationToken = (OAuth2AuthenticationToken)authResult;
        if (oAuth2AuthenticationToken.getPrincipal() == null || !(oAuth2AuthenticationToken.getPrincipal() instanceof OidcUser)) {
            throw new IOException("problem with principle - null or incorrect type");
        }
        OidcUser oidcUser = (OidcUser)oAuth2AuthenticationToken.getPrincipal();
        try {
            UserDetails userDetails = this.oAuth2SecurityProviderUtil.getUserDetails(authResult, true);
            if (userDetails != null) {
                username = userDetails.getUsername();
                Log.info((String)"geonetwork.security", (Object)("User '" + username + "' authenticated via OIDC"));
            }
        }
        catch (Exception e) {
            throw new IOException("OIDC: couldnt save user details", e);
        }
        try {
            block19: {
                SecurityContextHolder.getContext().setAuthentication(authResult);
                String redirectURL = this.findQueryParameter(request, "redirectUrl");
                if (redirectURL != null) {
                    try {
                        URI redirectUri = new URI(redirectURL);
                        if (redirectUri != null && !redirectUri.isAbsolute()) {
                            response.sendRedirect(redirectUri.toString());
                            break block19;
                        }
                        Log.warning((String)"geonetwork.security", (Object)("Failed to perform login redirect to '" + redirectURL + "'. Redirected to context home"));
                        response.sendRedirect(request.getContextPath());
                    }
                    catch (URISyntaxException e) {
                        response.sendRedirect(request.getContextPath());
                    }
                } else {
                    response.sendRedirect(request.getContextPath());
                }
            }
            String localeString = oidcUser.getLocale();
            if (!StringUtils.isEmpty((CharSequence)localeString)) {
                try {
                    try {
                        response.setLocale(new Locale.Builder().setLanguageTag(localeString).build());
                    }
                    catch (IllformedLocaleException e) {
                        response.setLocale(LocaleUtils.toLocale((String)localeString));
                    }
                }
                catch (IllegalArgumentException e) {
                    Log.warning((String)"geonetwork.security", (Object)("Unable to parse oidc locale " + oidcUser.getLocale() + ": " + e.getMessage()));
                }
            }
            if (this.eventPublisher != null) {
                this.eventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent(authResult, ((Object)((Object)this)).getClass()));
            }
        }
        catch (Exception ex) {
            Log.warning((String)"geonetwork.security", (Object)("Error during OIDC login for user " + username + ": " + ex.getMessage()), (Throwable)ex);
        }
    }

    String findQueryParameter(HttpServletRequest request, String parmName) {
        if (request.getQueryString() == null) {
            return null;
        }
        try {
            String uri = request.getContextPath() + "?" + request.getQueryString();
            MultiValueMap parameters = UriComponentsBuilder.fromUriString((String)uri).build().getQueryParams();
            if (!parameters.containsKey((Object)parmName)) {
                return null;
            }
            String result = (String)parameters.getFirst((Object)parmName);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

