/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.listener;

import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.User;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.utils.Log;
import org.keycloak.KeycloakPrincipal;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.authentication.switchuser.AuthenticationSwitchUserEvent;

public class UpdateTimestampListener
implements ApplicationListener<AbstractAuthenticationEvent> {
    public void onApplicationEvent(AbstractAuthenticationEvent e) {
        UserRepository userRepo = (UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class);
        if (e instanceof InteractiveAuthenticationSuccessEvent || e instanceof AuthenticationSuccessEvent || e instanceof AuthenticationSwitchUserEvent) {
            try {
                Object principal = e.getAuthentication().getPrincipal();
                String username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : (principal instanceof KeycloakPrincipal && ((KeycloakPrincipal)e.getAuthentication().getPrincipal()).getKeycloakSecurityContext().getIdToken() != null ? ((KeycloakPrincipal)e.getAuthentication().getPrincipal()).getKeycloakSecurityContext().getIdToken().getPreferredUsername() : (principal instanceof OidcUser ? ((OidcUser)principal).getPreferredUsername() : (principal instanceof OAuth2User ? (String)((OAuth2User)principal).getAttribute("preferred_username") : principal.toString())));
                User user = userRepo.findOneByUsername(username);
                if (user != null) {
                    user.setLastLoginDate(new ISODate().toString());
                    userRepo.save((Object)user);
                }
            }
            catch (Exception ex) {
                Log.error((String)"geonetwork", (String)("UpdateTimestampListener error: " + ex.getMessage()), (Throwable)ex);
            }
        }
    }
}

