/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.metadata;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.domain.StatusValueNotificationLevel;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.domain.User;
import org.fao.geonet.events.md.MetadataStatusChanged;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.metadata.StatusActions;
import org.fao.geonet.kernel.metadata.StatusChangeType;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.FeedbackLanguages;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.GroupSpecs;
import org.fao.geonet.util.LocalizedEmail;
import org.fao.geonet.util.LocalizedEmailComponent;
import org.fao.geonet.util.LocalizedEmailParameter;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

public class DefaultStatusActions
implements StatusActions {
    protected ServiceContext context;
    protected String language;
    protected DataManager dm;
    @Autowired
    protected IMetadataUtils metadataUtils;
    protected String siteUrl;
    protected String siteName;
    protected UserSession session;
    protected boolean emailNotes = true;
    private String replyTo;
    private String replyToDescr;
    private StatusValueRepository statusValueRepository;
    protected IMetadataStatus metadataStatusManager;
    private IMetadataUtils metadataRepository;

    @Override
    public void init(ServiceContext context) throws Exception {
        this.context = context;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        this.statusValueRepository = (StatusValueRepository)applicationContext.getBean(StatusValueRepository.class);
        this.metadataUtils = (IMetadataUtils)applicationContext.getBean(IMetadataUtils.class);
        this.language = context.getLanguage();
        SettingManager sm = (SettingManager)applicationContext.getBean(SettingManager.class);
        this.siteName = sm.getSiteName();
        String from = sm.getValue("system/feedback/email");
        if (from == null || from.length() == 0) {
            context.error("Mail feedback address not configured, email notifications won't be sent.");
            this.emailNotes = false;
        }
        this.session = context.getUserSession();
        this.replyTo = this.session.getEmailAddr();
        if (this.replyTo != null) {
            this.replyToDescr = this.session.getName() + " " + this.session.getSurname();
        } else {
            this.replyTo = from;
            this.replyToDescr = this.siteName;
        }
        this.dm = (DataManager)applicationContext.getBean(DataManager.class);
        this.metadataStatusManager = (IMetadataStatus)applicationContext.getBean(IMetadataStatus.class);
        this.siteUrl = sm.getSiteURL(context);
        this.metadataRepository = context.getBean(IMetadataUtils.class);
    }

    @Override
    public void onEdit(int id, boolean minorEdit) throws Exception {
        if (Log.isTraceEnabled((String)"geonetwork.datamanager")) {
            Log.trace((String)"geonetwork.datamanager", (Object)("DefaultStatusActions.onEdit(" + id + ", " + minorEdit + ") with status " + this.dm.getCurrentStatus(id)));
        }
        if (!minorEdit && this.dm.getCurrentStatus(id).equals("2")) {
            ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", new Locale(this.language));
            String changeMessage = String.format(messages.getString("status_email_text"), this.replyToDescr, this.replyTo, id);
            Log.trace((String)"geonetwork.datamanager", (Object)("Set DRAFT to current record with id " + id));
            this.dm.setStatus(this.context, id, Integer.valueOf("1"), new ISODate(), changeMessage);
        }
    }

    @Override
    public Map<Integer, StatusChangeType> onStatusChange(List<MetadataStatus> listOfStatus, boolean updateIndex) throws Exception {
        if (listOfStatus.stream().map(MetadataStatus::getMetadataId).distinct().count() != (long)listOfStatus.size()) {
            throw new IllegalArgumentException("Multiple status update received on the same metadata");
        }
        HashMap<Integer, StatusChangeType> results = new HashMap<Integer, StatusChangeType>();
        for (MetadataStatus status : listOfStatus) {
            boolean deleted;
            MetadataStatus currentStatus = this.dm.getStatus(status.getMetadataId());
            String currentStatusId = currentStatus != null ? String.valueOf(currentStatus.getStatusValue().getId()) : "";
            String statusId = status.getStatusValue().getId() + "";
            HashSet<Integer> listOfId = new HashSet<Integer>(1);
            listOfId.add(status.getMetadataId());
            if (status.getStatusValue().getType().equals((Object)StatusValueType.workflow) && statusId.equals(currentStatusId)) {
                if (this.context.isDebugEnabled()) {
                    this.context.debug(String.format("Metadata %s already has status %s ", status.getMetadataId(), status.getStatusValue().getId()));
                }
                results.put(status.getMetadataId(), StatusChangeType.UNCHANGED);
                continue;
            }
            AbstractMetadata metadata = this.metadataRepository.findOne(status.getMetadataId());
            if (!this.isStatusChangePossible(this.session.getProfile(), metadata, currentStatusId, statusId)) {
                results.put(status.getMetadataId(), StatusChangeType.UNCHANGED);
                continue;
            }
            if (this.context.isDebugEnabled()) {
                this.context.debug("Change status of metadata with id " + status.getMetadataId() + " from " + currentStatusId + " to " + statusId);
            }
            if (deleted = this.applyStatusChange(status.getMetadataId(), status, statusId, updateIndex)) {
                results.put(status.getMetadataId(), StatusChangeType.DELETED);
            } else {
                results.put(status.getMetadataId(), StatusChangeType.UPDATED);
            }
            Log.trace((String)"geonetwork.datamanager", (Object)"Throw workflow events.");
            for (Integer mid : listOfId) {
                if (results.get(mid) == StatusChangeType.DELETED) continue;
                Log.debug((String)"geonetwork.datamanager", (Object)("  > Status changed for record (" + mid + ") to status " + status));
                this.context.getApplicationContext().publishEvent((ApplicationEvent)new MetadataStatusChanged(this.metadataUtils.findOne(mid), status.getStatusValue(), status.getChangeMessage(), Integer.valueOf(status.getUserId())));
            }
            try {
                this.notify(this.getUserToNotify(status), status);
            }
            catch (Exception e) {
                this.context.warning(String.format("Failed to send notification on status change for metadata %s with status %s. Error is: %s", status.getMetadataId(), status.getStatusValue().getId(), e.getMessage()));
            }
        }
        return results;
    }

    private boolean applyStatusChange(int metadataId, MetadataStatus status, String toStatusId, boolean updateIndex) throws Exception {
        boolean deleted = false;
        if (!deleted) {
            this.metadataStatusManager.setStatusExt(status, updateIndex);
        }
        return deleted;
    }

    protected void notify(List<User> userToNotify, MetadataStatus status) throws Exception {
        if (userToNotify == null || userToNotify.isEmpty()) {
            return;
        }
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        FeedbackLanguages feedbackLanguages = (FeedbackLanguages)applicationContext.getBean(FeedbackLanguages.class);
        Locale[] feedbackLocales = feedbackLanguages.getLocales(new Locale(this.language));
        HashSet<Integer> listOfId = new HashSet<Integer>(1);
        listOfId.add(status.getMetadataId());
        UserRepository userRepository = this.context.getBean(UserRepository.class);
        User owner = userRepository.findById((Object)status.getOwner()).orElse(null);
        IMetadataUtils metadataRepository = (IMetadataUtils)ApplicationContextHolder.get().getBean(IMetadataUtils.class);
        AbstractMetadata metadata = metadataRepository.findOne(status.getMetadataId());
        String subjectTemplateKey = "";
        String textTemplateKey = "";
        boolean failedToFindASpecificSubjectTemplate = false;
        boolean failedToFindASpecificTextTemplate = false;
        for (Locale feedbackLocale : feedbackLocales) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.fao.geonet.api.Messages", feedbackLocale);
            if (!failedToFindASpecificSubjectTemplate) {
                try {
                    subjectTemplateKey = "status_change_" + status.getStatusValue().getName() + "_email_subject";
                    resourceBundle.getString(subjectTemplateKey);
                }
                catch (MissingResourceException e) {
                    failedToFindASpecificSubjectTemplate = true;
                }
            }
            if (!failedToFindASpecificTextTemplate) {
                try {
                    textTemplateKey = "status_change_" + status.getStatusValue().getName() + "_email_text";
                    resourceBundle.getString(textTemplateKey);
                }
                catch (MissingResourceException e) {
                    failedToFindASpecificTextTemplate = true;
                }
            }
            if (failedToFindASpecificSubjectTemplate && failedToFindASpecificTextTemplate) break;
        }
        if (failedToFindASpecificSubjectTemplate) {
            subjectTemplateKey = "status_change_default_email_subject";
        }
        if (failedToFindASpecificTextTemplate) {
            textTemplateKey = "status_change_default_email_text";
        }
        LocalizedEmailComponent emailSubjectComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.SUBJECT, subjectTemplateKey, LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.NUMERIC_FORMAT);
        emailSubjectComponent.enableCompileWithIndexFields(metadata.getUuid());
        LocalizedEmailComponent emailMessageComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.MESSAGE, textTemplateKey, LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.NUMERIC_FORMAT);
        emailMessageComponent.enableCompileWithIndexFields(metadata.getUuid());
        emailMessageComponent.enableReplaceLinks(false);
        LocalizedEmailComponent emailSalutationComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.SALUTATION, "{{userName}},\n\n", LocalizedEmailComponent.KeyType.RAW_VALUE, LocalizedEmailComponent.ReplacementType.NONE);
        for (Locale feedbackLocale : feedbackLocales) {
            emailSubjectComponent.addParameters(feedbackLocale, new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 1, this.siteName), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 2, this.getTranslatedStatusName(status.getStatusValue().getId(), feedbackLocale)), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 3, this.replyToDescr));
            emailMessageComponent.addParameters(feedbackLocale, new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 1, this.replyToDescr), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 2, status.getChangeMessage()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 3, this.getTranslatedStatusName(status.getStatusValue().getId(), feedbackLocale)), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 4, status.getChangeDate()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 5, status.getDueDate()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 6, status.getCloseDate()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 7, owner == null ? "" : Joiner.on((String)" ").skipNulls().join((Object)owner.getName(), (Object)owner.getSurname(), new Object[0])), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 8, this.metadataUtils.getDefaultUrl(metadata.getUuid(), feedbackLocale.getISO3Language())));
        }
        for (User user : userToNotify) {
            String message;
            LocalizedEmail localizedEmail = new LocalizedEmail(false);
            String userName = Joiner.on((String)" ").skipNulls().join((Object)user.getName(), (Object)user.getSurname(), new Object[0]);
            if (StringUtils.isEmpty((String)userName)) {
                localizedEmail.addComponents(emailSubjectComponent, emailMessageComponent);
                message = localizedEmail.getParsedMessage(feedbackLocales);
            } else {
                localizedEmail.addComponents(emailSubjectComponent, emailMessageComponent, emailSalutationComponent);
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{{userName}}", userName);
                message = localizedEmail.getParsedMessage(feedbackLocales, replacements);
            }
            String subject = localizedEmail.getParsedSubject(feedbackLocales);
            this.sendEmail(user.getEmail(), subject, message);
        }
    }

    protected List<User> getUserToNotify(MetadataStatus status) {
        UserRepository userRepository;
        Optional user;
        StatusValueNotificationLevel notificationLevel = status.getStatusValue().getNotificationLevel();
        if (status.getStatusValue().getId() == Integer.parseInt("1") && (StringUtils.isEmpty((String)status.getPreviousState()) || Integer.parseInt(status.getPreviousState()) != Integer.parseInt("4"))) {
            return new ArrayList<User>();
        }
        if (status.getStatusValue().getId() == Integer.parseInt("1") && !StringUtils.isEmpty((String)status.getPreviousState()) && status.getPreviousState().equals("4") && (notificationLevel.equals((Object)StatusValueNotificationLevel.recordUserAuthor) || notificationLevel.equals((Object)StatusValueNotificationLevel.recordProfileReviewer)) && (user = (userRepository = (UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class)).findById((Object)status.getUserId())).isPresent()) {
            notificationLevel = ((User)user.get()).getProfile() == Profile.Editor ? StatusValueNotificationLevel.recordProfileReviewer : StatusValueNotificationLevel.recordUserAuthor;
        }
        HashSet<Integer> listOfId = new HashSet<Integer>(1);
        listOfId.add(status.getMetadataId());
        return DefaultStatusActions.getUserToNotify(notificationLevel, listOfId, status.getOwner());
    }

    public static List<User> getUserToNotify(StatusValueNotificationLevel notificationLevel, Set<Integer> recordIds, Integer ownerId) {
        UserRepository userRepository = (UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class);
        ArrayList<User> users = new ArrayList();
        if (notificationLevel != null) {
            SettingManager settingManager;
            String adminEmail;
            if (notificationLevel == StatusValueNotificationLevel.statusUserOwner) {
                Optional owner = userRepository.findById((Object)ownerId);
                if (owner.isPresent()) {
                    users.add((User)owner.get());
                }
            } else if (notificationLevel.name().startsWith("recordProfile")) {
                String profileId = notificationLevel.name().replace("recordProfile", "");
                Profile profile = Profile.findProfileIgnoreCase((String)profileId);
                if (profile == null) {
                    Log.error((String)"geonetwork.datamanager", (Object)("Invalid notification level is configured '" + notificationLevel + "' The associated profile '" + profileId + "' does not exist."));
                    return users;
                }
                List results = userRepository.findAllByGroupOwnerNameAndProfile(recordIds, profile);
                Collections.sort(results, Comparator.comparing(s -> ((User)s.two()).getName()));
                for (Pair p : results) {
                    users.add((User)p.two());
                }
            } else if (notificationLevel == StatusValueNotificationLevel.recordUserAuthor) {
                List records = ((MetadataRepository)ApplicationContextHolder.get().getBean(MetadataRepository.class)).findAllById(recordIds);
                for (Object r : records) {
                    Optional owner = userRepository.findById((Object)r.getSourceInfo().getOwner());
                    if (!owner.isPresent()) continue;
                    users.add((User)owner.get());
                }
                List recordsDraft = ((MetadataDraftRepository)ApplicationContextHolder.get().getBean(MetadataDraftRepository.class)).findAllById(recordIds);
                for (MetadataDraft r : recordsDraft) {
                    Optional owner = userRepository.findById((Object)r.getSourceInfo().getOwner());
                    if (!owner.isPresent()) continue;
                    users.add((User)owner.get());
                }
            } else if (notificationLevel.name().startsWith("catalogueProfile")) {
                String profileId = notificationLevel.name().replace("catalogueProfile", "");
                Profile profile = Profile.findProfileIgnoreCase((String)profileId);
                if (profile == null) {
                    Log.error((String)"geonetwork.datamanager", (Object)("Invalid notification level is configured '" + notificationLevel + "' The associated profile '" + profileId + "' does not exist."));
                    return users;
                }
                users = userRepository.findAllByProfile(profile);
            } else if (notificationLevel == StatusValueNotificationLevel.catalogueAdministrator && StringUtils.isNotEmpty((String)(adminEmail = (settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class)).getValue("system/feedback/email")))) {
                HashSet<String> emails = new HashSet<String>(1);
                emails.add(adminEmail);
                User catalogueAdmin = new User().setEmailAddresses(emails);
                users.add(catalogueAdmin);
            }
        }
        return users.stream().filter(u -> StringUtils.isNotEmpty((String)u.getEmail())).collect(Collectors.toList());
    }

    public static List<Group> getGroupToNotify(StatusValueNotificationLevel notificationLevel, List<String> groupNames) {
        GroupRepository groupRepository = (GroupRepository)ApplicationContextHolder.get().getBean(GroupRepository.class);
        List<Object> groups = new ArrayList<Group>();
        if (notificationLevel != null && notificationLevel == StatusValueNotificationLevel.recordGroupEmail) {
            groups = groupRepository.findAll(GroupSpecs.inGroupNames(groupNames));
        }
        return groups;
    }

    protected void unsetAllOperations(int mdId) throws Exception {
        Log.trace((String)"geonetwork.datamanager", (Object)("DefaultStatusActions.unsetAllOperations(" + mdId + ")"));
        int allGroup = 1;
        for (ReservedOperation op : ReservedOperation.values()) {
            this.dm.forceUnsetOperation(this.context, mdId, allGroup, op.getId());
        }
    }

    private String getTranslatedStatusName(int statusValueId, Locale locale) {
        String translatedStatusName = "";
        StatusValue s = this.statusValueRepository.findOneById(statusValueId);
        translatedStatusName = s == null ? statusValueId + " (Status not found in database translation table. Check the content of the StatusValueDes table.)" : s.getLabel(locale.getISO3Language());
        return translatedStatusName;
    }

    protected void sendEmail(String sendTo, String subject, String message) {
        if (!this.emailNotes) {
            this.context.info("Would send email \nTo: " + sendTo + "\nSubject: " + subject + "\n Message:\n" + message);
        } else {
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            SettingManager sm = (SettingManager)applicationContext.getBean(SettingManager.class);
            if (StringUtils.isNotBlank((String)sm.getValue("system/feedback/mailServer/host"))) {
                ArrayList<String> to = new ArrayList<String>();
                to.add(sendTo);
                MailUtil.sendMail(to, subject, message, null, sm, this.replyTo, this.replyToDescr);
            }
        }
    }

    private boolean isStatusChangePossible(Profile profile, AbstractMetadata metadata, String fromStatus, String toStatus) throws Exception {
        return true;
    }
}

