/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query;

import java.io.IOException;
import java.io.OutputStream;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.rio.n3.N3Writer;
import org.openrdf.rio.ntriples.NTriplesWriter;
import org.openrdf.rio.rdfxml.RdfXmlWriter;
import org.openrdf.rio.turtle.TurtleWriter;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.query.GraphQueryResultListener;

public class RdfGraphWriter
implements GraphQueryResultListener {
    protected OutputStream _out;
    protected RdfDocumentWriter _rdfDocWriter;

    public RdfGraphWriter(RDFFormat rdfFormat, OutputStream out) throws IOException {
        this._out = out;
        if (rdfFormat == RDFFormat.RDFXML) {
            this._rdfDocWriter = new RdfXmlWriter(out);
        } else if (rdfFormat == RDFFormat.NTRIPLES) {
            this._rdfDocWriter = new NTriplesWriter(out);
        } else if (rdfFormat == RDFFormat.N3) {
            this._rdfDocWriter = new N3Writer(out);
        } else if (rdfFormat == RDFFormat.TURTLE) {
            this._rdfDocWriter = new TurtleWriter(out);
        } else {
            throw new IllegalArgumentException("Unsupported value for rdfFormat: " + rdfFormat.toString());
        }
    }

    public void startGraphQueryResult() throws IOException {
        this._rdfDocWriter.startDocument();
    }

    public void endGraphQueryResult() throws IOException {
        this._rdfDocWriter.endDocument();
        this._out.flush();
        this._out.close();
    }

    public void namespace(String prefix, String name) throws IOException {
        this._rdfDocWriter.setNamespace(prefix, name);
    }

    public void triple(Resource subj, URI pred, Value obj) throws IOException {
        this._rdfDocWriter.writeStatement(subj, pred, obj);
    }

    public void reportError(String msg) throws IOException {
        this._rdfDocWriter.writeComment("ERROR: " + msg);
    }
}

