/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.component.csw;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.csw.common.ConstraintLanguage;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.ElementSetName;
import org.fao.geonet.csw.common.OutputSchema;
import org.fao.geonet.csw.common.ResultType;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;
import org.fao.geonet.csw.common.exceptions.MissingParameterValueEx;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.domain.CustomElementSet;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.csw.CatalogConfiguration;
import org.fao.geonet.kernel.csw.CatalogService;
import org.fao.geonet.kernel.csw.services.AbstractOperation;
import org.fao.geonet.kernel.csw.services.getrecords.FieldMapper;
import org.fao.geonet.kernel.csw.services.getrecords.SearchController;
import org.fao.geonet.kernel.csw.services.getrecords.SortByParser;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.CustomElementSetRepository;
import org.fao.geonet.util.xml.NamespaceUtils;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="CswService.GetRecords")
public class GetRecords
extends AbstractOperation
implements CatalogService {
    static final String NAME = "GetRecords";
    private static final String defaultOutputFormat = "application/xml";
    @Autowired
    private SearchController _searchController;
    @Autowired
    private CatalogConfiguration _catalogConfig;
    @Autowired
    private FieldMapper _fieldMapper;
    @Autowired
    private SortByParser _sortByParser;
    @Autowired
    private SchemaManager _schemaManager;

    @Autowired
    public GetRecords(ApplicationContext context) {
    }

    public SearchController getSearchController() {
        return this._searchController;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Element execute(Element request, ServiceContext context) throws CatalogException {
        Element response;
        List customElementSets;
        String timeStamp = new ISODate().toString();
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dataManager = (DataManager)gc.getBean(DataManager.class);
        SettingManager settingsManager = (SettingManager)gc.getBean(SettingManager.class);
        if (!settingsManager.getValueAsBool("system/csw/enabledWhenIndexing") && dataManager.isIndexing()) {
            throw new RuntimeException("Catalog is indexing records, retry later.");
        }
        this.checkService(request);
        this.checkVersion(request);
        this.checkOutputFormat(request);
        this.checkElementNamesXORElementSetName(request);
        int startPos = this.getStartPosition(request);
        int maxRecords = this.getMaxRecords(request);
        Element query = request.getChild("Query", Csw.NAMESPACE_CSW);
        ResultType resultType = ResultType.parse(request.getAttributeValue("resultType"));
        String outSchema = OutputSchema.parse(request.getAttributeValue("outputSchema"), this._schemaManager);
        String elementnameStrategy = this.getElementNameStrategy(query);
        SettingManager settingInfo = (SettingManager)context.getBean(SettingManager.class);
        String typeName = this.checkTypenames(query, settingInfo.getValueAsBool("system/inspire/enable"));
        Set<String> elemNames = this.getElementNames(query);
        ElementSetName setName = ElementSetName.FULL;
        if (elemNames == null && (setName = this.getElementSetName(query, ElementSetName.SUMMARY)).equals((Object)ElementSetName.FULL) && !CollectionUtils.isEmpty((Collection)(customElementSets = ((CustomElementSetRepository)context.getBean(CustomElementSetRepository.class)).findAll()))) {
            elemNames = new HashSet<String>();
            for (CustomElementSet customElementSet : customElementSets) {
                elemNames.add(customElementSet.getXpath());
            }
        }
        Element constr = query.getChild("Constraint", Csw.NAMESPACE_CSW);
        Element filterExpr = this.getFilterExpression(constr);
        String filterVersion = this.getFilterVersion(constr);
        int maxHitsInSummary = 1000;
        String sMaxRecordsInKeywordSummary = query.getAttributeValue("maxHitsInSummary");
        if (sMaxRecordsInKeywordSummary != null) {
            maxHitsInSummary = Integer.parseInt(sMaxRecordsInKeywordSummary);
        }
        if (resultType == ResultType.VALIDATE) {
            Path schema = context.getAppPath().resolve("xml/validation/").resolve("csw202_apiso100/csw/2.0.2/CSW-discovery.xsd");
            if (Log.isDebugEnabled((String)"geonetwork.csw")) {
                Log.debug((String)"geonetwork.csw", (Object)("Validating request against " + schema));
            }
            try {
                Xml.validate((Path)schema, (Element)request);
            }
            catch (Exception e) {
                throw new NoApplicableCodeEx("Request failed validation:" + e.toString());
            }
            response = new Element("Acknowledgement", Csw.NAMESPACE_CSW);
            response.setAttribute("timeStamp", timeStamp);
            Element echoedRequest = new Element("EchoedRequest", Csw.NAMESPACE_CSW);
            echoedRequest.addContent((Content)request);
            response.addContent((Content)echoedRequest);
        } else {
            List<SortBuilder<FieldSortBuilder>> sort = this._sortByParser.parseSortBy(request);
            response = new Element(this.getName() + "Response", Csw.NAMESPACE_CSW);
            Attribute schemaLocation = new Attribute("schemaLocation", "http://www.opengis.net/cat/csw/2.0.2 http://schemas.opengis.net/csw/2.0.2/CSW-discovery.xsd", Csw.NAMESPACE_XSI);
            response.setAttribute(schemaLocation);
            Element status = new Element("SearchStatus", Csw.NAMESPACE_CSW);
            status.setAttribute("timestamp", timeStamp);
            response.addContent((Content)status);
            Element search = this._searchController.search(context, startPos, maxRecords, resultType, outSchema, setName, filterExpr, filterVersion, sort, elemNames, typeName, maxHitsInSummary, elementnameStrategy);
            response.addContent((Content)search);
        }
        return response;
    }

    @Override
    public Element adaptGetRequest(Map<String, String> params) throws CatalogException {
        String service = params.get("service");
        String version = params.get("version");
        String resultType = params.get("resulttype");
        String outputFormat = params.get("outputformat");
        String outputSchema = params.get("outputschema");
        String startPosition = params.get("startposition");
        String maxRecords = params.get("maxrecords");
        String hopCount = params.get("hopcount");
        String distribSearch = params.get("distributedsearch");
        String typeNames = params.get("typenames");
        String elemSetName = params.get("elementsetname");
        String elemName = params.get("elementname");
        String constraint = params.get("constraint");
        String constrLang = params.get("constraintlanguage");
        String constrLangVer = params.get("constraint_language_version");
        String sortby = params.get("sortby");
        String elementnameStrategy = params.get("elementnamestrategy");
        Element request = new Element(this.getName(), Csw.NAMESPACE_CSW);
        this.setAttrib(request, "service", service);
        this.setAttrib(request, "version", version);
        this.setAttrib(request, "resultType", resultType);
        this.setAttrib(request, "outputFormat", outputFormat);
        this.setAttrib(request, "outputSchema", outputSchema);
        this.setAttrib(request, "startPosition", startPosition);
        this.setAttrib(request, "maxRecords", maxRecords);
        if (distribSearch != null && distribSearch.equals("true")) {
            Element ds = new Element("DistributedSearch", Csw.NAMESPACE_CSW);
            ds.setText("TRUE");
            if (hopCount != null) {
                ds.setAttribute("hopCount", hopCount);
            }
            request.addContent((Content)ds);
        }
        Element query = new Element("Query", Csw.NAMESPACE_CSW);
        request.addContent((Content)query);
        if (elementnameStrategy != null) {
            this.setAttrib(query, "elementnamestrategy", elementnameStrategy);
        }
        if (typeNames != null) {
            this.setAttrib(query, "typeNames", typeNames.replace(',', ' '));
        }
        this.addElement(query, "ElementSetName", elemSetName);
        this.fill(query, "ElementName", elemName);
        if (constraint != null) {
            ConstraintLanguage language = ConstraintLanguage.parse(constrLang);
            Element constr = new Element("Constraint", Csw.NAMESPACE_CSW);
            query.addContent((Content)constr);
            if (language == ConstraintLanguage.CQL) {
                this.addElement(constr, "CqlText", constraint);
            } else {
                try {
                    constr.addContent((Content)Xml.loadString((String)constraint, (boolean)false));
                }
                catch (Exception e) {
                    Log.error((String)"geonetwork.csw.search", (String)("Constraint is not a valid xml, error:" + e.getMessage()), (Throwable)e);
                    throw new NoApplicableCodeEx("Constraint is not a valid xml");
                }
            }
            this.setAttrib(constr, "version", constrLangVer);
        }
        if (sortby != null) {
            Element sortBy = new Element("SortBy", Csw.NAMESPACE_OGC);
            query.addContent((Content)sortBy);
            StringTokenizer st = new StringTokenizer(sortby, ",");
            while (st.hasMoreTokens()) {
                String sortInfo = st.nextToken();
                String field = sortInfo.substring(0, sortInfo.length() - 2);
                boolean ascen = sortInfo.endsWith(":A");
                Element sortProp = new Element("SortProperty", Csw.NAMESPACE_OGC);
                sortBy.addContent((Content)sortProp);
                Element propName = new Element("PropertyName", Csw.NAMESPACE_OGC).setText(field);
                Element sortOrder = new Element("SortOrder", Csw.NAMESPACE_OGC).setText(ascen ? "ASC" : "DESC");
                sortProp.addContent((Content)propName);
                sortProp.addContent((Content)sortOrder);
            }
        }
        return request;
    }

    @Override
    public Element retrieveValues(String parameterName) throws CatalogException {
        List<Element> values;
        String value;
        Element listOfValues = null;
        if (parameterName.equalsIgnoreCase("resultType") || parameterName.equalsIgnoreCase("outputFormat") || parameterName.equalsIgnoreCase("elementSetName") || parameterName.equalsIgnoreCase("outputSchema") || parameterName.equalsIgnoreCase("typenames")) {
            listOfValues = new Element("ListOfValues", Csw.NAMESPACE_CSW);
        }
        if (parameterName.equalsIgnoreCase("resultType")) {
            ArrayList<Element> values2 = new ArrayList<Element>();
            ResultType[] resultType = ResultType.values();
            for (Enum enum_ : resultType) {
                value = ((ResultType)enum_).toString();
                values2.add(new Element("Value", Csw.NAMESPACE_CSW).setText(value));
            }
            if (listOfValues != null) {
                listOfValues.addContent(values2);
            }
        }
        if (parameterName.equalsIgnoreCase("elementSetName")) {
            ArrayList<Element> values2 = new ArrayList<Element>();
            ElementSetName[] esn = ElementSetName.values();
            for (Enum enum_ : esn) {
                value = ((ElementSetName)enum_).toString();
                values2.add(new Element("Value", Csw.NAMESPACE_CSW).setText(value));
            }
            if (listOfValues != null) {
                listOfValues.addContent(values2);
            }
        }
        if (parameterName.equalsIgnoreCase("outputformat")) {
            Set<String> formats = this._catalogConfig.getGetRecordsOutputFormat();
            values = this.createValuesElement(formats);
            if (listOfValues != null) {
                listOfValues.addContent(values);
            }
        }
        if (parameterName.equalsIgnoreCase("outputSchema")) {
            Set<String> namespacesUri = this._catalogConfig.getGetRecordsOutputSchema();
            values = this.createValuesElement(namespacesUri);
            if (listOfValues != null) {
                listOfValues.addContent(values);
            }
        }
        if (parameterName.equalsIgnoreCase("typenames")) {
            Set<String> typenames = this._catalogConfig.getGetRecordsTypenames();
            values = this.createValuesElement(typenames);
            if (listOfValues != null) {
                listOfValues.addContent(values);
            }
        }
        return listOfValues;
    }

    private String checkOutputFormat(Element request) throws InvalidParameterValueEx {
        String format = request.getAttributeValue("outputFormat");
        if (format != null && !format.equals(defaultOutputFormat)) {
            throw new InvalidParameterValueEx("outputFormat", format);
        }
        return defaultOutputFormat;
    }

    private String checkTypenames(Element query, boolean isStrict) throws MissingParameterValueEx, InvalidParameterValueEx {
        String gmdPrefix;
        String cswPrefix;
        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
            Log.debug((String)"geonetwork.csw.search", (Object)("checking typenames in query:\n" + Xml.getString((Element)query)));
        }
        if ((cswPrefix = this.getPrefixForNamespace(query, Csw.NAMESPACE_CSW)) == null) {
            if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                Log.debug((String)"geonetwork.csw.search", (Object)("checktypenames: csw prefix not found, using " + Csw.NAMESPACE_CSW.getPrefix()));
            }
            cswPrefix = Csw.NAMESPACE_CSW.getPrefix();
        }
        if ((gmdPrefix = this.getPrefixForNamespace(query, Csw.NAMESPACE_GMD)) == null) {
            if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                Log.debug((String)"geonetwork.csw.search", (Object)("checktypenames: gmd prefix not found, using " + Csw.NAMESPACE_GMD.getPrefix()));
            }
            gmdPrefix = Csw.NAMESPACE_GMD.getPrefix();
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
            Log.debug((String)"geonetwork.csw.search", (Object)("checktypenames: csw prefix set to " + cswPrefix + ", gmd prefix set to " + gmdPrefix));
        }
        Attribute typeNames = query.getAttribute("typeNames", query.getNamespace());
        typeNames = query.getAttribute("typeNames");
        if (typeNames != null) {
            String typeNamesValue = typeNames.getValue();
            if (StringUtils.isEmpty((String)typeNamesValue)) {
                return cswPrefix + ":Record";
            }
            Scanner spaceScanner = new Scanner(typeNamesValue);
            spaceScanner.useDelimiter(" ");
            String result = cswPrefix + ":Record";
            while (spaceScanner.hasNext()) {
                String typeName = spaceScanner.next();
                typeName = typeName.trim();
                if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                    Log.debug((String)"geonetwork.csw.search", (Object)("checking typename in query:" + typeName));
                }
                if (!this._schemaManager.getListOfTypeNames().contains(typeName)) {
                    throw new InvalidParameterValueEx("typeNames", String.format("'%s' typename is not valid. Supported values are: %s", typeName, this._schemaManager.getListOfTypeNames()));
                }
                if (!typeName.equals(gmdPrefix + ":MD_Metadata")) continue;
                return typeName;
            }
            return result;
        }
        if (isStrict) {
            throw new MissingParameterValueEx("typeNames", String.format("Attribute 'typeNames' is missing. Supported values are: %s. Default is csw:Record according to OGC 07-045.", this._schemaManager.getListOfTypeNames()));
        }
        return cswPrefix + ":Record";
    }

    private String getPrefixForNamespace(Element element, Namespace namespace) {
        List namespacesInScope = NamespaceUtils.getNamespacesInScope((Element)element);
        for (Namespace ns : namespacesInScope) {
            if (!ns.getURI().equals(namespace.getURI())) continue;
            return ns.getPrefix();
        }
        return null;
    }

    private String getElementNameStrategy(Element query) {
        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
            Log.debug((String)"geonetwork.csw.search", (Object)("getting elementnameStrategy from query:\n" + Xml.getString((Element)query)));
        }
        Attribute elementNameStrategyA = query.getAttribute("elementnameStrategy");
        String elementNameStrategy = "relaxed";
        if (elementNameStrategyA != null) {
            elementNameStrategy = elementNameStrategyA.getValue();
        }
        if (!(!StringUtils.isNotEmpty((String)elementNameStrategy) || elementNameStrategy.equals("csw202") || elementNameStrategy.equals("relaxed") || elementNameStrategy.equals("context") || elementNameStrategy.equals("geonetwork26"))) {
            elementNameStrategy = "relaxed";
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
            Log.debug((String)"geonetwork.csw.search", (Object)("elementNameStrategy: " + elementNameStrategy));
        }
        return elementNameStrategy;
    }

    private void checkElementNamesXORElementSetName(Element request) throws InvalidParameterValueEx {
        Element query = request.getChild("Query", Csw.NAMESPACE_CSW);
        if (query != null) {
            boolean elementSetNamePresent;
            boolean elementNamePresent = !CollectionUtils.isEmpty((Collection)query.getChildren("ElementName", query.getNamespace()));
            boolean bl = elementSetNamePresent = !CollectionUtils.isEmpty((Collection)query.getChildren("ElementSetName", query.getNamespace()));
            if (elementNamePresent && elementSetNamePresent) {
                throw new InvalidParameterValueEx("ElementName and ElementSetName", "mutually exclusive");
            }
        }
    }

    private int getStartPosition(Element request) throws InvalidParameterValueEx {
        String start = request.getAttributeValue("startPosition");
        if (start == null) {
            return 1;
        }
        try {
            int value = Integer.parseInt(start);
            if (value >= 1) {
                return value;
            }
            throw new InvalidParameterValueEx("startPosition", start);
        }
        catch (NumberFormatException x) {
            throw new InvalidParameterValueEx("startPosition", start);
        }
    }

    private int getMaxRecords(Element request) throws InvalidParameterValueEx {
        String max = request.getAttributeValue("maxRecords");
        if (max == null) {
            return 10;
        }
        try {
            int value = Integer.parseInt(max);
            if (value >= 1) {
                return value;
            }
            throw new InvalidParameterValueEx("maxRecords", max);
        }
        catch (NumberFormatException x) {
            throw new InvalidParameterValueEx("maxRecords", max);
        }
    }

    private Set<String> getElementNames(Element query) {
        if (Log.isDebugEnabled((String)"geonetwork.csw")) {
            Log.debug((String)"geonetwork.csw", (Object)"GetRecords getElementNames");
        }
        HashSet<String> elementNames = null;
        if (query != null) {
            List elementList = query.getChildren("ElementName", query.getNamespace());
            for (Element element : elementList) {
                if (elementNames == null) {
                    elementNames = new HashSet<String>();
                }
                elementNames.add(element.getTextNormalize());
            }
        }
        if (elementNames != null) {
            for (String elementName : elementNames) {
                if (!Log.isDebugEnabled((String)"geonetwork.csw")) continue;
                Log.debug((String)"geonetwork.csw", (Object)("ElementName: " + elementName));
            }
        } else if (Log.isDebugEnabled((String)"geonetwork.csw")) {
            Log.debug((String)"geonetwork.csw", (Object)"No ElementNames found in request");
        }
        return elementNames;
    }
}

