/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.geotools.data.ows.AbstractRequest;
import org.geotools.data.ows.Request;
import org.geotools.data.wfs.internal.HttpMethod;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.data.wfs.internal.WFSExtensions;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.data.wfs.internal.WFSResponseFactory;
import org.geotools.data.wfs.internal.WFSStrategy;
import org.geotools.http.HTTPResponse;
import org.geotools.util.factory.FactoryNotFoundException;
import org.geotools.util.logging.Logging;

public abstract class WFSRequest
extends AbstractRequest
implements Request {
    protected final WFSStrategy strategy;
    protected final WFSOperationType operation;
    protected final WFSConfig config;
    private final boolean doPost;
    private QName typeName;
    private String outputFormat;
    private String handle;

    public WFSRequest(WFSOperationType operation, WFSConfig config, WFSStrategy strategy) {
        super(WFSRequest.url(operation, config, strategy), null);
        this.operation = operation;
        this.config = config;
        this.strategy = strategy;
        this.handle = strategy.newRequestHandle(operation);
        switch (config.getPreferredMethod()) {
            case HTTP_POST: {
                this.doPost = strategy.supportsOperation(operation, HttpMethod.POST);
                break;
            }
            case HTTP_GET: {
                this.doPost = !strategy.supportsOperation(operation, HttpMethod.GET);
                break;
            }
            default: {
                this.doPost = strategy.supportsOperation(operation, HttpMethod.POST);
            }
        }
        this.outputFormat = strategy.getDefaultOutputFormat(operation);
        if (!this.doPost) {
            this.setProperty("SERVICE", "WFS");
            this.setProperty("VERSION", strategy.getVersion());
            this.setProperty("REQUEST", operation.getName());
        }
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setTypeName(QName typeName) {
        this.typeName = typeName;
    }

    public QName getTypeName() {
        return this.typeName;
    }

    public WFSStrategy getStrategy() {
        return this.strategy;
    }

    private static URL url(WFSOperationType operation, WFSConfig config, WFSStrategy strategy) {
        HttpMethod method;
        boolean suportsGet = strategy.supportsOperation(operation, HttpMethod.GET);
        boolean suportsPost = strategy.supportsOperation(operation, HttpMethod.POST);
        if (!suportsGet && !suportsPost) {
            throw new IllegalArgumentException("WFS doesn't support " + operation.getName());
        }
        switch (config.getPreferredMethod()) {
            case HTTP_POST: 
            case AUTO: {
                method = suportsPost ? HttpMethod.POST : HttpMethod.GET;
                break;
            }
            default: {
                method = suportsPost ? HttpMethod.POST : HttpMethod.GET;
            }
        }
        URL targetUrl = strategy.getOperationURL(operation, method);
        return targetUrl;
    }

    public WFSOperationType getOperation() {
        return this.operation;
    }

    public boolean requiresPost() {
        return this.doPost;
    }

    protected void initService() {
    }

    protected void initVersion() {
    }

    protected void initRequest() {
    }

    public URL getFinalURL() {
        if (this.requiresPost()) {
            return super.getFinalURL();
        }
        URL finalURL = this.strategy.buildUrlGET(this);
        return finalURL;
    }

    public String getPostContentType() {
        return "text/xml";
    }

    public void performPostOutput(OutputStream outputStream) throws IOException {
        try (InputStream in = this.strategy.getPostContents(this);){
            IOUtils.copy((InputStream)in, (OutputStream)outputStream);
        }
    }

    public WFSResponse createResponse(HTTPResponse response) throws IOException {
        WFSResponseFactory responseFactory;
        String contentType = response.getContentType();
        if (contentType == null) {
            Logging.getLogger(WFSRequest.class).warning((Object)((Object)this.getOperation()) + " request returned null content type for URL " + this.getFinalURL());
        }
        try {
            responseFactory = WFSExtensions.findResponseFactory(this, contentType);
        }
        catch (FactoryNotFoundException fnf) {
            Loggers.MODULE.log(Level.WARNING, fnf.getMessage());
            try {
                if (contentType != null && contentType.startsWith("text")) {
                    byte[] buff = new byte[1024];
                    response.getResponseStream().read(buff);
                    Loggers.MODULE.info("Failed response snippet: " + new String(buff));
                }
                throw fnf;
            }
            catch (Exception ignore) {
                throw fnf;
            }
        }
        WFSResponse wfsResponse = responseFactory.createResponse(this, response);
        return wfsResponse;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getOperation().toString());
        sb.append("[");
        sb.append("\n\thandle: ").append(this.handle);
        sb.append("\n\toutputFormat: <").append(this.outputFormat).append(">");
        sb.append("\n\tmethod: ").append(this.doPost ? "POST" : "GET");
        sb.append("\n\tonlineResource: <").append(this.onlineResource).append(">");
        try {
            sb.append("\n\tfinal URL: <").append(this.getFinalURL()).append(">");
        }
        catch (Exception e) {
            sb.append("\n\tfinal URL error: <").append(e.getMessage()).append(">");
        }
        return sb.append("\n]").toString();
    }
}

