/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.other.G;
import org.apache.jena.riot.other.RDFDataException;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.TargetType;
import org.apache.jena.shacl.engine.Targets;
import org.apache.jena.shacl.engine.constraint.JLogConstraint;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.ConstraintComponents;
import org.apache.jena.shacl.parser.Constraints;
import org.apache.jena.shacl.parser.NodeShape;
import org.apache.jena.shacl.parser.PropertyShape;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.sys.C;
import org.apache.jena.shacl.sys.ShaclSystem;
import org.apache.jena.shacl.validation.Severity;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.util.iterator.ExtendedIterator;

public class ShapesParser {
    private static final boolean DEBUG = false;
    private static IndentedWriter OUT = IndentedWriter.stdout;
    private static Set<RDFDatatype> decimalCompatible = new HashSet<RDFDatatype>();

    public static Targets targets(Graph shapesGraph) {
        return Targets.create(shapesGraph);
    }

    public static Collection<Shape> parseShapes(Graph shapesGraph, Targets targets, Map<Node, Shape> shapesMap) {
        HashSet<Node> cycles = new HashSet<Node>();
        return ShapesParser.parseShapes(shapesGraph, targets, shapesMap, cycles);
    }

    static Collection<Shape> parseShapes(Graph shapesGraph, Targets targets, Map<Node, Shape> shapesMap, Set<Node> cycles) {
        Targets rootShapes = targets;
        ConstraintComponents sparqlConstraintComponents = ConstraintComponents.parseSparqlConstraintComponents(shapesGraph);
        LinkedHashMap<Node, Shape> acc = new LinkedHashMap<Node, Shape>();
        for (Node shapeNode : rootShapes.targetNodes) {
            ShapesParser.parseShapeAcc(acc, shapesMap, shapesGraph, shapeNode);
        }
        for (Node shapeNode : rootShapes.targetClasses) {
            ShapesParser.parseShapeAcc(acc, shapesMap, shapesGraph, shapeNode);
        }
        for (Node shapeNode : rootShapes.targetObjectsOf) {
            ShapesParser.parseShapeAcc(acc, shapesMap, shapesGraph, shapeNode);
        }
        for (Node shapeNode : rootShapes.targetSubjectsOf) {
            ShapesParser.parseShapeAcc(acc, shapesMap, shapesGraph, shapeNode);
        }
        for (Node shapeNode : rootShapes.implicitClassTargets) {
            ShapesParser.parseShapeAcc(acc, shapesMap, shapesGraph, shapeNode);
        }
        if (sparqlConstraintComponents != null && !sparqlConstraintComponents.isEmpty()) {
            shapesMap.values().forEach(shape -> {
                List<Constraint> x = ConstraintComponents.processShape(shapesGraph, sparqlConstraintComponents, shape);
                if (x != null && !x.isEmpty()) {
                    shape.getConstraints().addAll(x);
                }
            });
        }
        return ShapesParser.shapes(acc);
    }

    public static Collection<Node> findDeclaredShapes(Graph shapesGraph) {
        HashSet<Node> declared = new HashSet<Node>();
        G.allNodesOfTypeRDFS((Graph)shapesGraph, (Node)SHACL.NodeShape).forEach(declared::add);
        G.allNodesOfTypeRDFS((Graph)shapesGraph, (Node)SHACL.PropertyShape).forEach(declared::add);
        return declared;
    }

    private static Collection<Shape> shapes(Map<Node, Shape> acc) {
        return new ArrayList<Shape>(acc.values());
    }

    private static Shape parseShapeAcc(Map<Node, Shape> acc, Map<Node, Shape> shapesMap, Graph shapesGraph, Node shNode) {
        if (acc.containsKey(shNode)) {
            return acc.get(shNode);
        }
        Shape shape = ShapesParser.parseShape(shapesMap, shapesGraph, shNode);
        if (acc != null) {
            acc.put(shNode, shape);
        }
        return shape;
    }

    public static Shape parseShape(Map<Node, Shape> shapesMap, Graph shapesGraph, Node shNode) {
        HashSet<Node> traversed = new HashSet<Node>();
        Shape shape = ShapesParser.parseShapeStep(traversed, shapesMap, shapesGraph, shNode);
        return shape;
    }

    static Shape unshape(Graph shapesGraph, Node shapeNode) {
        return new NodeShape(shapesGraph, shapeNode, false, Severity.Violation, Collections.emptySet(), Collections.emptySet(), Collections.singleton(new JLogConstraint("Cycle")), Collections.emptySet());
    }

    static Shape parseShapeStep(Set<Node> traversed, Map<Node, Shape> parsed, Graph shapesGraph, Node shapeNode) {
        try {
            if (parsed.containsKey(shapeNode)) {
                return parsed.get(shapeNode);
            }
            if (traversed.contains(shapeNode)) {
                ShaclSystem.systemShaclLogger.warn("Cycle detected : node " + ShLib.displayStr(shapeNode));
                return ShapesParser.unshape(shapesGraph, shapeNode);
            }
            traversed.add(shapeNode);
            Shape shape = ShapesParser.parseShape$(traversed, parsed, shapesGraph, shapeNode);
            parsed.put(shapeNode, shape);
            traversed.remove(shapeNode);
            return shape;
        }
        catch (RDFDataException ex) {
            throw new ShaclParseException(ex.getMessage());
        }
    }

    private static Shape parseShape$(Set<Node> traversed, Map<Node, Shape> parsed, Graph shapesGraph, Node shapeNode) {
        boolean isDeactivated = G.contains((Graph)shapesGraph, (Node)shapeNode, (Node)SHACL.deactivated, (Node)NodeConst.nodeTrue);
        Collection<Target> targets = ShapesParser.targets(shapesGraph, shapeNode);
        List<Constraint> constraints = Constraints.parseConstraints(shapesGraph, shapeNode, parsed, traversed);
        Severity severity = ShapesParser.severity(shapesGraph, shapeNode);
        List messages = G.listSP((Graph)shapesGraph, (Node)shapeNode, (Node)SHACL.message);
        List<PropertyShape> propertyShapes = ShapesParser.findPropertyShapes(traversed, parsed, shapesGraph, shapeNode);
        boolean isPropertyShape = G.contains((Graph)shapesGraph, (Node)shapeNode, (Node)SHACL.path, (Node)Node.ANY);
        if (!isPropertyShape) {
            return new NodeShape(shapesGraph, shapeNode, isDeactivated, severity, messages, targets, constraints, propertyShapes);
        }
        Node pathNode = G.getOneSP((Graph)shapesGraph, (Node)shapeNode, (Node)SHACL.path);
        Path path = ShapesParser.parsePath(shapesGraph, pathNode);
        List names = G.listSP((Graph)shapesGraph, (Node)shapeNode, (Node)SHACL.name);
        List descriptions = G.listSP((Graph)shapesGraph, (Node)shapeNode, (Node)SHACL.description);
        List groups = G.listSP((Graph)shapesGraph, (Node)shapeNode, (Node)SHACL.group);
        Node defaultValue = G.getZeroOrOneSP((Graph)shapesGraph, (Node)shapeNode, (Node)SHACL.defaultValue);
        Node order = G.getZeroOrOneSP((Graph)shapesGraph, (Node)shapeNode, (Node)SHACL.order);
        if (order != null && !ShapesParser.isDecimalCompatible(order)) {
            throw new ShaclParseException("Not an xsd:decimal for sh:order");
        }
        return new PropertyShape(shapesGraph, shapeNode, isDeactivated, severity, messages, targets, path, constraints, propertyShapes);
    }

    private static boolean isDecimalCompatible(Node node) {
        try {
            RDFDatatype dt = node.getLiteralDatatype();
            return decimalCompatible.contains(dt);
        }
        catch (JenaException ex) {
            return false;
        }
    }

    private static Path parsePath(Graph shapesGraph, Node node) {
        return ShaclPaths.parsePath(shapesGraph, node);
    }

    private static List<PropertyShape> findPropertyShapes(Set<Node> traversed, Map<Node, Shape> parsed, Graph shapesGraph, Node shapeNode) {
        List propertyTriples = G.find((Graph)shapesGraph, (Node)shapeNode, (Node)SHACL.property, null).toList();
        ArrayList<PropertyShape> propertyShapes = new ArrayList<PropertyShape>();
        for (Triple t : propertyTriples) {
            Node propertyShape = G.object((Triple)t);
            long x = G.countSP((Graph)shapesGraph, (Node)propertyShape, (Node)SHACL.path);
            if (x == 0L) {
                boolean existsAsSubject = G.contains((Graph)shapesGraph, (Node)propertyShape, null, null);
                if (!existsAsSubject) {
                    throw new ShaclParseException("Missing property shape: node=" + ShLib.displayStr(shapeNode) + " sh:property " + ShLib.displayStr(propertyShape));
                }
                throw new ShaclParseException("No sh:path on a property shape: node=" + ShLib.displayStr(shapeNode) + " sh:property " + ShLib.displayStr(propertyShape));
            }
            if (x > 1L) {
                List paths = G.listSP((Graph)shapesGraph, (Node)propertyShape, (Node)SHACL.path);
                throw new ShaclParseException("Multiple sh:path on a property shape: " + ShLib.displayStr(shapeNode) + " sh:property" + ShLib.displayStr(propertyShape) + " : " + paths);
            }
            PropertyShape ps = (PropertyShape)ShapesParser.parseShapeStep(traversed, parsed, shapesGraph, propertyShape);
            propertyShapes.add(ps);
        }
        return propertyShapes;
    }

    private static Collection<Target> targets(Graph shapesGraph, Node shape) {
        ArrayList<Target> x = new ArrayList<Target>();
        ShapesParser.accTarget(x, shapesGraph, shape, TargetType.targetNode);
        ShapesParser.accTarget(x, shapesGraph, shape, TargetType.targetClass);
        ShapesParser.accTarget(x, shapesGraph, shape, TargetType.targetObjectsOf);
        ShapesParser.accTarget(x, shapesGraph, shape, TargetType.targetSubjectsOf);
        if (ShapesParser.isShapeType(shapesGraph, shape) && G.isOfType((Graph)shapesGraph, (Node)shape, (Node)C.rdfsClass)) {
            x.add(Target.create(TargetType.implicitClass, shape));
        }
        return x;
    }

    private static boolean isShapeType(Graph shapesGraph, Node shape) {
        return G.hasType((Graph)shapesGraph, (Node)shape, (Node)SHACL.NodeShape) || G.hasType((Graph)shapesGraph, (Node)shape, (Node)SHACL.PropertyShape);
    }

    private static Severity severity(Graph shapesGraph, Node shNode) {
        Node sev = G.getSP((Graph)shapesGraph, (Node)shNode, (Node)SHACL.severity);
        if (sev == null) {
            return Severity.Violation;
        }
        return Severity.create(sev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void accTarget(Collection<Target> acc, Graph shapesGraph, Node shape, TargetType targetType) {
        try (ExtendedIterator iter = shapesGraph.find(shape, targetType.predicate, null);){
            iter.mapWith(triple -> Target.create(targetType, triple.getObject())).forEachRemaining(target -> acc.add((Target)target));
        }
    }

    static {
        decimalCompatible.add((RDFDatatype)XSDDatatype.XSDdecimal);
        decimalCompatible.add((RDFDatatype)XSDDatatype.XSDinteger);
        decimalCompatible.add((RDFDatatype)XSDDatatype.XSDlong);
        decimalCompatible.add((RDFDatatype)XSDDatatype.XSDint);
    }

    static class ParserState {
        Targets rootShapes;
        ConstraintComponents sparqlConstraintComponents;
        Map<Node, Shape> shapesMap;

        ParserState() {
        }
    }
}

