/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain.page;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.page.PageIdentity;
import org.hibernate.annotations.Type;

@Entity(name="SPG_Page")
@Table(name="SPG_Page")
public class Page
extends GeonetEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PageIdentity pageIdentity;
    private byte[] data;
    private String link;
    private PageFormat format;
    private List<PageSection> sections;
    private PageStatus status;
    private Set<Group> groups = new LinkedHashSet<Group>();
    private String label;

    public Page() {
    }

    public Page(PageIdentity pageIdentity, byte[] data, String link, PageFormat format, List<PageSection> sections, PageStatus status, String label, Set<Group> groups) {
        this.pageIdentity = pageIdentity;
        this.data = data;
        this.link = link;
        this.format = format;
        this.sections = sections;
        this.status = status;
        this.label = label;
        this.groups = groups;
    }

    @EmbeddedId
    public PageIdentity getPageIdentity() {
        return this.pageIdentity;
    }

    @Column
    @Nullable
    @Lob
    @Basic(fetch=FetchType.LAZY)
    public byte[] getData() {
        return this.data;
    }

    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    @Column(unique=true)
    public String getLink() {
        return this.link;
    }

    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    public PageFormat getFormat() {
        return this.format;
    }

    @ElementCollection(targetClass=PageSection.class)
    @Enumerated(value=EnumType.STRING)
    @CollectionTable(name="SPG_Sections")
    @Column(name="section")
    public List<PageSection> getSections() {
        return this.sections;
    }

    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    public PageStatus getStatus() {
        return this.status;
    }

    @Column(nullable=false)
    public String getLabel() {
        return this.label;
    }

    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.DETACH, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="spg_page_group", joinColumns={@JoinColumn(name="language"), @JoinColumn(name="linktext")}, inverseJoinColumns={@JoinColumn(name="groupid", referencedColumnName="id", unique=false)})
    public Set<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public void setPageIdentity(PageIdentity pageIdentity) {
        this.pageIdentity = pageIdentity;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setFormat(PageFormat format) {
        this.format = format;
    }

    public void setSections(List<PageSection> sections) {
        this.sections = sections;
    }

    public void setStatus(PageStatus status) {
        this.status = status;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return String.format("Entity of type %s with id: %s", this.getClass().getName(), this.getPageIdentity().getLinkText());
    }

    public static enum PageExtension {
        HTML,
        TXT,
        MD;

    }

    public static enum PageSection {
        TOP,
        FOOTER,
        MENU,
        SUBMENU,
        RECORD_VIEW_MENU,
        CUSTOM_MENU1,
        CUSTOM_MENU2,
        CUSTOM_MENU3;

    }

    public static enum PageFormat {
        LINK,
        HTML,
        HTMLPAGE,
        TEXT,
        EMAILLINK;

    }

    public static enum PageStatus {
        PUBLIC,
        PUBLIC_ONLY,
        GROUPS,
        PRIVATE,
        HIDDEN;

    }
}

