/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.image.ImageWorker;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.BandMergeNode;
import org.geotools.renderer.lite.gridcoverage2d.BandSelectionNode;
import org.geotools.renderer.lite.gridcoverage2d.ContrastEnhancementNode;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.RootNode;
import org.geotools.renderer.lite.gridcoverage2d.SubchainStyleVisitorCoverageProcessingAdapter;
import org.geotools.renderer.lite.gridcoverage2d.ZeroImageNode;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.Hints;
import org.opengis.util.InternationalString;

class ChannelSelectionNode
extends SubchainStyleVisitorCoverageProcessingAdapter
implements StyleVisitor,
CoverageProcessingNode {
    private static final Logger LOGGER = Logger.getLogger(ChannelSelectionNode.class.getName());

    @Override
    public InternationalString getName() {
        return Vocabulary.formatInternational(4);
    }

    public ChannelSelectionNode() {
        this((Hints)null);
    }

    public ChannelSelectionNode(Hints hints) {
        super(3, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)"ChannelSelectionNode"), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Node which applies a ChannelSelection following SLD 1.0 spec."));
    }

    @Override
    public void visit(ChannelSelection cs) {
        List<CoverageProcessingNode> localSources = this.getSources();
        int length = localSources.size();
        if (length == 0) {
            throw new IllegalArgumentException(Errors.format(3, "ChannelSelectionNode"));
        }
        GridCoverage2D source = (GridCoverage2D)this.getSource(0).getOutput();
        GridCoverageRendererUtilities.ensureSourceNotNull(source, this.getName().toString());
        RootNode chainSource = new RootNode(source, this.getHints());
        BandMergeNode subChainSink = new BandMergeNode(this.getHints());
        RenderedImage sourceImage = source.getRenderedImage();
        boolean hasAlpha = sourceImage != null && sourceImage.getColorModel() != null && sourceImage.getColorModel().hasAlpha();
        RenderedImage alpha = null;
        if (hasAlpha) {
            alpha = new ImageWorker(sourceImage).setRenderingHints((RenderingHints)this.getHints()).retainLastBand().getRenderedImage();
            subChainSink.setAlpha(alpha);
        }
        this.setSink(subChainSink);
        if (cs != null) {
            SelectedChannelType[] selectedChannelTypeArray;
            SelectedChannelType[] rgb = cs.getRGBChannels();
            SelectedChannelType gray = cs.getGrayChannel();
            if (rgb != null && rgb[0] != null && rgb[1] != null && rgb[2] != null && gray != null) {
                throw new IllegalArgumentException(Errors.format(9, "Both gray and rgb channel selection are valid!"));
            }
            if (gray == null) {
                selectedChannelTypeArray = rgb;
            } else {
                SelectedChannelType[] selectedChannelTypeArray2 = new SelectedChannelType[1];
                selectedChannelTypeArray = selectedChannelTypeArray2;
                selectedChannelTypeArray2[0] = gray;
            }
            SelectedChannelType[] sc = selectedChannelTypeArray;
            if (sc != null && (sc.length == 1 && sc[0] != null || sc.length == 3 && (sc[0] != null || sc[1] != null || sc[2] != null))) {
                for (int i = 0; i < sc.length; ++i) {
                    SelectedChannelType channel = sc[i];
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Channel " + i + " was " + Optional.ofNullable(channel).map(c -> c.getChannelName()).orElse(null));
                    }
                    if (channel == null) {
                        ZeroImageNode zero = new ZeroImageNode(this.getHints());
                        zero.addSource(chainSource);
                        subChainSink.addSource(zero);
                        zero.addSink(subChainSink);
                        continue;
                    }
                    BandSelectionNode bandSelectionNode = new BandSelectionNode();
                    bandSelectionNode.addSource(chainSource);
                    bandSelectionNode.visit(channel);
                    ContrastEnhancementNode contrastenhancementNode = new ContrastEnhancementNode();
                    contrastenhancementNode.addSource(bandSelectionNode);
                    bandSelectionNode.addSink(contrastenhancementNode);
                    contrastenhancementNode.visit(channel != null ? channel.getContrastEnhancement() : null);
                    contrastenhancementNode.addSink(subChainSink);
                    subChainSink.addSource(contrastenhancementNode);
                }
                return;
            }
        }
        subChainSink.addSource(chainSource);
    }
}

