/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.geotools.filter.visitor.DefaultExpressionVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.InternalFunction;
import org.opengis.filter.expression.VolatileFunction;

class FilterMemoizer {
    static final Logger LOGGER = Logging.getLogger(FilterMemoizer.class);
    static final Object NULL_PLACEHOLDER = new Object();

    FilterMemoizer() {
    }

    public static <T extends Filter> T memoize(T delegate) {
        MemoizableExpressionChecker checker = new MemoizableExpressionChecker();
        delegate.accept((FilterVisitor)new AbstractFilterVisitor(checker), null);
        if (!checker.memoizable) {
            return delegate;
        }
        Filter result = (Filter)Proxy.newProxyInstance(FilterMemoizer.class.getClassLoader(), delegate.getClass().getInterfaces(), new MemoizingHandler<T>(delegate));
        return (T)result;
    }

    private static class MemoizingHandler<T extends Filter>
    implements InvocationHandler {
        private final T delegate;
        Object lastFeature;
        boolean lastResult;
        Method lastMethod;

        public MemoizingHandler(T delegate) {
            this.delegate = delegate;
            this.lastFeature = NULL_PLACEHOLDER;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.lastMethod == method || "evaluate".equals(method.getName()) && method.getParameterTypes().length == 1) {
                this.lastMethod = method;
                if (args[0] != this.lastFeature) {
                    this.lastFeature = args[0];
                    this.lastResult = this.delegate.evaluate(args[0]);
                }
                return this.lastResult;
            }
            return method.invoke(this.delegate, args);
        }
    }

    static class MemoizableExpressionChecker
    extends DefaultExpressionVisitor {
        boolean memoizable = true;

        MemoizableExpressionChecker() {
        }

        @Override
        public Object visit(Function expr, Object extraData) {
            if (expr instanceof VolatileFunction || expr instanceof InternalFunction) {
                this.memoizable = false;
            }
            return expr;
        }
    }
}

