/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.sftp;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.Transactional;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.exceptions.NoSchemaMatchesException;
import org.fao.geonet.exceptions.SchemaMatchConflictException;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.HarvesterUtil;
import org.fao.geonet.kernel.harvest.harvester.RecordInfo;
import org.fao.geonet.kernel.harvest.harvester.UUIDMapper;
import org.fao.geonet.kernel.harvest.harvester.sftp.SftpHarvesterUtil;
import org.fao.geonet.kernel.harvest.harvester.sftp.SftpParams;
import org.fao.geonet.kernel.harvest.harvester.sftp.client.SftpClient;
import org.fao.geonet.kernel.harvest.harvester.sftp.client.SftpFileInfo;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;

public class Aligner
extends BaseAligner<SftpParams> {
    private final ServiceContext context;
    private final IMetadataUtils metadataUtils;
    private final IMetadataManager metadataManager;
    private final IMetadataIndexer metadataIndexer;
    private final IMetadataSchemaUtils metadataSchemaUtils;
    private final Logger log;
    private CategoryMapper localCateg;
    private GroupMapper localGroups;
    private UUIDMapper localUuids;
    private HarvestResult result;
    private String processName;
    private Map<String, Object> processParams = new HashMap<String, Object>();
    private final Set<Integer> idsForHarvestingResult = new HashSet<Integer>();

    protected Aligner(AtomicBoolean cancelMonitor, ServiceContext sc, SftpParams params, Logger log) {
        super(cancelMonitor);
        this.metadataUtils = (IMetadataUtils)sc.getBean(IMetadataUtils.class);
        this.metadataManager = (IMetadataManager)sc.getBean(IMetadataManager.class);
        this.metadataIndexer = (IMetadataIndexer)sc.getBean(IMetadataIndexer.class);
        this.metadataSchemaUtils = (IMetadataSchemaUtils)sc.getBean(IMetadataSchemaUtils.class);
        this.context = sc;
        this.params = params;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarvestResult align(Collection<HarvestError> errors) throws Exception {
        this.localCateg = new CategoryMapper(this.context);
        this.localGroups = new GroupMapper(this.context);
        this.localUuids = new UUIDMapper((IMetadataUtils)this.context.getBean(IMetadataUtils.class), ((SftpParams)this.params).getUuid());
        Pair<String, Map<String, Object>> filter = HarvesterUtil.parseXSLFilter(((SftpParams)this.params).xslfilter);
        this.processName = (String)filter.one();
        this.processParams = (Map)filter.two();
        this.result = new HarvestResult();
        try (SftpClient sftpClient = new SftpClient(((SftpParams)this.params).server, Integer.parseInt(((SftpParams)this.params).port), ((SftpParams)this.params).getUsername());){
            if (((SftpParams)this.params).useAuthKey) {
                sftpClient.authKey(SftpHarvesterUtil.getPrivateKeyFilePath(this.context, ((SftpParams)this.params).getUuid()).toString(), "");
            } else {
                sftpClient.authPassword(((SftpParams)this.params).getPassword());
            }
            String remoteFolder = this.normalizeFolderPath(((SftpParams)this.params).folder);
            List<SftpFileInfo> remoteFiles = sftpClient.listFiles(remoteFolder, "xml", ((SftpParams)this.params).recurse);
            for (SftpFileInfo remoteFile : remoteFiles) {
                if (this.cancelMonitor.get()) {
                    HarvestResult harvestResult = this.result;
                    return harvestResult;
                }
                String remotefilePath = this.normalizeFolderPath(remoteFile.getFolder()) + remoteFile.getFileName();
                String fileContent = sftpClient.getFileAsText(remotefilePath);
                try {
                    Element md = Xml.loadString((String)fileContent, (boolean)false);
                    if (!((SftpParams)this.params).xslfilter.isEmpty() && !this.isSchemaXslProcess(((SftpParams)this.params).xslfilter)) {
                        md = HarvesterUtil.processMetadata(null, md, this.processName, this.processParams);
                    }
                    String schema = this.metadataSchemaUtils.autodetectSchema(md, null);
                    String uuid = this.metadataUtils.extractUUID(schema, md);
                    String modified = this.metadataUtils.extractDateModified(schema, md);
                    boolean valid = true;
                    try {
                        Integer groupIdVal = null;
                        if (StringUtils.isNotEmpty((String)((SftpParams)this.params).getOwnerIdGroup())) {
                            groupIdVal = this.getGroupOwner();
                        }
                        ((SftpParams)this.params).getValidate().validate((DataManager)this.context.getBean(DataManager.class), this.context, md, groupIdVal);
                    }
                    catch (Exception e) {
                        this.log.info("Ignoring invalid metadata with uuid " + uuid);
                        ++this.result.doesNotValidate;
                        valid = false;
                    }
                    if (!valid) continue;
                    RecordInfo ri = new RecordInfo(uuid, modified);
                    this.insertOrUpdate(ri, md, errors);
                }
                catch (NoSchemaMatchesException | SchemaMatchConflictException e) {
                    this.log.info("  - Metadata skipped due to unknown schema. Remote file:" + remotefilePath);
                    ++this.result.unknownSchema;
                }
                catch (IOException | JDOMException e) {
                    this.log.info("  - Metadata skipped due to bad format schema. Remote file:" + remotefilePath);
                    ++this.result.badFormat;
                }
            }
        }
        this.log.debug("Starting to delete locally existing metadata from the same source if they  were not in this harvesting result...");
        List existingMetadata = ((MetadataRepository)this.context.getBean(MetadataRepository.class)).findIdsBy(MetadataSpecs.hasHarvesterUuid((String)((SftpParams)this.params).getUuid()));
        for (Integer existingId : existingMetadata) {
            if (this.cancelMonitor.get()) {
                return this.result;
            }
            if (this.idsForHarvestingResult.contains(existingId)) continue;
            this.log.debug("  Removing: " + existingId);
            this.metadataManager.deleteMetadata(this.context, existingId.toString());
            ++this.result.locallyRemoved;
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertOrUpdate(RecordInfo ri, Element md, Collection<HarvestError> errors) {
        try {
            block14: {
                String id;
                block15: {
                    block13: {
                        id = this.metadataUtils.getMetadataId(ri.uuid);
                        if (id != null) break block13;
                        this.log.debug("Adding record with uuid " + ri.uuid);
                        this.addMetadata(ri, md, ri.uuid);
                        break block14;
                    }
                    if (this.localUuids.getID(ri.uuid) != null) break block15;
                    ++this.result.datasetUuidExist;
                    switch (((SftpParams)this.params).getOverrideUuid()) {
                        case OVERRIDE: {
                            this.updateMetadata(ri, Integer.toString(this.metadataUtils.findOneByUuid(ri.uuid).getId()), md, true);
                            this.log.debug("Overriding record with uuid " + ri.uuid);
                            if (((SftpParams)this.params).isIfRecordExistAppendPrivileges()) {
                                this.addPrivileges(id, ((SftpParams)this.params).getPrivileges(), this.localGroups, this.context);
                                ++this.result.privilegesAppendedOnExistingRecord;
                                break;
                            }
                            break block14;
                        }
                        case RANDOM: {
                            this.log.debug("Generating random uuid for remote record with uuid " + ri.uuid);
                            this.addMetadata(ri, md, UUID.randomUUID().toString());
                            break;
                        }
                        case SKIP: {
                            this.log.info("Skipping record with uuid " + ri.uuid + " because it already exists in the catalogue from other source");
                            ++this.result.uuidSkipped;
                            break;
                        }
                    }
                    break block14;
                }
                this.updateMetadata(ri, id, md, false);
                if (((SftpParams)this.params).isIfRecordExistAppendPrivileges()) {
                    this.addPrivileges(id, ((SftpParams)this.params).getPrivileges(), this.localGroups, this.context);
                    ++this.result.privilegesAppendedOnExistingRecord;
                }
            }
            ++this.result.totalMetadata;
        }
        catch (Exception t) {
            errors.add(new HarvestError(this.context, t));
            this.log.error("Unable to process record from sftp (" + ((SftpParams)this.params).getName() + ")");
            this.log.error("   Record failed: " + ri.uuid + ". Error is: " + t.getMessage());
            this.log.error((Throwable)t);
        }
        finally {
            ++this.result.originalMetadata;
        }
    }

    private void addMetadata(RecordInfo ri, Element md, String uuidToAssign) throws Exception {
        boolean newMdUuidFromXslt;
        if (this.cancelMonitor.get()) {
            return;
        }
        if (md == null) {
            return;
        }
        String schema = this.metadataSchemaUtils.autodetectSchema(md, null);
        if (schema == null) {
            this.log.info("  - Metadata skipped due to unknown schema. uuid:" + ri.uuid);
            ++this.result.unknownSchema;
            return;
        }
        this.log.debug("  - Adding metadata with remote uuid:" + ri.uuid + " schema:" + schema);
        String newMdUuid = null;
        if (!((SftpParams)this.params).xslfilter.isEmpty() && this.isSchemaXslProcess(((SftpParams)this.params).xslfilter)) {
            md = HarvesterUtil.processMetadata(this.metadataSchemaUtils.getSchema(schema), md, this.processName, this.processParams);
            schema = this.metadataSchemaUtils.autodetectSchema(md);
            newMdUuid = this.metadataUtils.extractUUID(schema, md);
        }
        boolean bl = newMdUuidFromXslt = !StringUtils.isBlank(newMdUuid);
        if (((SftpParams)this.params).isTranslateContent()) {
            md = this.translateMetadataContent(this.context, md, schema);
        }
        Metadata metadata = new Metadata();
        if (newMdUuidFromXslt) {
            metadata.setUuid(newMdUuid);
        } else {
            metadata.setUuid(uuidToAssign);
            if (!uuidToAssign.equals(ri.uuid)) {
                md = this.metadataUtils.setUUID(schema, uuidToAssign, md);
            }
        }
        Integer ownerId = this.getOwner();
        metadata.getDataInfo().setSchemaId(schema).setRoot(md.getQualifiedName()).setType(MetadataType.METADATA).setChangeDate(new ISODate(ri.changeDate)).setCreateDate(new ISODate(ri.changeDate));
        metadata.getSourceInfo().setSourceId(((SftpParams)this.params).getUuid()).setOwner(ownerId).setGroupOwner(Integer.valueOf(this.getGroupOwner()));
        metadata.getHarvestInfo().setHarvested(true).setUuid(((SftpParams)this.params).getUuid());
        metadata.getSourceInfo().setGroupOwner(Integer.valueOf(this.getGroupOwner()));
        this.addCategories((AbstractMetadata)metadata, ((SftpParams)this.params).getCategories(), this.localCateg, this.context, null, false);
        metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, md, IndexingMode.none, false, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        this.addPrivileges(id, ((SftpParams)this.params).getPrivileges(), this.localGroups, this.context);
        this.metadataIndexer.indexMetadata(id, true, IndexingMode.full);
        ++this.result.addedMetadata;
        this.idsForHarvestingResult.add(metadata.getId());
    }

    private void updateMetadata(RecordInfo ri, String id, Element md, boolean force) throws Exception {
        String date = this.localUuids.getChangeDate(ri.uuid);
        if (date == null && !force) {
            this.log.debug("  - Skipped metadata managed by another harvesting node. uuid:" + ri.uuid + ", name:" + ((SftpParams)this.params).getName());
        } else if (!force && !ri.isMoreRecentThan(date)) {
            this.log.debug("  - Metadata XML not changed for uuid:" + ri.uuid);
            ++this.result.unchangedMetadata;
        } else {
            this.log.debug("  - Updating local metadata for uuid:" + ri.uuid);
            if (this.updatingLocalMetadata(ri, id, md, force)) {
                this.metadataIndexer.indexMetadata(id, true, IndexingMode.full);
                ++this.result.updatedMetadata;
            }
        }
        this.idsForHarvestingResult.add(Integer.parseInt(id));
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    boolean updatingLocalMetadata(RecordInfo ri, String id, Element md, boolean force) throws Exception {
        if (md == null) {
            return false;
        }
        String schema = this.metadataSchemaUtils.autodetectSchema(md, null);
        boolean updateSchema = false;
        if (!((SftpParams)this.params).xslfilter.isEmpty() && this.isSchemaXslProcess(((SftpParams)this.params).xslfilter)) {
            md = HarvesterUtil.processMetadata(this.metadataSchemaUtils.getSchema(schema), md, this.processName, this.processParams);
            String newSchema = this.metadataSchemaUtils.autodetectSchema(md);
            updateSchema = !newSchema.equals(schema);
            schema = newSchema;
        }
        boolean validate = false;
        boolean ufo = false;
        String language = this.context.getLanguage();
        AbstractMetadata metadata = this.metadataManager.updateMetadata(this.context, id, md, validate, ufo, language, ri.changeDate, true, IndexingMode.none);
        if (force || updateSchema) {
            if (force) {
                metadata.getHarvestInfo().setUuid(((SftpParams)this.params).getUuid());
                metadata.getSourceInfo().setSourceId(((SftpParams)this.params).getUuid());
            }
            if (updateSchema) {
                metadata.getDataInfo().setSchemaId(schema);
            }
            this.metadataManager.save(metadata);
        }
        this.addPrivileges(id, ((SftpParams)this.params).getPrivileges(), this.localGroups, this.context);
        metadata.getCategories().clear();
        this.addCategories(metadata, ((SftpParams)this.params).getCategories(), this.localCateg, this.context, null, true);
        return true;
    }

    private String normalizeFolderPath(String path) {
        String fixedPath = path == null ? "/" : (!path.startsWith("/") ? "/" + path : path);
        fixedPath = fixedPath + (fixedPath.endsWith("/") ? "" : "/");
        return fixedPath;
    }

    private boolean isSchemaXslProcess(String processName) {
        return processName.startsWith("schema:");
    }
}

