/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.oaipmh;

import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Util;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.exceptions.BadParameterEx;
import org.jdom.Element;

class Search {
    public String from;
    public String until;
    public String set;
    public String prefix;
    public String stylesheet;

    private Search() {
    }

    public Search(Element search) throws BadInputEx {
        this.from = Util.getParam((Element)search, (String)"from", (String)"");
        this.until = Util.getParam((Element)search, (String)"until", (String)"");
        this.set = Util.getParam((Element)search, (String)"set", (String)"");
        this.prefix = Util.getParam((Element)search, (String)"prefix", (String)"oai_dc");
        this.stylesheet = Util.getParam((Element)search, (String)"stylesheet", (String)"");
        ISODate fromDate = null;
        ISODate untilDate = null;
        try {
            if (StringUtils.isNotEmpty((String)this.from) && !this.from.equalsIgnoreCase("Invalid Date")) {
                fromDate = new ISODate(this.from);
                this.from = fromDate.getDateAsString();
            } else {
                this.from = "";
            }
        }
        catch (Exception e) {
            throw new BadParameterEx("from", (Object)this.from);
        }
        try {
            if (StringUtils.isNotEmpty((String)this.until) && !this.until.equalsIgnoreCase("Invalid Date")) {
                untilDate = new ISODate(this.until);
                this.until = untilDate.getDateAsString();
            } else {
                this.until = "";
            }
        }
        catch (Exception e) {
            throw new BadParameterEx("until", (Object)this.until);
        }
        if (fromDate != null && untilDate != null && fromDate.timeDifferenceInSeconds(untilDate) > 0L) {
            throw new BadParameterEx("from greater than until", (Object)(this.from + ">" + this.until));
        }
    }

    public static Search createEmptySearch() throws BadInputEx {
        Search s = new Search();
        s.from = "";
        s.until = "";
        s.set = "";
        s.prefix = "oai_dc";
        s.stylesheet = "";
        return s;
    }

    public Search copy() {
        Search s = new Search();
        s.from = this.from;
        s.until = this.until;
        s.set = this.set;
        s.prefix = this.prefix;
        s.stylesheet = this.stylesheet;
        return s;
    }
}

