/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.csw;

import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.csw.common.ConstraintLanguage;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.CswOperation;
import org.fao.geonet.csw.common.CswServer;
import org.fao.geonet.csw.common.ElementSetName;
import org.fao.geonet.csw.common.ResultType;
import org.fao.geonet.csw.common.TypeName;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.requests.CatalogRequest;
import org.fao.geonet.csw.common.requests.GetRecordsRequest;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.BadXmlResponseEx;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.IHarvester;
import org.fao.geonet.kernel.harvest.harvester.RecordInfo;
import org.fao.geonet.kernel.harvest.harvester.csw.Aligner;
import org.fao.geonet.kernel.harvest.harvester.csw.CswParams;
import org.fao.geonet.kernel.harvest.harvester.csw.Search;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.AbstractHttpRequest;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

class Harvester
implements IHarvester<HarvestResult> {
    public static final String PREFERRED_HTTP_METHOD = AbstractHttpRequest.Method.POST.toString();
    private static final String ATTRIB_SEARCHRESULT_MATCHED = "numberOfRecordsMatched";
    private static final String ATTRIB_SEARCHRESULT_RETURNED = "numberOfRecordsReturned";
    private static final String ATTRIB_SEARCHRESULT_NEXT = "nextRecord";
    private static int GETRECORDS_REQUEST_MAXRECORDS = 20;
    private static String CONSTRAINT_LANGUAGE_VERSION = "1.1.0";
    private static final String GETCAPABILITIES_PARAMETERS = "SERVICE=CSW&REQUEST=GetCapabilities&VERSION=2.0.2";
    private final AtomicBoolean cancelMonitor;
    private Logger log;
    private final CswParams params;
    private final ServiceContext context;
    private final List<HarvestError> errors;
    public static ImmutableSet<String> bboxParameters = ImmutableSet.builder().add((Object)"bbox-xmin").add((Object)"bbox-ymin").add((Object)"bbox-xmax").add((Object)"bbox-ymax").build();

    public Harvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, CswParams params, List<HarvestError> errors) {
        this.cancelMonitor = cancelMonitor;
        this.log = log;
        this.context = context;
        this.params = params;
        this.errors = errors;
    }

    @Override
    public HarvestResult harvest(Logger log) throws Exception {
        this.log = log;
        log.debug("Retrieving capabilities file for : " + this.params.getName());
        CswServer server = this.retrieveCapabilities(log);
        if (this.cancelMonitor.get()) {
            return new HarvestResult();
        }
        boolean error = false;
        HarvestResult result = new HarvestResult();
        HashSet<String> uuids = new HashSet<String>();
        try {
            Aligner aligner = new Aligner(this.cancelMonitor, this.context, server, this.params, log);
            this.searchAndAlign(server, uuids, aligner, this.errors);
            result = aligner.cleanupRemovedRecords(uuids);
        }
        catch (Exception t) {
            error = true;
            log.error("Unknown error trying to harvest");
            log.error(t.getMessage());
            log.error((Throwable)t);
            this.errors.add(new HarvestError(this.context, t));
        }
        catch (Throwable t) {
            error = true;
            log.fatal("Something unknown and terrible happened while harvesting");
            log.fatal(t.getMessage());
            this.errors.add(new HarvestError(this.context, t));
        }
        log.info("Total records processed in all searches :" + uuids.size());
        if (error) {
            log.warning("Due to previous errors the align process has not been called");
        }
        return result;
    }

    private CswServer retrieveCapabilities(Logger log) throws Exception {
        if (!Lib.net.isUrlValid(this.params.capabUrl)) {
            throw new BadParameterEx("Capabilities URL", (Object)this.params.capabUrl);
        }
        GeonetHttpRequestFactory requestFactory = (GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class);
        XmlRequest req = this.params.capabUrl.contains("GetCapabilities") ? requestFactory.createXmlRequest(new URL(this.params.capabUrl)) : requestFactory.createXmlRequest(new URL(this.params.capabUrl + (this.params.capabUrl.contains("?") ? "&" : "?") + GETCAPABILITIES_PARAMETERS));
        Lib.net.setupProxy(this.context, req);
        if (this.params.isUseAccount()) {
            req.setCredentials(this.params.getUsername(), this.params.getPassword());
        }
        CswServer server = null;
        try {
            Element capabil = req.execute();
            if (log.isDebugEnabled()) {
                log.debug("Capabilities:\n" + Xml.getString((Element)capabil));
            }
            if (capabil.getName().equals("ExceptionReport")) {
                CatalogException.unmarshal((Element)capabil);
            }
            if (!this.checkOperation(log, server = new CswServer(capabil), "GetRecords")) {
                throw new OperationAbortedEx("GetRecords operation not found");
            }
            if (!this.checkOperation(log, server, "GetRecordById")) {
                throw new OperationAbortedEx("GetRecordById operation not found");
            }
        }
        catch (BadXmlResponseEx e) {
            this.errors.add(new HarvestError(this.context, e, this.params.capabUrl));
            throw e;
        }
        return server;
    }

    private boolean checkOperation(Logger log, CswServer server, String name) {
        CswOperation oper = server.getOperation(name);
        if (oper == null) {
            log.warning("Operation not present in capabilities : " + name);
            return false;
        }
        if (oper.getGetUrl() == null && oper.getPostUrl() == null) {
            log.warning("Operation has no GET and POST bindings : " + name);
            return false;
        }
        return true;
    }

    private void searchAndAlign(CswServer server, Set<String> uuids, Aligner aligner, List<HarvestError> harvesterErrors) throws Exception {
        int start = 1;
        GetRecordsRequest request = new GetRecordsRequest(this.context);
        request.setResultType(ResultType.RESULTS);
        if (StringUtils.isNotEmpty((String)this.params.sortBy)) {
            request.addSortBy(this.params.sortBy);
        }
        request.setElementSetName(ElementSetName.SUMMARY);
        request.setMaxRecords(Integer.valueOf(GETRECORDS_REQUEST_MAXRECORDS));
        request.setDistribSearch(this.params.queryScope.equalsIgnoreCase("distributed"));
        request.setHopCount(this.params.hopCount);
        CswOperation oper = server.getOperation("GetRecords");
        this.configRequest(request, oper, server, PREFERRED_HTTP_METHOD);
        if (this.params.isUseAccount()) {
            this.log.debug("Logging into server (" + this.params.getUsername() + ")");
            request.setCredentials(this.params.getUsername(), this.params.getPassword());
        }
        if (StringUtils.isNotBlank((String)this.params.getApiKey())) {
            this.log.debug("Using apiKey to authenticate");
            request.setApiKey(this.params.getApiKeyHeader(), this.params.getApiKey());
        }
        try {
            this.log.debug(String.format("Trying the search with HTTP %s method.", PREFERRED_HTTP_METHOD));
            request.setStartPosition(Integer.valueOf(start));
            this.doSearch((CatalogRequest)request, start, 1);
        }
        catch (Exception ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(ex.getMessage());
                this.log.debug(String.format("Due to errors, changing CSW harvester method to HTTP %s method.", PREFERRED_HTTP_METHOD.equals("GET") ? "POST" : "GET"));
            }
            this.errors.add(new HarvestError(this.context, ex));
            this.configRequest(request, oper, server, PREFERRED_HTTP_METHOD.equals("GET") ? "POST" : "GET");
        }
        while (true) {
            Element results;
            if (this.cancelMonitor.get()) {
                this.log.error("Harvester stopped in the middle of running!");
                return;
            }
            request.setStartPosition(Integer.valueOf(start));
            Element response = this.doSearch((CatalogRequest)request, start, GETRECORDS_REQUEST_MAXRECORDS);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Number of child elements in response: " + response.getChildren().size());
            }
            if ((results = response.getChild("SearchResults", Csw.NAMESPACE_CSW)) == null) {
                results = response.getChild("SearchResults", Csw.NAMESPACE_CSW_OLD);
                if (results == null) {
                    throw new OperationAbortedEx("Missing 'SearchResults'", (Object)response);
                }
                this.log.warning("Received GetRecords response with incorrect namespace: " + Csw.NAMESPACE_CSW_OLD);
            }
            if (this.cancelMonitor.get()) {
                this.log.error("Harvester stopped in the middle of running!");
                return;
            }
            List list = results.getChildren();
            int foundCnt = 0;
            this.log.debug("Extracting all elements in the csw harvesting response");
            LinkedHashSet<RecordInfo> records = new LinkedHashSet<RecordInfo>();
            for (Element record : list) {
                try {
                    RecordInfo recInfo = this.getRecordInfo((Element)record.clone());
                    if (recInfo == null) continue;
                    records.add(recInfo);
                    uuids.add(recInfo.uuid);
                }
                catch (Exception ex) {
                    this.errors.add(new HarvestError(this.context, ex));
                    this.log.error("Unable to process record from csw (" + this.params.getName() + ")");
                    this.log.error("   Record failed: " + foundCnt);
                    this.log.debug("   Record: " + record.getName());
                }
            }
            foundCnt += records.size();
            aligner.align(records, harvesterErrors);
            int matchedCount = this.getSearchResultAttribute(results, ATTRIB_SEARCHRESULT_MATCHED);
            int returnedCount = this.getSearchResultAttribute(results, ATTRIB_SEARCHRESULT_RETURNED);
            Integer nextRecord = this.getOptionalSearchResultAttribute(results, ATTRIB_SEARCHRESULT_NEXT);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Records matched by the query : " + matchedCount);
                this.log.debug("Records declared in response : " + returnedCount);
                this.log.debug("Records found in response    : " + foundCnt);
                this.log.debug("Next record                  : " + nextRecord);
            }
            if (returnedCount != GETRECORDS_REQUEST_MAXRECORDS) {
                this.log.warning("Declared number of returned records (" + returnedCount + ") does not match requested record count (" + GETRECORDS_REQUEST_MAXRECORDS + ")");
            }
            if (returnedCount != foundCnt) {
                this.log.warning("Declared number of returned records (" + returnedCount + ") does not match actual record count (" + foundCnt + ")");
            }
            if (nextRecord == null) {
                this.log.warning("Declared nextRecord is null");
            }
            if (nextRecord != null && nextRecord == 0) break;
            if (nextRecord != null && nextRecord > matchedCount) {
                this.log.warning("Forcing harvest end since next > matched");
                break;
            }
            if (returnedCount == 0) {
                this.log.warning("Forcing harvest end since numberOfRecordsReturned = 0");
                break;
            }
            if (nextRecord != null && nextRecord < start) {
                this.log.warning(String.format("Forcing harvest end since nextRecord < start (nextRecord = %d, start = %d)", nextRecord, start));
                break;
            }
            start += returnedCount;
        }
        this.log.debug("Records added to result list : " + uuids.size());
    }

    private void setUpRequest(GetRecordsRequest request, CswOperation oper, CswServer server, URL url, ConstraintLanguage constraintLanguage, String constraint, AbstractHttpRequest.Method method) {
        request.setUrl(this.context, url);
        request.setServerVersion(server.getPreferredServerVersion());
        String preferredOutputSchema = oper.getPreferredOutputSchema();
        if (this.params.outputSchema != null && !this.params.outputSchema.isEmpty()) {
            preferredOutputSchema = this.params.outputSchema;
        }
        request.setOutputSchema(preferredOutputSchema);
        if (StringUtils.isNotEmpty((String)constraint)) {
            request.setConstraintLanguage(constraintLanguage);
            request.setConstraintLangVersion(CONSTRAINT_LANGUAGE_VERSION);
            request.setConstraint(constraint);
        }
        request.setMethod(method);
        if (this.params.outputSchema != null && !this.params.outputSchema.isEmpty()) {
            if ("http://www.isotc211.org/2005/gmd".equals(this.params.outputSchema)) {
                request.addTypeName(TypeName.getTypeName((String)"gmd:MD_Metadata"));
            } else if ("http://www.opengis.net/cat/csw/2.0.2".equals(this.params.outputSchema)) {
                request.addTypeName(TypeName.getTypeName((String)"csw:Record"));
            } else {
                request.addTypeName(TypeName.getTypeName((String)"csw:Record"));
            }
        } else {
            for (String typeName : oper.getTypeNamesList()) {
                request.addTypeName(TypeName.getTypeName((String)typeName));
            }
        }
        request.setOutputFormat(oper.getPreferredOutputFormat());
    }

    private void configRequest(GetRecordsRequest request, CswOperation oper, CswServer server, String preferredMethod) throws Exception {
        if (oper.getGetUrl() == null && oper.getPostUrl() == null) {
            throw new OperationAbortedEx("No GET or POST DCP available in this service.");
        }
        if (oper.getGetUrl() != null && preferredMethod.equals("GET") && oper.getConstraintLanguage().contains("cql_text")) {
            this.setUpRequest(request, oper, server, oper.getGetUrl(), ConstraintLanguage.CQL, this.getCqlConstraint(this.params.eltFilters, this.params.bboxFilter), AbstractHttpRequest.Method.GET);
        } else if (oper.getPostUrl() != null && preferredMethod.equals("POST") && oper.getConstraintLanguage().contains("filter")) {
            this.setUpRequest(request, oper, server, oper.getPostUrl(), ConstraintLanguage.FILTER, this.getFilterConstraint(this.params.eltFilters, this.params.bboxFilter), AbstractHttpRequest.Method.POST);
        } else if (oper.getGetUrl() != null && oper.getConstraintLanguage().contains("cql_text")) {
            this.setUpRequest(request, oper, server, oper.getGetUrl(), ConstraintLanguage.CQL, this.getCqlConstraint(this.params.eltFilters, this.params.bboxFilter), AbstractHttpRequest.Method.GET);
        } else if (oper.getPostUrl() != null && oper.getConstraintLanguage().contains("filter")) {
            this.setUpRequest(request, oper, server, oper.getPostUrl(), ConstraintLanguage.FILTER, this.getFilterConstraint(this.params.eltFilters, this.params.bboxFilter), AbstractHttpRequest.Method.POST);
        } else {
            this.log.warning("No GET (using CQL) or POST (using FE) DCP available in this service... Trying GET CQL anyway ...");
            this.setUpRequest(request, oper, server, oper.getGetUrl(), ConstraintLanguage.CQL, this.getCqlConstraint(this.params.eltFilters, this.params.bboxFilter), AbstractHttpRequest.Method.GET);
        }
    }

    private String getFilterConstraint(Search s) {
        ArrayList<Element> queriables = new ArrayList<Element>();
        HashMap<String, Double> bboxCoordinates = new HashMap<String, Double>();
        if (!s.attributesMap.isEmpty()) {
            for (Map.Entry<String, String> entry : s.attributesMap.entrySet()) {
                if (entry.getValue() == null) continue;
                String queryableName = entry.getKey();
                if (bboxParameters.contains((Object)queryableName) && StringUtils.isNotEmpty((String)entry.getValue())) {
                    bboxCoordinates.put(queryableName, Double.valueOf(entry.getValue()));
                    continue;
                }
                if (queryableName.contains("__")) {
                    queryableName = queryableName.replace("__", ":");
                    this.buildFilterQueryable(queriables, queryableName, entry.getValue());
                    continue;
                }
                if (queryableName.contains(":")) continue;
                queryableName = "csw:" + queryableName;
                this.buildFilterQueryable(queriables, queryableName, entry.getValue());
            }
        } else {
            this.log.debug("no search criterion specified, harvesting all ... ");
        }
        if (queriables.isEmpty()) {
            return null;
        }
        Element filter = new Element("Filter", Csw.NAMESPACE_OGC);
        if (queriables.size() == 1 && bboxCoordinates.size() == 0) {
            filter.addContent((Content)queriables.get(0));
        } else {
            Element and = new Element("And", Csw.NAMESPACE_OGC);
            for (Element prop : queriables) {
                and.addContent((Content)prop);
            }
            if (bboxCoordinates.size() > 0) {
                and.addContent(this.buildBboxFilter(bboxCoordinates));
            }
            filter.addContent((Content)and);
        }
        return Xml.getString((Element)filter);
    }

    private Content buildBboxFilter(Map<String, Double> bboxCoordinates) {
        Namespace gml = Namespace.getNamespace((String)"http://www.opengis.net/gml");
        Element bbox = new Element("BBOX", Csw.NAMESPACE_OGC);
        Element bboxProperty = new Element("PropertyName", Csw.NAMESPACE_OGC);
        bboxProperty.setText("ows:BoundingBox");
        bbox.addContent((Content)bboxProperty);
        Element envelope = new Element("Envelope", gml);
        Element lowerCorner = new Element("lowerCorner", gml);
        lowerCorner.setText(bboxCoordinates.get("bbox-xmin") + " " + bboxCoordinates.get("bbox-ymin"));
        Element upperCorner = new Element("upperCorner", gml);
        upperCorner.setText(bboxCoordinates.get("bbox-xmax") + " " + bboxCoordinates.get("bbox-ymax"));
        envelope.addContent((Content)lowerCorner);
        envelope.addContent((Content)upperCorner);
        bbox.addContent((Content)envelope);
        return bbox;
    }

    private void buildFilterQueryable(List<Element> queryables, String name, String value) {
        if (value.contains("%")) {
            this.buildFilterQueryable(queryables, name, value, "PropertyIsLike");
        } else {
            this.buildFilterQueryable(queryables, name, value, "PropertyIsEqualTo");
        }
    }

    private void buildFilterQueryable(List<Element> queryables, String name, String value, String operator) {
        Element prop;
        if (value.length() == 0) {
            return;
        }
        if (operator.equals("PropertyIsLike")) {
            prop = new Element(operator, Csw.NAMESPACE_OGC);
            prop.setAttribute("wildCard", "%");
            prop.setAttribute("singleChar", "_");
            prop.setAttribute("escapeChar", "\\");
        } else {
            prop = new Element(operator, Csw.NAMESPACE_OGC);
        }
        Element propName = new Element("PropertyName", Csw.NAMESPACE_OGC);
        Element literal = new Element("Literal", Csw.NAMESPACE_OGC);
        propName.setText(name);
        literal.setText(value);
        prop.addContent((Content)propName);
        prop.addContent((Content)literal);
        queryables.add(prop);
    }

    private String getFilterConstraint(List<Element> filters, Element bboxFilter) throws Exception {
        Path file = this.context.getAppPath().resolve("xml").resolve("csw").resolve("harvester-csw-filter.xsl");
        Element eltFilter = new Element("filters");
        for (Element e : filters) {
            Element e1 = (Element)e.clone();
            eltFilter.addContent(e1.detach());
        }
        Element cswFilter = Xml.transform((Element)eltFilter, (Path)file);
        if (bboxFilter != null) {
            HashMap<String, Double> bboxCoordinates = new HashMap<String, Double>();
            bboxCoordinates.put("bbox-xmin", Double.parseDouble(bboxFilter.getChildText("bbox-xmin")));
            bboxCoordinates.put("bbox-ymin", Double.parseDouble(bboxFilter.getChildText("bbox-ymin")));
            bboxCoordinates.put("bbox-xmax", Double.parseDouble(bboxFilter.getChildText("bbox-xmax")));
            bboxCoordinates.put("bbox-ymax", Double.parseDouble(bboxFilter.getChildText("bbox-ymax")));
            if (cswFilter.getChildren().size() == 0) {
                cswFilter.addContent(this.buildBboxFilter(bboxCoordinates));
            } else {
                Element filterContent = (Element)cswFilter.getChildren().get(0);
                filterContent = (Element)filterContent.detach();
                Element and = new Element("And", Csw.NAMESPACE_OGC);
                and.addContent((Content)filterContent);
                and.addContent(this.buildBboxFilter(bboxCoordinates));
                cswFilter.setContent((Content)and);
            }
        }
        if (cswFilter.getChildren().size() == 0) {
            return "";
        }
        return Xml.getString((Element)cswFilter);
    }

    private String getCqlConstraint(List<Element> filters, Element bboxFilter) throws Exception {
        String cqlFilter = "";
        if (filters.size() > 0) {
            Path file = this.context.getAppPath().resolve("xml").resolve("csw").resolve("harvester-csw-cql.xsl");
            Element eltFilter = new Element("filters");
            for (Element e : filters) {
                Element e1 = (Element)e.clone();
                eltFilter.addContent(e1.detach());
            }
            Element cswFilter = Xml.transform((Element)eltFilter, (Path)file);
            cqlFilter = cswFilter.getText();
        }
        if (bboxFilter != null) {
            HashMap<String, Double> bboxCoordinates = new HashMap<String, Double>();
            bboxCoordinates.put("bbox-xmin", Double.parseDouble(bboxFilter.getChildText("bbox-xmin")));
            bboxCoordinates.put("bbox-ymin", Double.parseDouble(bboxFilter.getChildText("bbox-ymin")));
            bboxCoordinates.put("bbox-xmax", Double.parseDouble(bboxFilter.getChildText("bbox-xmax")));
            bboxCoordinates.put("bbox-ymax", Double.parseDouble(bboxFilter.getChildText("bbox-ymax")));
            if (StringUtils.isNotEmpty((String)cqlFilter)) {
                cqlFilter = cqlFilter + " AND ";
            }
            cqlFilter = cqlFilter + String.format("BBOX(the_geom, %s, %s, %s, %s)", bboxCoordinates.get("bbox-xmin"), bboxCoordinates.get("bbox-ymin"), bboxCoordinates.get("bbox-xmax"), bboxCoordinates.get("bbox-ymax"));
        }
        return cqlFilter;
    }

    private Element doSearch(CatalogRequest request, int start, int max) throws Exception {
        try {
            this.log.debug("Searching on : " + this.params.getName() + " (" + start + ".." + (start + max) + ")");
            Element response = request.execute();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sent request " + request.getSentData());
                this.log.debug("Search results:\n" + Xml.getString((Element)response));
            }
            return response;
        }
        catch (Exception e) {
            this.errors.add(new HarvestError(this.context, e));
            this.log.warning("Raised exception when searching : " + e);
            this.log.warning("Url: " + request.getHost());
            this.log.warning("Method: " + request.getMethod());
            this.log.warning("Sent request " + request.getSentData());
            throw new OperationAbortedEx("Raised exception when searching: " + e.getMessage(), (Object)e);
        }
    }

    private int getSearchResultAttribute(Element results, String attribName) throws OperationAbortedEx {
        String value = results.getAttributeValue(attribName);
        if (value == null) {
            throw new OperationAbortedEx("Missing '" + attribName + "' attribute in 'SearchResults'");
        }
        if (!Lib.type.isInteger(value)) {
            throw new OperationAbortedEx("Bad value for '" + attribName + "'", (Object)value);
        }
        return Integer.parseInt(value);
    }

    private Integer getOptionalSearchResultAttribute(Element results, String attribName) throws OperationAbortedEx {
        String value = results.getAttributeValue(attribName);
        if (value == null) {
            return null;
        }
        if (!Lib.type.isInteger(value)) {
            throw new OperationAbortedEx("Bad value for '" + attribName + "'", (Object)value);
        }
        return Integer.valueOf(value);
    }

    private RecordInfo getRecordInfo(Element record) {
        String name = record.getName();
        if (this.log.isDebugEnabled()) {
            this.log.debug("getRecordInfo (name): " + name);
        }
        GeonetContext gc = (GeonetContext)this.context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        try {
            String identif;
            String schema = dm.autodetectSchema(record);
            if (this.log.isDebugEnabled()) {
                this.log.debug("getRecordInfo (schema): " + schema);
            }
            if ((identif = dm.extractUUID(schema, record)).length() == 0) {
                this.log.warning("Record doesn't have a uuid : " + name);
                return null;
            }
            String modified = dm.extractDateModified(schema, record);
            if (modified.length() == 0) {
                modified = null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("getRecordInfo: adding " + identif + " with modification date " + modified);
            }
            return new RecordInfo(identif, modified);
        }
        catch (Exception e) {
            this.log.warning("Skipped record not in supported format : " + name);
            return null;
        }
    }
}

