/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import java.util.Collections;
import java.util.List;
import org.json.JSONException;
import org.mapfish.geo.MfGeo;
import org.mapfish.geo.MfGeoJSONReader;
import org.mapfish.print.InvalidJsonValueException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.MapTileTask;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.readers.MapReaderFactory;
import org.mapfish.print.map.renderers.vector.FeaturesRenderer;
import org.mapfish.print.map.renderers.vector.StyledMfGeoFactory;
import org.mapfish.print.utils.PJsonObject;

public class VectorMapReader
extends MapReader {
    private final MfGeo geo;
    private final RenderingContext context;
    private final String name;

    public VectorMapReader(RenderingContext context, PJsonObject params) {
        super(params);
        this.context = context;
        PJsonObject geoJson = params.getJSONObject("geoJson");
        String styleProperty = params.optString("styleProperty", "_style");
        PJsonObject styles = params.optJSONObject("styles");
        try {
            MfGeoJSONReader reader = new MfGeoJSONReader(new StyledMfGeoFactory(styles, styleProperty));
            this.geo = reader.decode(geoJson.getInternalObj());
        }
        catch (JSONException e) {
            throw new InvalidJsonValueException(params, "geoJson", geoJson.toString(), e);
        }
        this.name = params.optString("name", "vector");
    }

    @Override
    public void render(final Transformer transformer, ParallelMapTileLoader parallelMapTileLoader, String srs, boolean first) {
        parallelMapTileLoader.addTileToLoad(new MapTileTask.RenderOnly(){

            @Override
            public void renderOnPdf(PdfContentByte dc) throws DocumentException {
                FeaturesRenderer.render(VectorMapReader.this.context, dc, VectorMapReader.this.geo, transformer.getGeoTransform(false));
            }
        });
    }

    @Override
    public boolean testMerge(MapReader other) {
        return false;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static class Factory
    implements MapReaderFactory {
        @Override
        public List<? extends MapReader> create(String type, RenderingContext context, PJsonObject params) {
            return Collections.singletonList(new VectorMapReader(context, params));
        }
    }
}

