/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.fao.geonet.config.IPublicationConfig;
import org.fao.geonet.config.PublicationOption;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;

public class DefaultPublicationConfig
implements IPublicationConfig {
    protected List<PublicationOption> publicationOptions = new ArrayList<PublicationOption>();

    @PostConstruct
    public void init() {
        PublicationOption defaultPublication = new PublicationOption("default", ReservedGroup.all, Arrays.asList(ReservedOperation.view, ReservedOperation.download, ReservedOperation.dynamic));
        defaultPublication.addAdditionalPublicationInfo(ReservedGroup.intranet, Arrays.asList(ReservedOperation.view, ReservedOperation.download, ReservedOperation.dynamic));
        this.publicationOptions.add(defaultPublication);
    }

    @Override
    public List<String> getPublicationOptionNames() {
        return this.publicationOptions.stream().map(p -> p.getName()).collect(Collectors.toList());
    }

    @Override
    public List<PublicationOption> getPublicationOptions() {
        return this.publicationOptions;
    }

    @Override
    public Optional<PublicationOption> getPublicationOptionConfiguration(String configName) {
        return this.publicationOptions.stream().filter(p -> p.getName().equals(configName)).findFirst();
    }
}

