/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.extent;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.records.extent.BaseMapRenderingEngine;
import org.fao.geonet.api.records.extent.WMTSClient;
import org.locationtech.jts.geom.Envelope;

public class WMTSBaseMapRenderer
implements BaseMapRenderingEngine {
    public static final String JSON_CapabilitiesURLTag = "wmtsGetCapabilitiesURL";
    public static final String JSON_layerNameTagTag = "layerName";
    public static final String JSON_matrixSetTag = "matrixSet";
    public static final String JSON_SRIDConvertTag = "SRID2MatrixSet";
    public static final String JSON_flip4326Tag = "flip4326";
    Envelope bbox;
    String srs;
    Dimension imageDimensions;
    ServiceContext context;
    URL getCapabilitiesURL;
    String layerName;
    Map<String, String> SRID2MatrixSet = new HashMap<String, String>();
    boolean flip4326 = false;
    String urn4326 = "urn:ogc:def:crs:EPSG::4326";
    String matrixSet;

    @Override
    public boolean canHandle(String configString) {
        return configString.startsWith("{");
    }

    @Override
    public void configure(String configJsonString, Envelope bbox, String srs, Dimension imageDimensions, ServiceContext context) throws Exception {
        if (configJsonString == null) {
            throw new Exception("GetMapBaseMapRenderer: null json/configuration");
        }
        if (bbox == null) {
            throw new Exception("GetMapBaseMapRenderer: null ubboxrl");
        }
        if (srs == null) {
            throw new Exception("GetMapBaseMapRenderer: null srs");
        }
        if (imageDimensions == null) {
            throw new Exception("GetMapBaseMapRenderer: null imageDimensions");
        }
        this.bbox = bbox;
        this.srs = srs;
        this.imageDimensions = imageDimensions;
        this.context = context;
        ObjectMapper mapper = new ObjectMapper();
        Map configuration = (Map)mapper.readValue(configJsonString, Map.class);
        if (!configuration.containsKey(JSON_CapabilitiesURLTag) || configuration.get(JSON_CapabilitiesURLTag) == null || !configuration.get(JSON_CapabilitiesURLTag).toString().toLowerCase().startsWith("http")) {
            throw new Exception("WMTSBaseMapRenderer: json config key=wmtsGetCapabilitiesURL should be start with http or https");
        }
        this.getCapabilitiesURL = new URL(configuration.get(JSON_CapabilitiesURLTag).toString());
        if (!configuration.containsKey(JSON_layerNameTagTag) || configuration.get(JSON_layerNameTagTag) == null || configuration.get(JSON_layerNameTagTag).toString().trim().isEmpty()) {
            throw new Exception("WMTSBaseMapRenderer: json config key=layerName must be present");
        }
        this.layerName = configuration.get(JSON_layerNameTagTag).toString().trim();
        this.matrixSet = configuration.containsKey(JSON_matrixSetTag) && configuration.get(JSON_matrixSetTag) != null && !configuration.get(JSON_matrixSetTag).toString().trim().isEmpty() ? configuration.get(JSON_matrixSetTag).toString().trim() : srs;
        if (configuration.get(JSON_SRIDConvertTag) != null && configuration.get(JSON_SRIDConvertTag) instanceof Map) {
            this.SRID2MatrixSet = (Map)configuration.get(JSON_SRIDConvertTag);
            if (this.SRID2MatrixSet.containsKey(this.matrixSet)) {
                this.matrixSet = this.SRID2MatrixSet.get(this.matrixSet);
            }
        }
        if (configuration.get(JSON_flip4326Tag) != null && configuration.get(JSON_flip4326Tag) instanceof Boolean && ((Boolean)configuration.get(JSON_flip4326Tag)).booleanValue() && srs.equals("EPSG:4326")) {
            this.srs = this.urn4326;
            this.flip4326 = true;
            this.bbox = new Envelope(bbox.getMinY(), bbox.getMaxY(), bbox.getMinX(), bbox.getMaxX());
        }
    }

    @Override
    public BufferedImage render() throws Exception {
        WMTSClient wmtsClient = new WMTSClient(this.getCapabilitiesURL, this.layerName, this.matrixSet);
        BufferedImage image = wmtsClient.createImage(this.bbox.getMinX(), this.bbox.getMinY(), this.bbox.getMaxX(), this.bbox.getMaxY(), (int)this.imageDimensions.getWidth(), (int)this.imageDimensions.getHeight(), this.srs);
        return image;
    }
}

