/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.pages;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.constraints.NotNull;
import jeeves.server.UserSession;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceAlreadyExistException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.exception.WebApplicationException;
import org.fao.geonet.api.pages.PageProperties;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.page.Page;
import org.fao.geonet.domain.page.PageIdentity;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.page.PageRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.utils.EmailUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/{portal}/api/pages"})
@Tag(name="pages", description="Static pages inside GeoNetwork")
@Controller(value="pages")
public class PagesAPI {
    private static final String PAGE_OK = "Page found";
    private static final String PAGE_NOT_FOUND = "Page not found";
    private static final String PAGE_DUPLICATE = "Page already in the system: use PUT";
    private static final String PAGE_SAVED = "Page saved";
    private static final String PAGE_UPDATED = "Page changes saved";
    private static final String PAGE_DELETED = "Page removed";
    private static final String ERROR_FILE = "File not valid";
    private static final String ERROR_CREATE = "Wrong parameters are provided";
    private final PageRepository pageRepository;
    private final GroupRepository groupRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    private final LanguageUtils languageUtils;

    public PagesAPI(PageRepository pageRepository, GroupRepository groupRepository, LanguageUtils languageUtils) {
        this.pageRepository = pageRepository;
        this.groupRepository = groupRepository;
        this.languageUtils = languageUtils;
    }

    private static void setDefaultLink(Page page) {
        page.setLink("../api/pages/" + page.getPageIdentity().getLanguage() + "/" + page.getPageIdentity().getLinkText() + "/content");
    }

    @Operation(summary="Add a page", description="<p>Is not possible to load a link and a file at the same time.</p> <a href='https://geonetwork-opensource.org/manuals/4.0.x/en/customizing-application/adding-static-pages.html'>More info</a>")
    @PutMapping(consumes={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page saved"), @ApiResponse(responseCode="400", description="Wrong parameters are provided"), @ApiResponse(responseCode="409", description="Page already in the system: use PUT"), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource."), @ApiResponse(responseCode="500", description="File not valid")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseBody
    public ResponseEntity<String> addPageWithoutUploadingFile(@RequestBody PageProperties pageProperties) throws ResourceAlreadyExistException {
        return this.createPage(pageProperties, null);
    }

    @Operation(summary="Add a page by uploading a file", description="<p>Is not possible to load a link and a file at the same time.</p> <a href='https://geonetwork-opensource.org/manuals/4.0.x/en/customizing-application/adding-static-pages.html'>More info</a>")
    @PostMapping(consumes={"multipart/form-data"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page saved"), @ApiResponse(responseCode="400", description="Wrong parameters are provided"), @ApiResponse(responseCode="409", description="Page already in the system: use PUT"), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource."), @ApiResponse(responseCode="500", description="File not valid")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseBody
    public ResponseEntity<String> addPageUploadingFile(@RequestParam(value="language", required=true) String language, @RequestParam(value="pageId", required=true) String pageId, @RequestParam(value="sections", required=false) List<Page.PageSection> sections, @RequestParam(value="status", required=false) Page.PageStatus status, @RequestParam(value="data", required=true) MultipartFile data, @RequestParam(value="format", required=false) Page.PageFormat format) throws ResourceAlreadyExistException {
        PageProperties page = new PageProperties();
        page.setPageId(pageId);
        page.setLanguage(language);
        page.setFormat(format);
        page.setStatus(status);
        page.setSections(sections);
        return this.createPage(page, data);
    }

    private ResponseEntity<String> createPage(PageProperties pageProperties, MultipartFile data) throws ResourceAlreadyExistException {
        String link = pageProperties.getLink();
        String content = pageProperties.getContent();
        List<Page.PageSection> section = pageProperties.getSections();
        Page.PageStatus status = pageProperties.getStatus();
        String language = pageProperties.getLanguage();
        String pageId = pageProperties.getPageId();
        Page.PageFormat format = pageProperties.getFormat();
        List<String> groups = pageProperties.getGroups();
        if (language != null) {
            this.checkValidLanguage(language);
        }
        if (!StringUtils.isBlank((String)link)) {
            format = EmailUtil.isValidEmailAddress((String)link) ? Page.PageFormat.EMAILLINK : Page.PageFormat.LINK;
        }
        this.checkMandatoryContent(data, link, content);
        this.checkUniqueContent(data, link, content);
        this.checkCorrectFormat(data, format);
        Optional page = this.pageRepository.findById((Object)new PageIdentity(language, pageId));
        if (!page.isPresent()) {
            Page newPage = this.getEmptyHiddenDraftPage(pageProperties.getLanguage(), pageProperties.getPageId(), pageProperties.getLabel(), format);
            this.fillContent(data, link, content, newPage);
            if (section != null) {
                newPage.setSections(section);
            }
            if (status != null) {
                newPage.setStatus(status);
                if (status == Page.PageStatus.GROUPS && CollectionUtils.isNotEmpty(groups)) {
                    LinkedHashSet<Group> pageGroups = new LinkedHashSet<Group>();
                    for (String groupName : groups) {
                        Group group = this.groupRepository.findByName(groupName);
                        pageGroups.add(group);
                    }
                    newPage.setGroups(pageGroups);
                }
            }
            this.pageRepository.save((Object)newPage);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)"{}");
        }
        throw new ResourceAlreadyExistException();
    }

    private ResponseEntity<Void> updatePageInternal(@NotNull String language, String pageId, PageProperties pageProperties) throws ResourceNotFoundException, ResourceAlreadyExistException {
        boolean isChangingKey;
        String link = pageProperties.getLink();
        String content = pageProperties.getContent();
        String newLanguage = pageProperties.getLanguage();
        String newPageId = pageProperties.getPageId();
        Page.PageFormat format = pageProperties.getFormat();
        String newLabel = pageProperties.getLabel();
        LinkedHashSet<Group> _groups = new LinkedHashSet<Group>();
        if (CollectionUtils.isNotEmpty(pageProperties.getGroups())) {
            for (String groupName : pageProperties.getGroups()) {
                Group group = this.groupRepository.findByName(groupName);
                Group groupToAdd = new Group();
                groupToAdd.setId(group.getId());
                groupToAdd.setAllowedCategories(group.getAllowedCategories());
                groupToAdd.setDescription(group.getDescription());
                groupToAdd.setEmail(group.getEmail());
                groupToAdd.setLogo(group.getLogo());
                groupToAdd.setEnableAllowedCategories(group.getEnableAllowedCategories());
                groupToAdd.setDefaultCategory(group.getDefaultCategory());
                groupToAdd.setName(group.getName());
                groupToAdd.setReferrer(group.getReferrer());
                groupToAdd.setWebsite(group.getWebsite());
                groupToAdd.setLabelTranslations(group.getLabelTranslations());
                _groups.add(groupToAdd);
            }
        }
        this.checkValidLanguage(language);
        if (newLanguage != null) {
            this.checkValidLanguage(newLanguage);
        }
        this.checkMandatoryContent(null, link, content);
        this.checkUniqueContent(null, link, content);
        this.checkCorrectFormat(null, format);
        Optional page = this.pageRepository.findById((Object)new PageIdentity(language, pageId));
        if (!page.isPresent()) {
            throw new ResourceNotFoundException("Can't update non existing page " + pageId + ".");
        }
        Page pageToUpdate = (Page)page.get();
        String updatedLanguage = StringUtils.isBlank((String)newLanguage) ? language : newLanguage;
        String updatedPageId = StringUtils.isBlank((String)newPageId) ? pageId : newPageId;
        boolean bl = isChangingKey = !updatedLanguage.equals(language) && !updatedPageId.equals(pageId);
        if (isChangingKey) {
            this.checkValidLanguage(updatedLanguage);
            Optional newPage = this.pageRepository.findById((Object)new PageIdentity(updatedLanguage, updatedPageId));
            if (newPage.isPresent()) {
                throw new ResourceAlreadyExistException();
            }
            PageIdentity newId = new PageIdentity(updatedLanguage, updatedPageId);
            Page pageCopy = new Page(newId, pageToUpdate.getData(), link != null ? link : pageToUpdate.getLink(), format != null ? format : pageToUpdate.getFormat(), pageProperties.getSections() != null ? pageProperties.getSections() : pageToUpdate.getSections(), pageProperties.getStatus() != null ? pageProperties.getStatus() : pageToUpdate.getStatus(), newLabel != null ? newLabel : pageToUpdate.getLabel(), CollectionUtils.isNotEmpty(_groups) ? _groups : null);
            this.pageRepository.save((Object)pageCopy);
            this.pageRepository.delete((Object)pageToUpdate);
        } else {
            pageToUpdate.setFormat(format != null ? format : pageToUpdate.getFormat());
            this.fillContent(null, link, content, pageToUpdate);
            pageToUpdate.setSections(pageProperties.getSections() != null ? pageProperties.getSections() : pageToUpdate.getSections());
            pageToUpdate.setStatus(pageProperties.getStatus() != null ? pageProperties.getStatus() : pageToUpdate.getStatus());
            pageToUpdate.setLabel(newLabel);
            pageToUpdate.getGroups().clear();
            if (pageToUpdate.getStatus() == Page.PageStatus.GROUPS) {
                pageToUpdate.getGroups().addAll(_groups);
            }
            this.pageRepository.save((Object)pageToUpdate);
        }
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Update a page", description="<a href='https://geonetwork-opensource.org/manuals/4.0.x/en/customizing-application/adding-static-pages.html'>More info</a>")
    @PutMapping(value={"/{language}/{pageId}"}, consumes={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page changes saved"), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseEntity<Void> updatePage(@PathVariable(value="language") String language, @PathVariable(value="pageId") String pageId, @RequestBody PageProperties pageProperties) throws ResourceNotFoundException, ResourceAlreadyExistException {
        return this.updatePageInternal(language, pageId, pageProperties);
    }

    @Operation(summary="Delete a page", description="<a href='https://geonetwork-opensource.org/manuals/4.0.x/en/customizing-application/adding-static-pages.html'>More info</a>")
    @DeleteMapping(value={"/{language}/{pageId}"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page removed"), @ApiResponse(responseCode="404", description="Page not found"), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseBody
    public void deletePage(@PathVariable(value="language") String language, @PathVariable(value="pageId") String pageId) throws ResourceNotFoundException {
        this.searchPage(language, pageId, this.pageRepository);
        this.pageRepository.deleteById((Object)new PageIdentity(language, pageId));
    }

    @Operation(summary="Return the page object details except the content", description="<a href='https://geonetwork-opensource.org/manuals/4.0.x/en/customizing-application/adding-static-pages.html'>More info</a>")
    @GetMapping(value={"/{language}/{pageId}"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page found"), @ApiResponse(responseCode="404", description="Page not found"), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public ResponseEntity<PageProperties> getPage(@PathVariable(value="language") String language, @PathVariable(value="pageId") String pageId, @Parameter(hidden=true) HttpSession session) throws ResourceNotFoundException {
        Page page = this.searchPage(language, pageId, this.pageRepository);
        return this.checkPermissionsOnSinglePageAndReturn(session, page);
    }

    @Operation(summary="Return the static html content identified by pageId", description="<a href='https://geonetwork-opensource.org/manuals/4.0.x/en/customizing-application/adding-static-pages.html'>More info</a>")
    @GetMapping(value={"/{language}/{pageId}/content"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page found"), @ApiResponse(responseCode="404", description="Page not found"), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public ResponseEntity<String> getPageContent(@PathVariable(value="language") String language, @PathVariable(value="pageId") String pageId, @Parameter(hidden=true) HttpSession session, @Parameter(hidden=true) HttpServletResponse response) {
        Optional page = this.pageRepository.findById((Object)new PageIdentity(language, pageId));
        if (!page.isPresent()) {
            return ResponseEntity.notFound().build();
        }
        UserSession us = ApiUtils.getUserSession(session);
        if (((Page)page.get()).getStatus().equals((Object)Page.PageStatus.HIDDEN) && us.getProfile() != Profile.Administrator) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).build();
        }
        if ((((Page)page.get()).getStatus().equals((Object)Page.PageStatus.PRIVATE) || ((Page)page.get()).getStatus().equals((Object)Page.PageStatus.GROUPS)) && (us.getProfile() == null || us.getProfile() == Profile.Guest)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).build();
        }
        String content = ((Page)page.get()).getData() != null && ((Page)page.get()).getData().length > 0 ? new String(((Page)page.get()).getData(), StandardCharsets.UTF_8) : ((Page)page.get()).getLink();
        response.setHeader("Content-Type", (((Page)page.get()).getFormat().equals((Object)Page.PageFormat.HTML) || ((Page)page.get()).getFormat().equals((Object)Page.PageFormat.HTMLPAGE) ? "text/html" : "text/plain") + "; charset=utf-8");
        return new ResponseEntity((Object)content, HttpStatus.OK);
    }

    @Operation(summary="List all pages according to the filters", description="<a href='https://geonetwork-opensource.org/manuals/4.0.x/en/customizing-application/adding-static-pages.html'>More info</a>")
    @GetMapping
    @ApiResponses(value={@ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public ResponseEntity<List<PageProperties>> listPages(@RequestParam(value="language", required=false) String language, @RequestParam(value="section", required=false) Page.PageSection section, @RequestParam(value="format", required=false) Page.PageFormat format, @Parameter(hidden=true) HttpSession session) {
        UserSession us = ApiUtils.getUserSession(session);
        List unfilteredResult = language == null ? this.pageRepository.findAll() : this.pageRepository.findByPageIdentityLanguage(language);
        ArrayList<PageProperties> filteredResult = new ArrayList<PageProperties>();
        for (Page page : unfilteredResult) {
            if (!(page.getStatus().equals((Object)Page.PageStatus.HIDDEN) && us.getProfile() == Profile.Administrator || page.getStatus().equals((Object)Page.PageStatus.PRIVATE) && us.getProfile() != null && us.getProfile() != Profile.Guest || page.getStatus().equals((Object)Page.PageStatus.GROUPS) && us.getProfile() != null && us.getProfile() != Profile.Guest && this.checkGroupPermission(us, page) || page.getStatus().equals((Object)Page.PageStatus.PUBLIC)) && (!page.getStatus().equals((Object)Page.PageStatus.PUBLIC_ONLY) || us.isAuthenticated())) continue;
            if (section == null) {
                filteredResult.add(new PageProperties(page));
                continue;
            }
            List sections = page.getSections();
            boolean containsRequestedSection = sections.contains(section);
            if (!containsRequestedSection) continue;
            filteredResult.add(new PageProperties(page));
        }
        return new ResponseEntity(filteredResult, HttpStatus.OK);
    }

    @GetMapping(value={"/config/formats"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page found")})
    @ResponseBody
    public Page.PageFormat[] getPageFormats() {
        return Page.PageFormat.values();
    }

    @GetMapping(value={"/config/sections"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page found")})
    @ResponseBody
    public Page.PageSection[] getPageSections() {
        return Page.PageSection.values();
    }

    @GetMapping(value={"/config/status"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page found")})
    @ResponseBody
    public Page.PageStatus[] getPageStatus() {
        return Page.PageStatus.values();
    }

    private void checkCorrectFormat(MultipartFile data, Page.PageFormat format) {
        if ((Page.PageFormat.LINK.equals((Object)format) || Page.PageFormat.EMAILLINK.equals((Object)format)) && data != null && !data.isEmpty()) {
            throw new IllegalArgumentException("Wrong format. Cannot set format to LINK or EMAILLINK and upload a file.");
        }
    }

    private void checkMandatoryContent(MultipartFile data, String link, String content) {
        if (StringUtils.isBlank((String)link) && (data == null || data.isEmpty()) && StringUtils.isEmpty((String)content)) {
            throw new IllegalArgumentException("A content associated to the page is required, Use a link, a file or text content.");
        }
    }

    private void checkUniqueContent(MultipartFile data, String link, String content) {
        int options = 0;
        if (StringUtils.isNotBlank((String)link) && StringUtils.isEmpty((String)content)) {
            ++options;
        }
        if (data != null && !data.isEmpty()) {
            ++options;
        }
        if (StringUtils.isNotEmpty((String)content)) {
            ++options;
        }
        if (options > 1) {
            throw new IllegalArgumentException("Either add page content using a link, a file or text content.");
        }
    }

    private void checkFileType(MultipartFile data) {
        if (data != null) {
            String extension = StringUtils.defaultIfBlank((String)FilenameUtils.getExtension((String)data.getOriginalFilename()), (String)"");
            if (Arrays.stream(Page.PageExtension.values()).noneMatch(t -> t.name().equals(extension.toUpperCase()))) {
                throw new MultipartException(String.format("Unsupported file type (only %s are allowed).", Arrays.toString(Page.PageExtension.values())));
            }
        }
    }

    private void checkValidLanguage(String language) {
        if (!this.languageUtils.getUiLanguages().contains(language)) {
            throw new IllegalArgumentException(String.format("Language value is not valid: %s. A valid application language is mandatory: %s.", language, String.join((CharSequence)",", this.languageUtils.getUiLanguages())));
        }
    }

    private ResponseEntity<PageProperties> checkPermissionsOnSinglePageAndReturn(HttpSession session, Page page) {
        if (page == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        UserSession us = ApiUtils.getUserSession(session);
        if (page.getStatus().equals((Object)Page.PageStatus.HIDDEN) && us.getProfile() != Profile.Administrator) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        if ((page.getStatus().equals((Object)Page.PageStatus.PRIVATE) || page.getStatus().equals((Object)Page.PageStatus.GROUPS)) && (us.getProfile() == null || us.getProfile() == Profile.Guest)) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity((Object)new PageProperties(page), HttpStatus.OK);
    }

    private Page searchPage(String language, String pageId, PageRepository pageRepository) throws ResourceNotFoundException {
        Optional page = pageRepository.findById((Object)new PageIdentity(language, pageId));
        if (!page.isPresent()) {
            throw new ResourceNotFoundException("Page " + pageId + " not found");
        }
        return (Page)page.get();
    }

    protected Page getEmptyHiddenDraftPage(String language, String pageId, String label, Page.PageFormat format) {
        ArrayList sections = new ArrayList();
        return new Page(new PageIdentity(language, pageId), null, null, format, sections, Page.PageStatus.HIDDEN, label, null);
    }

    private void fillContent(MultipartFile data, String link, String content, Page page) {
        if (data != null && !data.isEmpty()) {
            byte[] bytesData;
            this.checkFileType(data);
            try {
                bytesData = data.getBytes();
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
            page.setData(bytesData);
            PagesAPI.setDefaultLink(page);
        } else if (StringUtils.isNotEmpty((String)content)) {
            PagesAPI.setDefaultLink(page);
            page.setData(content.getBytes());
        } else if (page.getData() == null) {
            if (page.getFormat() == Page.PageFormat.LINK) {
                if (StringUtils.isNotBlank((String)link) && !UrlUtils.isValidRedirectUrl((String)link)) {
                    throw new IllegalArgumentException("The link provided is not valid");
                }
                page.setLink(link);
            } else if (page.getFormat() == Page.PageFormat.EMAILLINK) {
                if (StringUtils.isNotBlank((String)link) && !EmailUtil.isValidEmailAddress((String)link)) {
                    throw new IllegalArgumentException("The link provided is not valid");
                }
                page.setLink(link);
            }
        }
    }

    private boolean checkGroupPermission(UserSession us, Page page) {
        boolean isGranted = false;
        String currentUserId = us.getUserId();
        if (us.getProfile() == Profile.Administrator) {
            isGranted = true;
        } else if (page.getStatus().equals((Object)Page.PageStatus.GROUPS) && StringUtils.isNotEmpty((String)currentUserId)) {
            List userGroups = this.userGroupRepository.findAll(UserGroupSpecs.hasUserId((int)Integer.parseInt(currentUserId)));
            Set accessingGroups = page.getGroups();
            if (CollectionUtils.isNotEmpty((Collection)userGroups) && CollectionUtils.isNotEmpty((Collection)accessingGroups)) {
                block0: for (UserGroup userGroup : userGroups) {
                    for (Group group : accessingGroups) {
                        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)userGroup.getGroup().getName(), (CharSequence)group.getName())) continue;
                        isGranted = true;
                        continue block0;
                    }
                }
            }
        }
        return isGranted;
    }
}

