/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.languages;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.Language;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.lib.DbLib;
import org.fao.geonet.repository.LanguageRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/{portal}/api/languages"})
@Tag(name="languages", description="Languages operations")
@RestController
public class LanguagesApi {
    @Autowired
    private LanguageRepository languageRepository;
    @Autowired
    private GeonetworkDataDirectory dataDirectory;
    private String defaultLanguage;

    @Resource(name="defaultLanguage")
    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    @Operation(summary="Get languages available in the application", description="Languages available in this version of the application. Those that you can add using PUT operation and which have SQL script to initialize the language.")
    @RequestMapping(value={"/application"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseBody
    public List<Language> getApplicationLanguages() throws Exception {
        Set applicationLanguages = (Set)ApplicationContextHolder.get().getBean("languages");
        List<Language> list = applicationLanguages.stream().map(l -> {
            Language language = new Language();
            language.setId(l);
            return language;
        }).collect(Collectors.toList());
        return list;
    }

    @Operation(summary="Get languages", description="Languages for the application having translations in the database. All tables with 'Desc' suffix contains translation for some domain objects like groups, tags, ...")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<Language> getLanguages() throws Exception {
        return this.languageRepository.findAll();
    }

    @Operation(summary="Add a language", description="Add all default translations from all *Desc tables in the database. This operation will only add translations for a default catalog installation. Defaults can be customized in SQL scripts located in WEB-INF/classes/setup/sql/data/*.")
    @RequestMapping(value={"/{langCode}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Language translations added."), @ApiResponse(responseCode="404", description="Resource not found. eg. No SQL file available for that langugae."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrator can access it.")})
    public void addLanguages(@Parameter(description="ISO 3 letter code", required=true) @PathVariable String langCode, @Parameter(hidden=true) HttpServletRequest request) throws IOException, ResourceNotFoundException {
        Optional lang = this.languageRepository.findById((Object)langCode);
        if (!lang.isPresent()) {
            String languageDataFile = "loc-" + langCode + "-default.sql";
            Path templateFile = this.dataDirectory.getWebappDir().resolve("WEB-INF").resolve("classes").resolve("setup").resolve("sql").resolve("data").resolve(languageDataFile);
            if (Files.exists(templateFile, new LinkOption[0])) {
                ArrayList<String> data = new ArrayList<String>();
                try (BufferedReader br = new BufferedReader(new FileReader(templateFile.toFile()));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        data.add(line);
                    }
                }
                if (data.size() > 0) {
                    ServiceContext context = ApiUtils.createServiceContext(request);
                    DbLib.runSQL((ServiceContext)context, data);
                    return;
                }
            }
            throw new ResourceNotFoundException(String.format("Language data file '%s' not found in classes/setup/sql/data.", languageDataFile));
        }
        throw new RuntimeException(String.format("Language '%s' already available.", ((Language)lang.get()).getId()));
    }

    @Operation(summary="Remove a language", description="Delete all translations from all *Desc tables in the database. Warning: This will also remove all translations you may have done to those objects (eg. custom groups).")
    @RequestMapping(value={"/{langCode}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Language translations removed."), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrator can access it.")})
    public void deleteLanguage(@Parameter(description="ISO 3 letter code", required=true) @PathVariable String langCode, HttpServletRequest request) throws IOException, ResourceNotFoundException {
        Optional lang = this.languageRepository.findById((Object)langCode);
        if (!lang.isPresent()) {
            throw new ResourceNotFoundException(String.format("Language '%s' not found.", langCode));
        }
        long count = this.languageRepository.count();
        if (count == 1L) {
            throw new NotAllowedException(String.format("You can't delete the last language. Add another one before removing %s.", langCode));
        }
        String LANGUAGE_DELETE_SQL = "language-delete.sql";
        Path templateFile = this.dataDirectory.getWebappDir().resolve("WEB-INF").resolve("classes").resolve("setup").resolve("sql").resolve("template").resolve("language-delete.sql");
        if (Files.exists(templateFile, new LinkOption[0])) {
            ArrayList<String> data = new ArrayList<String>();
            try (BufferedReader br = new BufferedReader(new FileReader(templateFile.toFile()));){
                String line;
                while ((line = br.readLine()) != null) {
                    data.add(String.format(line, ((Language)lang.get()).getId()));
                }
            }
            if (data.size() > 0) {
                ServiceContext context = ApiUtils.createServiceContext(request);
                DbLib.runSQL((ServiceContext)context, data);
                return;
            }
        }
        throw new ResourceNotFoundException(String.format("Template file '%s' not found in classes/setup/sql/template.", "language-delete.sql"));
    }
}

