/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.io.File;
import org.apache.log4j.bridge.AppenderWrapper;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.fao.geonet.Logger;

public final class Log {
    public static final String JEEVES = "jeeves";
    public static final String ENGINE = "jeeves.engine";
    public static final String MONITOR = "jeeves.monitor";
    public static final String APPHAND = "jeeves.apphand";
    public static final String WEBAPP = "jeeves.webapp";
    public static final String REQUEST = "jeeves.request";
    public static final String SERVICE = "jeeves.service";
    public static final String SCHEDULER = "jeeves.scheduler";
    public static final String RESOURCES = "jeeves.resources";
    public static final String XLINK_PROCESSOR = "jeeves.xlinkprocessor";
    public static final String XML_RESOLVER = "jeeves.xmlresolver";
    public static final String TRANSFORMER_FACTORY = "jeeves.transformerFactory";
    public static final String GEONETWORK_MODULE = "geonetwork";
    public static final String LOG_DIR_KEY = "log_dir";
    private static final String FILE_APPENDER_NAME = "File";

    private Log() {
    }

    public static void debug(String module, Object message) {
        LogManager.getLogger((String)module).debug(message);
    }

    public static void debug(String module, String message, Object ... objects) {
        LogManager.getLogger((String)module).debug(message, objects);
    }

    public static void debug(String module, String message, Throwable throwable) {
        LogManager.getLogger((String)module).debug(message, throwable);
    }

    public static boolean isDebugEnabled(String module) {
        return LogManager.getLogger((String)module).isDebugEnabled();
    }

    public static boolean isEnabledFor(String module, Level level) {
        return LogManager.getLogger((String)module).isEnabled(level);
    }

    public static void trace(String module, Object message) {
        LogManager.getLogger((String)module).trace(message);
    }

    public static void trace(String module, Object message, Exception e) {
        LogManager.getLogger((String)module).trace(message, (Throwable)e);
    }

    public static boolean isTraceEnabled(String module) {
        return LogManager.getLogger((String)module).isTraceEnabled();
    }

    public static void info(String module, Object message) {
        LogManager.getLogger((String)module).info(message);
    }

    public static void info(String module, String message, Object ... objects) {
        LogManager.getLogger((String)module).info(message, objects);
    }

    public static void info(String module, String message, Throwable throwable) {
        LogManager.getLogger((String)module).info(message, throwable);
    }

    public static void warning(String module, Object message) {
        LogManager.getLogger((String)module).warn(message);
    }

    public static void warning(String module, Object message, Throwable e) {
        LogManager.getLogger((String)module).warn(message, e);
    }

    public static void error(String module, Object message) {
        LogManager.getLogger((String)module).error(message);
    }

    public static void error(String module, Object message, Throwable t) {
        LogManager.getLogger((String)module).error(message, t);
    }

    public static void error(String module, String message, Object ... objects) {
        LogManager.getLogger((String)module).error(message, objects);
    }

    public static void error(String module, String message, Throwable throwable) {
        LogManager.getLogger((String)module).error(message, throwable);
    }

    public static void fatal(String module, Object message) {
        LogManager.getLogger((String)module).fatal(message);
    }

    public static Logger createLogger(String module) {
        return Log.createLogger(module, null);
    }

    public static Logger createLogger(final String module, final String fallbackModule) {
        return new Logger(){

            @Override
            public boolean isDebugEnabled() {
                return Log.isDebugEnabled(module);
            }

            @Override
            public void debug(String message) {
                Log.debug(module, message);
            }

            @Override
            public void debug(String message, Throwable throwable) {
                Log.debug(module, message, throwable);
            }

            @Override
            public void debug(String message, Object ... object) {
                Log.debug(module, message, object);
            }

            @Override
            public void info(String message) {
                Log.info(module, message);
            }

            @Override
            public void info(String message, Throwable throwable) {
                Log.info(module, message, throwable);
            }

            @Override
            public void info(String message, Object ... object) {
                Log.info(module, message, object);
            }

            @Override
            public void warning(String message) {
                Log.warning(module, message);
            }

            @Override
            public void warning(String message, Throwable throwable) {
                Log.warning(module, message, throwable);
            }

            @Override
            public void warning(String message, Object ... object) {
            }

            @Override
            public void error(String message) {
                Log.error(module, message);
            }

            @Override
            public void error(String message, Throwable throwable) {
                Log.error(module, message, throwable);
            }

            @Override
            public void error(String message, Object ... object) {
                Log.error(module, message, object);
            }

            @Override
            public void fatal(String message) {
                Log.fatal(module, message);
            }

            @Override
            public void error(Throwable t) {
                Log.error(module, t.getMessage(), t);
            }

            @Override
            public void setAppender(FileAppender fa) {
                throw new IllegalStateException("Please use custom log4j2.xml to manage log4j behavior");
            }

            @Override
            public String getFileAppender() {
                LoggerConfig fallbackConfig;
                org.apache.logging.log4j.Logger log = LogManager.getLogger((String)module);
                Configurator.setLevel((org.apache.logging.log4j.Logger)log, (Level)this.getThreshold());
                LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
                Configuration configuration = loggerContext.getConfiguration();
                LoggerConfig moduleConfig = (LoggerConfig)configuration.getLoggers().get(module);
                if (moduleConfig != null) {
                    for (Object appender : moduleConfig.getAppenders().values()) {
                        File file = Log.toLogFile((Appender)appender);
                        if (file == null || !file.exists()) continue;
                        return file.getName();
                    }
                }
                if ((fallbackConfig = (LoggerConfig)configuration.getLoggers().get(fallbackModule)) != null) {
                    for (Appender appender : fallbackConfig.getAppenders().values()) {
                        File file = Log.toLogFile(appender);
                        if (file == null || !file.exists()) continue;
                        return file.getName();
                    }
                }
                if (System.getProperties().containsKey(Log.LOG_DIR_KEY)) {
                    File logFile;
                    File logDir = new File(System.getProperty(Log.LOG_DIR_KEY));
                    if (logDir.exists() && logDir.isDirectory() && (logFile = new File(logDir, "geonetwork.log")).exists()) {
                        return logFile.getName();
                    }
                } else {
                    File logFile = new File("logs/geonetwork.log");
                    if (logFile.exists()) {
                        return logFile.getName();
                    }
                }
                return "";
            }

            @Override
            public Level getThreshold() {
                return LogManager.getLogger((String)fallbackModule).getLevel();
            }

            @Override
            public String getModule() {
                return module;
            }
        };
    }

    public static File toLogFile(Appender appender) {
        FileAppender fileAppender;
        String fileName;
        File file;
        if (appender instanceof FileAppender && (file = new File(fileName = (fileAppender = (FileAppender)appender).getFileName())).exists()) {
            return file;
        }
        if (appender instanceof RollingFileAppender && (file = new File(fileName = (fileAppender = (RollingFileAppender)appender).getFileName())).exists()) {
            return file;
        }
        return null;
    }

    public static File getLogfile() {
        org.apache.log4j.Appender appender = org.apache.log4j.Logger.getLogger((String)GEONETWORK_MODULE).getAppender(FILE_APPENDER_NAME);
        if (appender == null) {
            appender = org.apache.log4j.Logger.getLogger((String)JEEVES).getAppender(FILE_APPENDER_NAME);
        }
        if (appender != null && appender instanceof AppenderWrapper) {
            File logFile;
            FileAppender fileAppender;
            String logFileName;
            AppenderWrapper wrapper = (AppenderWrapper)appender;
            Appender appender2 = wrapper.getAppender();
            if (appender2 instanceof FileAppender && (logFileName = (fileAppender = (FileAppender)appender2).getFileName()) != null && (logFile = new File(logFileName)).exists()) {
                return logFile;
            }
            if (appender2 instanceof RollingFileAppender && (logFileName = (fileAppender = (RollingFileAppender)appender2).getFileName()) != null && (logFile = new File(logFileName)).exists()) {
                return logFile;
            }
        }
        Log.warning(GEONETWORK_MODULE, "Error when getting logger file for the appender named 'File'. Check your log configuration file. A FileAppender or RollingFileAppender is required to return last activity to the user interface.Appender file not found.");
        if (System.getProperties().containsKey(LOG_DIR_KEY)) {
            File logFile;
            File logDir = new File(System.getProperty(LOG_DIR_KEY));
            if (logDir.exists() && logDir.isDirectory() && (logFile = new File(logDir, "geonetwork.log")).exists()) {
                return logFile;
            }
        } else {
            File logFile = new File("logs/geonetwork.log");
            if (logFile.exists()) {
                return logFile;
            }
        }
        return null;
    }
}

