/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.translations.googletranslate;

import com.google.common.base.Function;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.translations.googletranslate.GoogleTranslateClientException;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.springframework.http.client.ClientHttpResponse;

public class GoogleTranslateClient {
    private static final String LOGGER_NAME = "geonetwork.translate";
    private String serviceUrl;
    private String apiKey;
    private GeonetHttpRequestFactory requestFactory;

    public GoogleTranslateClient(String serviceUrl, String apiKey) {
        this.serviceUrl = serviceUrl;
        this.apiKey = apiKey;
        this.requestFactory = (GeonetHttpRequestFactory)ApplicationContextHolder.get().getBean(GeonetHttpRequestFactory.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String translate(String text, String fromLanguage, String toLanguage) throws GoogleTranslateClientException {
        String urlStr;
        try {
            urlStr = this.serviceUrl + "?q=" + URLEncoder.encode(text, String.valueOf(StandardCharsets.UTF_8)) + "&target=" + toLanguage + "&source=" + fromLanguage;
        }
        catch (UnsupportedEncodingException ex) {
            Log.error((String)LOGGER_NAME, (String)("   -- Error (exception): " + ex.getMessage()), (Throwable)ex);
            throw new GoogleTranslateClientException(ex.getMessage(), ex);
        }
        HttpGet method = new HttpGet(urlStr);
        method.addHeader((Header)new BasicHeader("User-Agent", "Mozilla/5.0"));
        try (ClientHttpResponse httpResponse = this.executeRequest((HttpUriRequest)method);){
            int status = httpResponse.getRawStatusCode();
            Log.debug((String)LOGGER_NAME, (Object)("   -- Request status code: " + status));
            String responseBody = CharStreams.toString((Readable)new InputStreamReader(httpResponse.getBody()));
            if (status != 200) {
                String message = String.format("Failed to create translate text '%s' from '%s' to '%s'. Status is %d. Error is %s. Response body: %s", text, fromLanguage, toLanguage, status, httpResponse.getStatusText(), responseBody);
                Log.info((String)LOGGER_NAME, (Object)message);
                throw new GoogleTranslateClientException(message);
            }
            String string = responseBody;
            return string;
        }
        catch (GoogleTranslateClientException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Log.error((String)LOGGER_NAME, (String)("   -- Error (exception): " + ex.getMessage()), (Throwable)ex);
            throw new GoogleTranslateClientException(ex.getMessage(), ex);
        }
    }

    protected ClientHttpResponse executeRequest(HttpUriRequest method) throws IOException {
        final String requestHost = method.getURI().getHost();
        Function<HttpClientBuilder, Void> requestConfiguration = new Function<HttpClientBuilder, Void>(){

            @Nullable
            public Void apply(@Nonnull HttpClientBuilder input) {
                Lib.net.setupProxy((SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class), input, requestHost);
                input.useSystemProperties();
                return null;
            }
        };
        return this.requestFactory.execute(method, (Function)requestConfiguration);
    }
}

