/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import java.util.List;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.OpModifier;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpOrder
extends OpModifier {
    private List<SortCondition> conditions;

    public OpOrder(Op subOp, List<SortCondition> conditions) {
        super(subOp);
        this.conditions = conditions;
    }

    public List<SortCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public String getName() {
        return "order";
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op1 copy(Op subOp) {
        return new OpOrder(subOp, this.conditions);
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public int hashCode() {
        return this.conditions.hashCode() ^ this.getSubOp().hashCode();
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpOrder)) {
            return false;
        }
        OpOrder opOrder = (OpOrder)other;
        if (!opOrder.getConditions().equals(this.getConditions())) {
            return false;
        }
        return this.getSubOp().equalTo(opOrder.getSubOp(), labelMap);
    }
}

