/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Map;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapExtended;
import org.apache.jena.riot.system.PrefixMapNull;
import org.apache.jena.riot.system.PrefixMapStd;
import org.apache.jena.riot.system.PrefixMapUnmodifiable;
import org.apache.jena.shared.PrefixMapping;

public class PrefixMapFactory {
    public static PrefixMap create() {
        return new PrefixMapStd();
    }

    public static PrefixMap create(PrefixMap pmap) {
        return new PrefixMapStd(pmap);
    }

    public static PrefixMap create(PrefixMapping pmap) {
        PrefixMap created = PrefixMapFactory.create();
        created.putAll(pmap);
        return created;
    }

    public static PrefixMap create(Map<String, String> pmap) {
        PrefixMap created = PrefixMapFactory.create();
        created.putAll(pmap);
        return created;
    }

    public static PrefixMap createForInput() {
        return new PrefixMapStd();
    }

    public static PrefixMap createForInput(PrefixMap pmap) {
        return new PrefixMapStd(pmap);
    }

    public static PrefixMap createForInput(PrefixMapping pmap) {
        PrefixMap created = PrefixMapFactory.createForInput();
        created.putAll(pmap);
        return created;
    }

    public static PrefixMap createForInput(Map<String, String> pmap) {
        PrefixMap created = PrefixMapFactory.createForInput();
        created.putAll(pmap);
        return created;
    }

    public static PrefixMap createForOutput() {
        return new PrefixMapStd();
    }

    public static PrefixMap createForOutput(PrefixMap pmap) {
        return new PrefixMapStd(pmap);
    }

    public static PrefixMap createForOutput(PrefixMapping pmap) {
        PrefixMap created = PrefixMapFactory.createForOutput();
        created.putAll(pmap);
        return created;
    }

    public static PrefixMap createForOutput(Map<String, String> pmap) {
        PrefixMap created = PrefixMapFactory.createForOutput();
        created.putAll(pmap);
        return created;
    }

    public static PrefixMap extend(PrefixMap pmap) {
        return new PrefixMapExtended(pmap);
    }

    public static PrefixMap unmodifiablePrefixMap(PrefixMap pmap) {
        return new PrefixMapUnmodifiable(pmap);
    }

    public static PrefixMap emptyPrefixMap() {
        return PrefixMapNull.empty;
    }
}

