/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.LongCollection;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.hash.DefaultShortHashFunction;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ShortKeyLongMap;
import bak.pcj.map.ShortKeyLongMapIterator;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractShortKeyLongMap
implements ShortKeyLongMap {
    protected AbstractShortKeyLongMap() {
    }

    public void clear() {
        ShortKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public long remove(short key) {
        ShortKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            long value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultLong();
    }

    public void putAll(ShortKeyLongMap map) {
        ShortKeyLongMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(short key) {
        ShortKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public long get(short key) {
        ShortKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultLong();
    }

    public boolean containsValue(long value) {
        ShortKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShortKeyLongMap)) {
            return false;
        }
        ShortKeyLongMap map = (ShortKeyLongMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        ShortKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            short k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        ShortKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultShortHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultLongHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        ShortKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public long tget(short key) {
        long value = this.get(key);
        if (value == MapDefaults.defaultLong() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        ShortKeyLongMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract LongCollection values();

    public abstract long put(short var1, long var2);

    public abstract long lget();

    public abstract ShortSet keySet();

    public abstract ShortKeyLongMapIterator entries();
}

