/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.list;

import bak.pcj.BooleanCollection;
import bak.pcj.hash.DefaultBooleanHashFunction;
import bak.pcj.list.AbstractBooleanList;
import bak.pcj.list.BooleanList;
import bak.pcj.list.BooleanListIterator;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BooleanArrayList
extends AbstractBooleanList
implements Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 10;
    private transient boolean[] data;
    private int size;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;

    private BooleanArrayList(int capacity, int growthPolicy, double growthFactor, int growthChunk) {
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor < 0.0) {
            Exceptions.negativeArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk < 0) {
            Exceptions.negativeArgument("growthChunk", String.valueOf(growthChunk));
        }
        this.data = new boolean[capacity];
        this.size = 0;
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
    }

    public BooleanArrayList() {
        this(10);
    }

    public BooleanArrayList(BooleanCollection c) {
        this(c.size());
        this.addAll(c);
    }

    public BooleanArrayList(boolean[] a) {
        this(a.length);
        System.arraycopy(a, 0, this.data, 0, a.length);
        this.size = a.length;
    }

    public BooleanArrayList(int capacity) {
        this(capacity, 1.0);
    }

    public BooleanArrayList(int capacity, double growthFactor) {
        this(capacity, 0, growthFactor, 10);
    }

    public BooleanArrayList(int capacity, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk);
    }

    private int computeCapacity(int capacity) {
        int newcapacity = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
        if (newcapacity < capacity) {
            newcapacity = capacity;
        }
        return newcapacity;
    }

    public int ensureCapacity(int capacity) {
        if (capacity > this.data.length) {
            capacity = this.computeCapacity(capacity);
            boolean[] newdata = new boolean[capacity];
            System.arraycopy(this.data, 0, newdata, 0, this.size);
            this.data = newdata;
        }
        return capacity;
    }

    public int capacity() {
        return this.data.length;
    }

    public void add(int index, boolean v) {
        if (index < 0 || index > this.size) {
            Exceptions.indexOutOfBounds(index, 0, this.size);
        }
        this.ensureCapacity(this.size + 1);
        int block = this.size - index;
        if (block > 0) {
            System.arraycopy(this.data, index, this.data, index + 1, block);
        }
        this.data[index] = v;
        ++this.size;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.size) {
            Exceptions.indexOutOfBounds(index, 0, this.size - 1);
        }
        return this.data[index];
    }

    public boolean set(int index, boolean v) {
        if (index < 0 || index >= this.size) {
            Exceptions.indexOutOfBounds(index, 0, this.size - 1);
        }
        boolean result = this.data[index];
        this.data[index] = v;
        return result;
    }

    public boolean removeElementAt(int index) {
        if (index < 0 || index >= this.size) {
            Exceptions.indexOutOfBounds(index, 0, this.size - 1);
        }
        boolean result = this.data[index];
        int block = this.size - (index + 1);
        if (block > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, block);
        }
        --this.size;
        return result;
    }

    public void trimToSize() {
        if (this.data.length > this.size) {
            boolean[] newdata = new boolean[this.size];
            System.arraycopy(this.data, 0, newdata, 0, this.size);
            this.data = newdata;
        }
    }

    public Object clone() {
        try {
            BooleanArrayList c = (BooleanArrayList)super.clone();
            c.data = new boolean[this.data.length];
            System.arraycopy(this.data, 0, c.data, 0, this.size);
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(boolean v) {
        int i = 0;
        while (i < this.size) {
            if (this.data[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int indexOf(boolean c) {
        int i = 0;
        while (i < this.size) {
            if (this.data[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(int index, boolean c) {
        if (index < 0 || index > this.size) {
            Exceptions.indexOutOfBounds(index, 0, this.size);
        }
        int i = index;
        while (i < this.size) {
            if (this.data[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(boolean c) {
        int i = this.size - 1;
        while (i >= 0) {
            if (this.data[i] == c) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public boolean remove(boolean v) {
        int index = this.indexOf(v);
        if (index != -1) {
            this.removeElementAt(index);
            return true;
        }
        return false;
    }

    public boolean[] toArray() {
        boolean[] a = new boolean[this.size];
        System.arraycopy(this.data, 0, a, 0, this.size);
        return a;
    }

    public boolean[] toArray(boolean[] a) {
        if (a == null || a.length < this.size) {
            a = new boolean[this.size];
        }
        System.arraycopy(this.data, 0, a, 0, this.size);
        return a;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanList)) {
            return false;
        }
        int i1 = 0;
        BooleanListIterator i2 = ((BooleanList)obj).listIterator();
        while (i1 < this.size && i2.hasNext()) {
            if (this.data[i1++] == i2.next()) continue;
            return false;
        }
        return i1 >= this.size && !i2.hasNext();
    }

    public int hashCode() {
        int h = 1;
        int i = 0;
        while (i < this.size) {
            h = 31 * h + DefaultBooleanHashFunction.INSTANCE.hash(this.data[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.data.length);
        int i = 0;
        while (i < this.size) {
            s.writeBoolean(this.data[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.data = new boolean[s.readInt()];
        int i = 0;
        while (i < this.size) {
            this.data[i] = s.readBoolean();
            ++i;
        }
    }
}

