/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.list;

import bak.pcj.AbstractByteCollection;
import bak.pcj.ByteCollection;
import bak.pcj.ByteIterator;
import bak.pcj.hash.DefaultByteHashFunction;
import bak.pcj.list.ByteList;
import bak.pcj.list.ByteListIterator;
import bak.pcj.util.Exceptions;

public abstract class AbstractByteList
extends AbstractByteCollection
implements ByteList {
    protected AbstractByteList() {
    }

    public boolean add(byte v) {
        this.add(this.size(), v);
        return true;
    }

    public void add(int index, byte v) {
        Exceptions.unsupported("add");
    }

    public boolean addAll(int index, ByteCollection c) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        ByteIterator i = c.iterator();
        boolean result = i.hasNext();
        while (i.hasNext()) {
            this.add(index, i.next());
            ++index;
        }
        return result;
    }

    public int indexOf(byte c) {
        return this.indexOf(0, c);
    }

    public int indexOf(int index, byte c) {
        ByteListIterator i = this.listIterator(index);
        while (i.hasNext()) {
            if (i.next() != c) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public ByteIterator iterator() {
        return this.listIterator();
    }

    public int lastIndexOf(byte c) {
        ByteListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public int lastIndexOf(int index, byte c) {
        ByteListIterator i = this.listIterator(index);
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public ByteListIterator listIterator() {
        return this.listIterator(0);
    }

    public ByteListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        return new ByteListIterator(index){
            private int ptr;
            private int lptr;
            private final /* synthetic */ int val$index;
            {
                this.ptr = this.val$index = val$index;
                this.lptr = -1;
            }

            public boolean hasNext() {
                return this.ptr < AbstractByteList.this.size();
            }

            public byte next() {
                if (this.ptr == AbstractByteList.this.size()) {
                    Exceptions.endOfIterator();
                }
                this.lptr = this.ptr++;
                return AbstractByteList.this.get(this.lptr);
            }

            public void remove() {
                if (this.lptr == -1) {
                    Exceptions.noElementToRemove();
                }
                AbstractByteList.this.removeElementAt(this.lptr);
                if (this.lptr < this.ptr) {
                    --this.ptr;
                }
                this.lptr = -1;
            }

            public void add(byte v) {
                AbstractByteList.this.add(this.ptr++, v);
                this.lptr = -1;
            }

            public boolean hasPrevious() {
                return this.ptr > 0;
            }

            public int nextIndex() {
                return this.ptr;
            }

            public byte previous() {
                if (this.ptr == 0) {
                    Exceptions.startOfIterator();
                }
                --this.ptr;
                this.lptr = this.ptr;
                return AbstractByteList.this.get(this.ptr);
            }

            public int previousIndex() {
                return this.ptr - 1;
            }

            public void set(byte v) {
                if (this.lptr == -1) {
                    Exceptions.noElementToSet();
                }
                AbstractByteList.this.set(this.lptr, v);
            }
        };
    }

    public byte removeElementAt(int index) {
        Exceptions.unsupported("removeElementAt");
        throw new RuntimeException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteList)) {
            return false;
        }
        ByteListIterator i1 = this.listIterator();
        ByteListIterator i2 = ((ByteList)obj).listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next() == i2.next()) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public int hashCode() {
        int h = 1;
        ByteIterator i = this.iterator();
        while (i.hasNext()) {
            h = 31 * h + DefaultByteHashFunction.INSTANCE.hash(i.next());
        }
        return h;
    }

    public abstract byte set(int var1, byte var2);

    public abstract byte get(int var1);
}

