/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.adapter.IntListIteratorToListIteratorAdapter;
import bak.pcj.list.IntList;
import bak.pcj.util.Exceptions;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ListIterator;

public class IntListToListAdapter
extends AbstractList {
    protected IntList list;

    public IntListToListAdapter(IntList list) {
        if (list == null) {
            Exceptions.nullArgument("list");
        }
        this.list = list;
    }

    public boolean addAll(int index, Collection c) {
        if (index > this.size() || index < 0) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        return super.addAll(index, c);
    }

    public void add(int index, Object o) {
        if (o == null) {
            Exceptions.nullElementNotAllowed();
        }
        this.list.add(index, (Integer)o);
    }

    public Object get(int index) {
        return new Integer(this.list.get(index));
    }

    public ListIterator listIterator(int index) {
        return new IntListIteratorToListIteratorAdapter(this.list.listIterator(index));
    }

    public Object remove(int index) {
        return new Integer(this.list.removeElementAt(index));
    }

    public boolean removeAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.retainAll(c);
    }

    public Object set(int index, Object o) {
        if (o == null) {
            Exceptions.nullElementNotAllowed();
        }
        return new Integer(this.list.set(index, (Integer)o));
    }

    public int size() {
        return this.list.size();
    }
}

