/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.RecordConversion;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.util.RecordConversion.FragmentTransformationException;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;

public abstract class FragmentTransformer {
    protected String from;
    protected String to;
    protected Map props;
    protected Map context;
    protected Pattern from_pattern;
    protected ApplicationContext ctx;
    private static Log log = LogFactory.getLog(FragmentTransformer.class);

    private FragmentTransformer() {
    }

    public FragmentTransformer(String from, String to, Map properties, Map context, ApplicationContext ctx) {
        this.from = from;
        this.to = to;
        this.context = context;
        this.props = properties;
        this.ctx = ctx;
        try {
            this.from_pattern = Pattern.compile(from);
        }
        catch (IllegalArgumentException iae) {
            log.error((Object)"Problem compiling from pattern:", (Throwable)iae);
            throw new RuntimeException(iae);
        }
    }

    public void setProperty(String prop_name, Object value) {
        this.props.put(prop_name, value);
    }

    public Object getProperty(String prop_name) {
        return this.props.get(prop_name);
    }

    public String getFromSchema() {
        return this.from;
    }

    public String getToSchema() {
        return this.to;
    }

    public boolean isApplicableTo(String input_spec) {
        return this.from.equalsIgnoreCase(input_spec);
    }

    public abstract Object transform(Document var1, Map var2) throws FragmentTransformationException;
}

