/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.wfs.WFSContentState;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDiff;
import org.geotools.data.wfs.WFSFeatureSource;
import org.geotools.data.wfs.WFSFeatureWriter;
import org.geotools.data.wfs.WFSLocalTransactionState;
import org.geotools.data.wfs.WFSRemoteTransactionState;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

class WFSFeatureStore
extends ContentFeatureStore {
    private WFSFeatureSource delegate;

    public WFSFeatureStore(WFSFeatureSource source) {
        super(source.getEntry(), null);
        this.delegate = source;
    }

    public boolean canReproject() {
        return this.delegate.canReproject();
    }

    public boolean canLock() {
        return false;
    }

    protected boolean canEvent() {
        return true;
    }

    public WFSDataStore getDataStore() {
        return this.delegate.getDataStore();
    }

    public ContentEntry getEntry() {
        return this.delegate.getEntry();
    }

    public ResourceInfo getInfo() {
        return this.delegate.getInfo();
    }

    public Name getName() {
        return this.delegate.getName();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.delegate.getQueryCapabilities();
    }

    public WFSContentState getState() {
        return (WFSContentState)this.delegate.getState();
    }

    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.delegate.buildFeatureType();
    }

    protected int getCountInternal(Query query) throws IOException {
        return this.delegate.getCount(query);
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        return this.delegate.getBoundsInternal(query);
    }

    protected boolean canFilter() {
        return this.delegate.canFilter();
    }

    protected boolean canSort() {
        return this.delegate.canSort();
    }

    protected boolean canRetype() {
        return this.delegate.canRetype();
    }

    protected boolean canLimit() {
        return this.delegate.canLimit();
    }

    protected boolean canOffset() {
        return this.delegate.canOffset();
    }

    protected boolean canTransact() {
        return true;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return this.delegate.getReaderInternal(query);
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return this.delegate.handleVisitor(query, visitor);
    }

    public void setTransaction(Transaction transaction) {
        super.setTransaction(transaction);
        if (this.delegate.getTransaction() != transaction) {
            this.delegate.setTransaction(transaction);
        }
    }

    protected WFSFeatureWriter getWriterInternal(Query query, int flags) throws IOException {
        boolean autoCommit;
        WFSLocalTransactionState localState;
        query = this.joinQuery(query);
        query = this.resolvePropertyNames(query);
        if (Transaction.AUTO_COMMIT.equals(this.getTransaction())) {
            localState = this.getState().getLocalTransactionState();
            autoCommit = true;
        } else {
            autoCommit = false;
            Transaction.State state = this.transaction.getState((Object)this.getEntry());
            localState = (WFSLocalTransactionState)state;
        }
        return new WFSFeatureWriter(this, localState, (FeatureReader<SimpleFeatureType, SimpleFeature>)this.getReader(query), autoCommit);
    }

    public void modifyFeatures(Name[] properties, Object[] values, Filter filter) throws IOException {
        ReferencedEnvelope before;
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        filter = this.resolvePropertyNames(filter);
        QName typeName = this.getDataStore().getRemoteTypeName(this.getName());
        WFSClient wfsClient = this.getDataStore().getWfsClient();
        Filter[] splitFilters = wfsClient.splitFilters(typeName, filter);
        Filter unsupported = splitFilters[1];
        if (!Filter.INCLUDE.equals(unsupported)) {
            super.modifyFeatures(properties, values, filter);
            return;
        }
        WFSContentState contentState = this.getState();
        ReferencedEnvelope affectedBounds = new ReferencedEnvelope(this.getInfo().getCRS());
        if (contentState.hasListener() && (before = this.getBounds(new Query(this.getSchema().getTypeName(), filter))) != null && !before.isEmpty()) {
            affectedBounds = before;
        }
        Transaction transaction = this.getTransaction();
        try (FeatureReader oldFeatures = this.getReader(filter);){
            WFSLocalTransactionState localState;
            if (Transaction.AUTO_COMMIT.equals(transaction)) {
                localState = this.getState().getLocalTransactionState();
                WFSRemoteTransactionState committingState = new WFSRemoteTransactionState(this.getDataStore());
                committingState.watch(localState.getState());
                WFSDiff diff = localState.getDiff();
                ReferencedEnvelope bounds = diff.batchModify(properties, values, filter, (FeatureReader<SimpleFeatureType, SimpleFeature>)oldFeatures, contentState);
                affectedBounds.expandToInclude((Envelope)bounds);
                committingState.commit();
            } else {
                localState = (WFSLocalTransactionState)transaction.getState((Object)this.getEntry());
                WFSDiff diff = localState.getDiff();
                ReferencedEnvelope bounds = diff.batchModify(properties, values, filter, (FeatureReader<SimpleFeatureType, SimpleFeature>)oldFeatures, contentState);
                affectedBounds.expandToInclude((Envelope)bounds);
            }
            if (contentState.hasListener()) {
                FeatureEvent event = new FeatureEvent((Object)this, FeatureEvent.Type.CHANGED, affectedBounds, filter);
                contentState.fireFeatureEvent(event);
            }
        }
    }
}

