/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.RollbackException;
import com.sleepycat.je.rep.RollbackProhibitedException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.LocalCBVLSNTracker;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.Replay;
import com.sleepycat.je.rep.stream.InputWireRecord;
import com.sleepycat.je.rep.stream.MatchpointSearchResults;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.stream.ReplicaSyncupReader;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicaFeederSyncup {
    private final Logger logger;
    private final NamedChannel namedChannel;
    private final Protocol protocol;
    private final RepNode repNode;
    private final VLSNIndex vlsnIndex;
    private final Replay replay;
    private final RepImpl repImpl;
    private VLSN matchpointVLSN = VLSN.NULL_VLSN;
    private Long matchedVLSNTime = 0L;
    private final MatchpointSearchResults searchResults;
    private static TestHook<Object> globalSyncupEndHook;
    private TestHook<Object> syncupEndHook;

    public ReplicaFeederSyncup(RepNode repNode, Replay replay, NamedChannel namedChannel, Protocol protocol) {
        this.replay = replay;
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.repNode = repNode;
        this.vlsnIndex = repNode.getVLSNIndex();
        this.namedChannel = namedChannel;
        this.protocol = protocol;
        this.repImpl = repNode.getRepImpl();
        this.searchResults = new MatchpointSearchResults(repNode.getRepImpl());
        this.syncupEndHook = repNode.replica().getReplicaFeederSyncupHook();
    }

    public long getMatchedVLSNTime() {
        return this.matchedVLSNTime;
    }

    public VLSN getMatchedVLSN() {
        return this.matchpointVLSN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(LocalCBVLSNTracker cbvlsnTracker) throws IOException, DatabaseException, InterruptedException, InsufficientLogException {
        long startTime = System.currentTimeMillis();
        String feederName = this.namedChannel.getNameIdPair().getName();
        LoggerUtils.info(this.logger, this.repImpl, "Replica-feeder " + feederName + " syncup started. Replica range: " + this.repNode.getVLSNIndex().getRange());
        this.repNode.syncupStarted();
        try {
            VLSNRange range = this.vlsnIndex.getRange();
            this.findMatchpoint(range);
            this.verifyRollback(range);
            this.replay.rollback(this.matchpointVLSN, this.searchResults.getMatchpointLSN());
            VLSN startVLSN = this.matchpointVLSN.getNext();
            this.vlsnIndex.truncateFromTail(startVLSN, this.searchResults.getMatchpointLSN());
            Protocol protocol = this.protocol;
            protocol.getClass();
            this.protocol.write((BinaryProtocol.Message)protocol.new Protocol.StartStream(startVLSN), this.namedChannel);
            LoggerUtils.info(this.logger, this.repImpl, "Replica-feeder " + feederName + " start stream at VLSN: " + startVLSN);
            cbvlsnTracker.registerMatchpoint(startVLSN);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            assert (this.runHook());
            this.repNode.syncupEnded();
            LoggerUtils.info(this.logger, this.repImpl, String.format("Replica-feeder " + feederName + " syncup ended. Elapsed time: %,dms", System.currentTimeMillis() - startTime));
            throw throwable;
        }
        assert (this.runHook());
        this.repNode.syncupEnded();
        LoggerUtils.info(this.logger, this.repImpl, String.format("Replica-feeder " + feederName + " syncup ended. Elapsed time: %,dms", System.currentTimeMillis() - startTime));
    }

    private void verifyRollback(VLSNRange range) throws RollbackException, InsufficientLogException, IOException {
        VLSN lastTxnEnd = range.getLastTxnEnd();
        VLSN lastSync = range.getLastSync();
        LoggerUtils.finest(this.logger, this.repImpl, "verify rollback vlsn range=" + range + " searchResults=" + this.searchResults);
        if (lastTxnEnd.isNull()) {
            if (range.getLastSync().isNull() && !this.matchpointVLSN.isNull()) {
                throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "Shouldn't be possible to find a matchpoint of " + this.matchpointVLSN + " when the sync VLSN is null. Range=" + range);
            }
            LoggerUtils.fine(this.logger, this.repImpl, "normal rollback, no txn end");
            return;
        }
        if (lastSync.isNull()) {
            throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "Shouldn't be possible to have a null sync VLSN when the  lastTxnVLSN " + lastTxnEnd + " is not null. Range=" + range);
        }
        if (this.matchpointVLSN.isNull()) {
            LoggerUtils.info(this.logger, this.repImpl, "This node had a txn end at vlsn = " + lastTxnEnd + "but no matchpoint found.");
            throw this.setupLogRefresh(this.matchpointVLSN);
        }
        if (lastTxnEnd.compareTo(this.matchpointVLSN) <= 0 && this.searchResults.getNumPassedCommits() == 0) {
            LoggerUtils.fine(this.logger, this.repImpl, "txn end vlsn of " + lastTxnEnd + "<= matchpointVLSN of " + this.matchpointVLSN + ", normal rollback");
            return;
        }
        if (this.searchResults.getPassedCheckpointEnd()) {
            LoggerUtils.info(this.logger, this.repImpl, "matchpointVLSN of " + this.matchpointVLSN + " precedes a checkpoint end, " + "needs network restore.");
            throw this.setupLogRefresh(this.matchpointVLSN);
        }
        RepImpl envImpl = this.repNode.getRepImpl();
        int rollbackTxnLimit = envImpl.getConfigManager().getInt(RepParams.TXN_ROLLBACK_LIMIT);
        if (this.searchResults.getNumPassedCommits() > rollbackTxnLimit) {
            LoggerUtils.severe(this.logger, this.repImpl, "Limited list of transactions that would  be truncated for hard recovery:\n" + this.searchResults.dumpPassedTxns());
            throw new RollbackProhibitedException(this.repNode.getRepImpl(), rollbackTxnLimit, this.matchpointVLSN, this.searchResults);
        }
        throw this.setupHardRecovery(range);
    }

    private void findMatchpoint(VLSNRange range) throws IOException, InterruptedException, InsufficientLogException {
        ReplicaSyncupReader backwardsReader;
        OutputWireRecord replicaRecord;
        VLSN candidateMatchpoint = range.getLastSync();
        if (candidateMatchpoint.equals(VLSN.NULL_VLSN)) {
            this.getFeederRecord(range, VLSN.FIRST_VLSN, false);
            return;
        }
        InputWireRecord feederRecord = this.getFeederRecord(range, candidateMatchpoint, true);
        candidateMatchpoint = feederRecord.getVLSN();
        if (this.logger.isLoggable(Level.FINE)) {
            LoggerUtils.fine(this.logger, this.repImpl, "first candidate matchpoint: " + candidateMatchpoint);
        }
        if (!(replicaRecord = (backwardsReader = this.setupBackwardsReader(candidateMatchpoint)).scanBackwards(candidateMatchpoint)).match(feederRecord)) {
            do {
                if ((replicaRecord = backwardsReader.findPrevSyncEntry()) == null) {
                    LoggerUtils.info(this.logger, this.repImpl, "Looking at candidate matchpoint vlsn " + candidateMatchpoint + " but this node went past its available" + " contiguous VLSN range, need network" + " restore.");
                    throw this.setupLogRefresh(candidateMatchpoint);
                }
                candidateMatchpoint = replicaRecord.getVLSN();
                if (!this.logger.isLoggable(Level.FINE)) continue;
                LoggerUtils.fine(this.logger, this.repImpl, "Next candidate matchpoint: " + candidateMatchpoint);
            } while (!replicaRecord.match(feederRecord = this.getFeederRecord(range, candidateMatchpoint, false)));
        }
        this.matchedVLSNTime = replicaRecord.getTimeStamp();
        this.matchpointVLSN = candidateMatchpoint;
        this.searchResults.setMatchpoint(backwardsReader.getLastLsn());
        LoggerUtils.finest(this.logger, this.repImpl, "after setting  matchpoint, searchResults=" + this.searchResults);
    }

    private ReplicaSyncupReader setupBackwardsReader(VLSN candidateMatchpoint) throws IOException {
        RepImpl envImpl = this.repNode.getRepImpl();
        int readBufferSize = envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        return new ReplicaSyncupReader(envImpl, this.repNode.getVLSNIndex(), envImpl.getFileManager().getLastUsedLsn(), readBufferSize, this.repNode.getNameIdPair(), candidateMatchpoint, DbLsn.makeLsn(this.repNode.getCleanerBarrierFile(), 0), this.searchResults);
    }

    private InsufficientLogException setupLogRefresh(VLSN failedMatchpoint) throws IOException {
        Protocol protocol = this.protocol;
        protocol.getClass();
        this.protocol.write((BinaryProtocol.Message)protocol.new Protocol.RestoreRequest(failedMatchpoint), this.namedChannel);
        Protocol.RestoreResponse response = (Protocol.RestoreResponse)this.protocol.read(this.namedChannel);
        return new InsufficientLogException(this.repNode, response.getCBVLSN(), new HashSet<ReplicationNode>(Arrays.asList(response.getLogProviders())));
    }

    public RollbackException setupHardRecovery(VLSNRange range) throws IOException {
        RollbackException r = new RollbackException(this.repImpl, range.getLastTxnEnd(), this.matchpointVLSN, this.searchResults);
        LoggerUtils.severe(this.logger, this.repImpl, "Limited list of transactions truncated for hard recovery:\n" + this.searchResults.dumpPassedTxns());
        long matchpointLSN = this.searchResults.getMatchpointLSN();
        this.repImpl.getFileManager().truncateLog(DbLsn.getFileNumber(matchpointLSN), DbLsn.getFileOffset(matchpointLSN));
        return r;
    }

    private InputWireRecord getFeederRecord(VLSNRange range, VLSN requestVLSN, boolean acceptAlternative) throws IOException, InsufficientLogException {
        Protocol protocol = this.protocol;
        protocol.getClass();
        this.protocol.write((BinaryProtocol.Message)protocol.new Protocol.EntryRequest(requestVLSN), this.namedChannel);
        BinaryProtocol.Message message = this.protocol.read(this.namedChannel);
        if (message instanceof Protocol.Entry) {
            Protocol.Entry entry = (Protocol.Entry)message;
            return entry.getWireRecord();
        }
        if (message instanceof Protocol.EntryNotFound) {
            LoggerUtils.info(this.logger, this.repImpl, "Requested " + requestVLSN + " from " + this.namedChannel.getNameIdPair() + " but that node did not have that vlsn.");
            throw this.setupLogRefresh(requestVLSN);
        }
        if (acceptAlternative && message instanceof Protocol.AlternateMatchpoint) {
            Protocol.AlternateMatchpoint alt = (Protocol.AlternateMatchpoint)message;
            InputWireRecord feederRecord = alt.getAlternateWireRecord();
            VLSN altMatchpoint = feederRecord.getVLSN();
            if (range.getFirst().compareTo(altMatchpoint) > 0) {
                throw this.setupLogRefresh(altMatchpoint);
            }
            return feederRecord;
        }
        throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "Sent EntryRequest, got unexpected response of " + message);
    }

    public static void setGlobalSyncupEndHook(TestHook<Object> syncupEndHook) {
        globalSyncupEndHook = syncupEndHook;
    }

    private boolean runHook() throws InterruptedException {
        if (this.syncupEndHook != null) {
            this.syncupEndHook.doHook();
        }
        if (globalSyncupEndHook != null) {
            globalSyncupEndHook.doHook();
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TestHook<T> {
        public void doHook() throws InterruptedException;
    }
}

