/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.io.output.WriterOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.SupportAware;

@SupportedResourceType(value=ResourceType.JS)
public class NgAnnotateProcessor
implements ResourcePreProcessor,
ResourcePostProcessor,
SupportAware {
    public static final String ALIAS = "ngAnnotate";
    private static final Logger LOG = LoggerFactory.getLogger(NgAnnotateProcessor.class);
    private static final String NGANN_COMMAND = "ng-annotate --single_quotes -a -";

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        WriterOutputStream out = new WriterOutputStream(writer);
        ReaderInputStream in = new ReaderInputStream(reader);
        try {
            this.doProcess((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.warn("Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)ex);
            throw ex;
        }
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    void doProcess(InputStream in, OutputStream out) throws IOException {
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(out, (OutputStream)errorStream, in));
        int result = executor.execute(CommandLine.parse((String)NGANN_COMMAND));
        LOG.debug("result={}", (Object)result);
        if (result != 0) {
            throw new ExecuteException("Processing failed: " + new String(errorStream.toByteArray()), result);
        }
    }

    public boolean isSupported() {
        boolean supported = true;
        try {
            ByteArrayInputStream input = new ByteArrayInputStream("".getBytes("UTF-8"));
            this.doProcess(input, null);
        }
        catch (Exception e) {
            LOG.debug("The {} processor is not supported. Because: {}", (Object)this.getClass().getName(), (Object)e.getMessage());
            supported = false;
        }
        return supported;
    }
}

