/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.sftp;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import org.apache.commons.io.FileUtils;
import org.fao.geonet.Logger;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.sftp.Harvester;
import org.fao.geonet.kernel.harvest.harvester.sftp.SftpHarvesterUtil;
import org.fao.geonet.kernel.harvest.harvester.sftp.SftpParams;
import org.fao.geonet.kernel.harvest.harvester.sftp.client.KeyPairGeneratorUtil;
import org.fao.geonet.resources.Resources;
import org.springframework.util.StringUtils;

public class SftpHarvester
extends AbstractHarvester<HarvestResult, SftpParams> {
    @Override
    protected SftpParams createParams() {
        return new SftpParams(this.dataMan);
    }

    @Override
    protected void storeNodeExtra(SftpParams params, String path, String siteId, String optionsId) throws SQLException {
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"server", (Object)params.server);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"port", (Object)params.port);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"icon", (Object)params.icon);
        this.harvesterSettingsManager.add("id:" + optionsId, (Object)"folder", (Object)params.folder);
        this.harvesterSettingsManager.add("id:" + optionsId, (Object)"recurse", (Object)params.recurse);
        this.harvesterSettingsManager.add("id:" + optionsId, (Object)"useAuthKey", (Object)params.useAuthKey);
        this.harvesterSettingsManager.add("id:" + optionsId, (Object)"validate", (Object)params.getValidate());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"xslfilter", (Object)params.xslfilter);
        if (!(!params.useAuthKey || StringUtils.hasLength((String)params.publicKey) && ((SftpParams)this.getParams()).typeAuthKey.equals(params.typeAuthKey))) {
            try {
                int keyType = "ECDSA".equals(params.typeAuthKey) ? 3 : 2;
                KeyPair keyPair = KeyPairGeneratorUtil.generatePrivatePublicKeys(keyType);
                String serverHost = this.settingManager.getValue("system/server/host");
                KeyPairGeneratorUtil.savePrivateKey(keyPair, SftpHarvesterUtil.getPrivateKeyFilePath(this.context, params.getUuid()));
                KeyPairGeneratorUtil.savePublicKey(keyPair, SftpHarvesterUtil.getPublicKeyFilePath(this.context, params.getUuid()), serverHost);
                params.publicKey = FileUtils.readFileToString((File)SftpHarvesterUtil.getPublicKeyFilePath(this.context, params.getUuid()).toFile(), (Charset)StandardCharsets.UTF_8);
            }
            catch (JSchException | IOException ex) {
                this.log.error(ex.getMessage(), ex);
            }
        }
        this.harvesterSettingsManager.add("id:" + optionsId, (Object)"publicKey", (Object)params.publicKey);
        this.harvesterSettingsManager.add("id:" + optionsId, (Object)"typeAuthKey", (Object)params.typeAuthKey);
    }

    @Override
    public void doHarvest(Logger log) throws Exception {
        log.info("Sftp doHarvest start");
        Harvester h = new Harvester(this.cancelMonitor, log, this.context, (SftpParams)this.params, this.errors);
        this.result = h.harvest(log);
        log.info("Sftp doHarvest end");
    }

    @Override
    protected void doDestroy(Resources resources) {
        super.doDestroy(resources);
        FileUtils.deleteQuietly((File)SftpHarvesterUtil.getPrivateKeyFilePath(this.context, ((SftpParams)this.params).getUuid()).toFile());
        FileUtils.deleteQuietly((File)SftpHarvesterUtil.getPublicKeyFilePath(this.context, ((SftpParams)this.params).getUuid()).toFile());
    }
}

