/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.sftp;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Logger;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.IHarvester;
import org.fao.geonet.kernel.harvest.harvester.sftp.Aligner;
import org.fao.geonet.kernel.harvest.harvester.sftp.SftpParams;

public class Harvester
implements IHarvester<HarvestResult> {
    private final AtomicBoolean cancelMonitor;
    private final SftpParams params;
    private final ServiceContext context;
    private Logger log;
    private final List<HarvestError> errors;

    public Harvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, SftpParams params, List<HarvestError> errors) {
        this.cancelMonitor = cancelMonitor;
        this.log = log;
        this.context = context;
        this.params = params;
        this.errors = errors;
    }

    @Override
    public HarvestResult harvest(Logger log) throws Exception {
        this.log = log;
        if (this.cancelMonitor.get()) {
            return new HarvestResult();
        }
        boolean error = false;
        HarvestResult result = new HarvestResult();
        try {
            Aligner aligner = new Aligner(this.cancelMonitor, this.context, this.params, log);
            result = aligner.align(this.errors);
        }
        catch (Exception t) {
            error = true;
            log.error("Unknown error trying to harvest");
            log.error(t.getMessage());
            log.error((Throwable)t);
            this.errors.add(new HarvestError(this.context, t));
        }
        if (error) {
            log.warning("Due to previous errors the align process has not been called");
        }
        return result;
    }
}

