/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services;

import java.io.IOException;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.NotImplementedException;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.exceptions.MissingParameterEx;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.jdom.Element;

public class Utils {
    public static String getIdentifierFromParameters(Element params, ServiceContext context, String uuidParamName, String idParamName) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        IMetadataUtils dm = gc.getBean(IMetadataUtils.class);
        String id = Utils.lookupByFileId(params, gc);
        if (id == null) {
            try {
                MetadataDraft draft;
                AccessManager am;
                String uuid = Util.getParam((Element)params, (String)uuidParamName);
                id = dm.getMetadataId(uuid);
                Boolean approved = Util.getParam((Element)params, (String)"approved", (boolean)true);
                if (!approved.booleanValue() && (am = context.getBean(AccessManager.class)).canEdit(context, id) && (draft = gc.getBean(MetadataDraftRepository.class).findOneByUuid(uuid)) != null) {
                    id = String.valueOf(draft.getId());
                }
            }
            catch (MissingParameterEx x) {
                try {
                    id = Util.getParam((Element)params, (String)idParamName);
                }
                catch (MissingParameterEx xx) {
                    throw new Exception("Request must contain a UUID (" + uuidParamName + ") or an ID (" + idParamName + ")");
                }
            }
        }
        return id;
    }

    private static String lookupByFileId(Element params, GeonetContext gc) throws Exception {
        String fileId = Util.getParam((Element)params, (String)"fileIdentifier", null);
        if (fileId == null) {
            return null;
        }
        return Utils.lookupMetadataIdFromFileId(gc, fileId);
    }

    public static String lookupMetadataIdFromFileId(GeonetContext gc, String fileId) throws IOException, InterruptedException {
        EsSearchManager searchManager = gc.getBean(EsSearchManager.class);
        return Utils.lookupMetadataIdFromFileId(fileId, searchManager);
    }

    public static String lookupMetadataIdFromFileId(String fileId, EsSearchManager searchManager) throws IOException, InterruptedException {
        throw new NotImplementedException("lookupMetadataIdFromFileId not implemented in ES. This is not used by the REST API see ApiUtils#getRecord. Maybe can be removed");
    }

    public static String getIdentifierFromParameters(Element params, ServiceContext context) throws Exception {
        return Utils.getIdentifierFromParameters(params, context, "uuid", "id");
    }
}

