/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.DatabaseMigrationTask;
import org.fao.geonet.migration.DatabaseMigrationException;
import org.fao.geonet.utils.Log;

public abstract class JsonDatabaseMigration
extends DatabaseMigrationTask {
    @Override
    public void update(Connection connection) throws SQLException {
        block26: {
            try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM settings WHERE name=?");){
                String currentSettingJson;
                statement.setString(1, this.getSettingName());
                ResultSet rs = statement.executeQuery();
                if (!rs.next() || !StringUtils.isNotEmpty((String)(currentSettingJson = rs.getString("value")))) break block26;
                Map<String, String> fieldsToUpdate = this.setUpNewSettingValues();
                String newSettingJson = this.insertOrUpdateField(currentSettingJson, fieldsToUpdate);
                try (PreparedStatement updateStatement = connection.prepareStatement("UPDATE settings SET value=? WHERE name=?");){
                    updateStatement.setString(1, newSettingJson);
                    updateStatement.setString(2, this.getSettingName());
                    updateStatement.executeUpdate();
                }
            }
            catch (IOException e) {
                Log.error((String)"geonetwork.databasemigration", (String)"Error in AdvancedSearchFormMigration. Cannot complete the migration", (Throwable)e);
                throw new DatabaseMigrationException(e);
            }
        }
    }

    @VisibleForTesting
    protected String insertOrUpdateField(String currentSettingJson, Map<String, String> fieldsToUpdate) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree(currentSettingJson);
        for (Map.Entry<String, String> fieldToUpdate : fieldsToUpdate.entrySet()) {
            String fullPath = fieldToUpdate.getKey();
            String newJsonString = fieldToUpdate.getValue();
            JsonNode newJsonTree = mapper.readTree(newJsonString);
            JsonNode target = root.at(fullPath);
            LinkedList<String> pathParts = new LinkedList<String>();
            pathParts.addAll(Arrays.asList(StringUtils.split((String)fullPath, (String)"/")));
            if (target.isMissingNode()) {
                this.createMissingNodes(root, pathParts, newJsonTree);
                continue;
            }
            String propertyName = (String)pathParts.remove(pathParts.size() - 1);
            target = root.at("/" + StringUtils.join(pathParts, (String)"/"));
            ((ObjectNode)target).set(propertyName, newJsonTree);
        }
        return mapper.writeValueAsString((Object)root);
    }

    @VisibleForTesting
    protected void createMissingNodes(JsonNode root, List<String> fullPath, JsonNode newJsonTree) {
        JsonNode newRoot = root;
        for (int i = 0; i < fullPath.size() - 1; ++i) {
            String pathPart = fullPath.get(i);
            newRoot = newRoot.with(pathPart);
        }
        ((ObjectNode)newRoot).set(fullPath.get(fullPath.size() - 1), newJsonTree);
    }

    protected abstract Map<String, String> setUpNewSettingValues();

    protected abstract String getSettingName();
}

