/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.kernel.security.GeonetworkAuthenticationProvider;
import org.fao.geonet.kernel.security.openidconnect.OIDCConfiguration;
import org.fao.geonet.kernel.security.openidconnect.OIDCRoleProcessor;
import org.fao.geonet.kernel.security.openidconnect.SimpleOidcUser;
import org.fao.geonet.kernel.security.openidconnect.SimpleOidcUserFactory;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.util.StringUtils;

public class OidcUser2GeonetworkUser {
    @Autowired
    protected OIDCConfiguration oidcConfiguration;
    @Autowired
    protected OIDCRoleProcessor oidcRoleProcessor;
    @Autowired
    protected SimpleOidcUserFactory simpleOidcUserFactory;
    @Autowired
    protected UserRepository userRepository;
    @Autowired
    protected GroupRepository groupRepository;
    @Autowired
    protected LanguageRepository langRepository;
    @Autowired
    protected UserGroupRepository userGroupRepository;
    @Autowired
    protected GeonetworkAuthenticationProvider geonetworkAuthenticationProvider;

    public UserDetails getUserDetails(Map attributes, boolean withDbUpdate) throws Exception {
        User user;
        SimpleOidcUser simpleUser = this.simpleOidcUserFactory.create(attributes);
        if (!StringUtils.hasText((String)simpleUser.getUsername())) {
            return null;
        }
        if (!this.oidcConfiguration.isUpdateProfile()) {
            simpleUser.setProfile("");
        }
        boolean newUserFlag = false;
        try {
            user = (User)this.geonetworkAuthenticationProvider.loadUserByUsername(simpleUser.getUsername());
        }
        catch (UsernameNotFoundException e) {
            user = new User();
            user.setUsername(simpleUser.getUsername());
            newUserFlag = true;
            Log.debug((String)"geonetwork.security", (Object)("Adding a new user: " + user));
        }
        simpleUser.updateUser(user);
        Map<Profile, List<String>> profileGroups = this.oidcRoleProcessor.getProfileGroups(attributes);
        if (newUserFlag || this.oidcConfiguration.isUpdateProfile()) {
            user.setProfile(this.oidcRoleProcessor.getProfile(attributes));
        }
        if (withDbUpdate) {
            if (newUserFlag || this.oidcConfiguration.isUpdateProfile()) {
                this.userRepository.save((Object)user);
            }
            if (newUserFlag || this.oidcConfiguration.isUpdateGroup()) {
                this.updateGroups(profileGroups, user);
            }
        }
        return user;
    }

    public UserDetails getUserDetails(OidcIdToken idToken, Map attributes, boolean withDbUpdate) throws Exception {
        User user;
        SimpleOidcUser simpleUser = this.simpleOidcUserFactory.create(idToken, attributes);
        if (!StringUtils.hasText((String)simpleUser.getUsername())) {
            return null;
        }
        if (!this.oidcConfiguration.isUpdateProfile()) {
            simpleUser.setProfile("");
        }
        boolean newUserFlag = false;
        try {
            user = (User)this.geonetworkAuthenticationProvider.loadUserByUsername(simpleUser.getUsername());
        }
        catch (UsernameNotFoundException e) {
            user = new User();
            user.setUsername(simpleUser.getUsername());
            newUserFlag = true;
            Log.debug((String)"geonetwork.security", (Object)("Adding a new user: " + user));
        }
        simpleUser.updateUser(user);
        Map<Profile, List<String>> profileGroups = this.oidcRoleProcessor.getProfileGroups(idToken);
        if (newUserFlag || this.oidcConfiguration.isUpdateProfile()) {
            user.setProfile(this.oidcRoleProcessor.getProfile(idToken));
        }
        if (withDbUpdate) {
            if (newUserFlag || this.oidcConfiguration.isUpdateProfile()) {
                this.userRepository.save((Object)user);
            }
            if (newUserFlag || this.oidcConfiguration.isUpdateGroup()) {
                this.updateGroups(profileGroups, user);
            }
        }
        return user;
    }

    protected void updateGroups(Map<Profile, List<String>> profileGroups, User user) {
        HashSet<UserGroup> userGroups = new HashSet<UserGroup>();
        for (Profile p : profileGroups.keySet()) {
            List<String> groups = profileGroups.get(p);
            for (String rgGroup : groups) {
                Group group = this.groupRepository.findByName(rgGroup);
                if (group == null) {
                    group = new Group();
                    group.setName(rgGroup);
                    for (Language l : this.langRepository.findAll()) {
                        group.getLabelTranslations().put(l.getId(), group.getName());
                    }
                    this.groupRepository.save((Object)group);
                }
                UserGroup usergroup = new UserGroup();
                usergroup.setGroup(group);
                usergroup.setUser(user);
                Profile profile = p;
                if (profile.equals((Object)Profile.Administrator)) {
                    profile = Profile.UserAdmin;
                }
                usergroup.setProfile(profile);
                if (profile.equals((Object)Profile.Reviewer)) {
                    UserGroup ug = new UserGroup();
                    ug.setGroup(group);
                    ug.setUser(user);
                    ug.setProfile(Profile.Editor);
                    userGroups.add(ug);
                }
                userGroups.add(usergroup);
            }
        }
        this.userGroupRepository.updateUserGroups(user.getId(), userGroups);
    }
}

