/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.draft;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataIndexer;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;

public class DraftMetadataIndexer
extends BaseMetadataIndexer
implements IMetadataIndexer {
    @Autowired
    private MetadataDraftRepository metadataDraftRepository;
    @Autowired
    EsSearchManager searchManager;

    @Override
    public void init(ServiceContext context, Boolean force) throws Exception {
        super.init(context, force);
        this.metadataDraftRepository = context.getBean(MetadataDraftRepository.class);
        this.statusRepository = context.getBean(MetadataStatusRepository.class);
    }

    @Override
    protected Multimap<String, Object> addExtraFields(AbstractMetadata fullMd) {
        ArrayListMultimap extraFields = ArrayListMultimap.create();
        extraFields.putAll(super.addExtraFields(fullMd));
        if (fullMd instanceof MetadataDraft) {
            Log.trace((String)"geonetwork.datamanager", (Object)("We are indexing a draft with uuid " + fullMd.getUuid()));
            extraFields.put((Object)"draft", (Object)"y");
        } else {
            MetadataDraft metadataDraft = this.metadataDraftRepository.findOneByUuid(fullMd.getUuid());
            if (metadataDraft != null) {
                MetadataStatus stat;
                Log.trace((String)"geonetwork.datamanager", (Object)("We are indexing a record with a draft associated with uuid " + fullMd.getUuid()));
                extraFields.put((Object)"draft", (Object)"e");
                extraFields.put((Object)"draftId", (Object)metadataDraft.getId());
                String status = "";
                String statusDraft = "";
                Sort statusSort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{MetadataStatus_.changeDate.getName()});
                List statuses = this.statusRepository.findAllByMetadataIdAndByType(fullMd.getId(), StatusValueType.workflow, statusSort);
                if (!statuses.isEmpty()) {
                    stat = (MetadataStatus)statuses.get(0);
                    status = String.valueOf(stat.getStatusValue().getName());
                }
                if (!(statuses = this.statusRepository.findAllByMetadataIdAndByType(metadataDraft.getId(), StatusValueType.workflow, statusSort)).isEmpty()) {
                    stat = (MetadataStatus)statuses.get(0);
                    statusDraft = String.valueOf(stat.getStatusValue().getName());
                }
                extraFields.put((Object)"statusWorkflow", (Object)(status + "-" + statusDraft));
            } else {
                Log.trace((String)"geonetwork.datamanager", (Object)("We are indexing a record with no draft associated with uuid " + fullMd.getUuid()));
                extraFields.put((Object)"draft", (Object)"n");
                Sort statusSort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{MetadataStatus_.changeDate.getName()});
                List statuses = this.statusRepository.findAllByMetadataIdAndByType(fullMd.getId(), StatusValueType.workflow, statusSort);
                if (!statuses.isEmpty()) {
                    MetadataStatus stat = (MetadataStatus)statuses.get(0);
                    String status = String.valueOf(stat.getStatusValue().getName());
                    extraFields.put((Object)"statusWorkflow", (Object)status);
                }
            }
        }
        return extraFields;
    }
}

